/*
 * bqpx.r.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>
#include <xfs.h>
#include <xls.h>

#define __HEAD_LEFT__			1

#define Q_21_				Q(21)

#define Q_42_				Q(42)

#define Q_63_				Q(63)

#undef Q
#define Q(e)				((integral_q) (e))

#define q_21_				(Q_21_ << (integral_q_bits - 6))

#define q_42_				(Q_42_ << (integral_q_bits - 6))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int east(void *, unsigned, unsigned *);
static int edge(void *, unsigned, unsigned *);

static int
east(void *node, unsigned call, unsigned *fare)
{
    integral_q news, slip;

    news = *KD(node);

    slip = news & ~Lx55555555;

    if (1) {
	if (call ^ (integral_q_bits - 1)) {
	    call++;

	    if (call & 1) {
		*KD(node) = news & ~(Q(1) << call);

		*fare = call - 2;

		KD(node)[call - 1] = KD(node)[call];
	    } else {
		if (news & (Q(1) << (call - 1))) {
		    *KD(node) = news & ~(Q(1) << (call - 1));
		    call--;
		    PD(node)[call] = PD(node)[call - 1];

		    *fare = call;
		} else {
		    if (news & (Q(1) << (call + 1))) {
			*fare = call - 3;

			*KD(node) = news & ~(Q(1) << (call + 1));
			if (call ^ 2) {
			    KD(node)[call - 2] = KD(node)[call];
			    KD(node)[call] = KD(node)[call + 1];
			    PD(node)[call - 1] = PD(node)[call];
			} else {
			    KD(node)[call] = KD(node)[call + 1];
			    PD(node)[call - 1] = PD(node)[call];
			}
		    } else {
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << call);
			if (back) {
			    l2_q_xfs(ever, back);
#if __HEAD_LEFT__
			    slip &= ((Q(1) << ever) - (Q(1) << call))
				>> (ever - call);
			    if (slip) {
				l2_q_xls(deck, slip);
				deck ^= integral_q_last;
				if (1) {
				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck - 3) >> 1;
				    call--;
				    *fare = call;
				    for (; ever; ever--) {
					PD(node)[call] = PD(node)[call - 2];
					call--;
					KD(node)[call] = KD(node)[call - 2];
					call--;
				    }
				    {
					PD(node)[call] = PD(node)[call - 2];
					call--;
					KD(node)[call] = KD(node)[call - 1];
					call--;
					PD(node)[call] = PD(node)[call - 1];
				    }
				}
			    } else {
				if (call ^ 2) {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call -= 2;
				    *fare = call - 1;
				    for (; deck; deck--) {
					KD(node)[call] = KD(node)[call + 2];
					call++;
					PD(node)[call] = PD(node)[call + 2];
					call++;
				    }
				    {
					KD(node)[call] = KD(node)[call + 2];
					call++;
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				} else {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call - 2;
				    for (; deck; deck--) {
					PD(node)[call] = PD(node)[call + 2];
					call++;
					KD(node)[call] = KD(node)[call + 2];
					call++;
				    }
				    {
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				}
			    }
#else
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (deck ^ integral_q_bits) {
				deck ^= integral_q_last;
				if (call - deck < ever - call) {
				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck - 3) >> 1;
				    call--;
				    *fare = call;
				    for (; ever; ever--) {
					PD(node)[call] = PD(node)[call - 2];
					call--;
					KD(node)[call] = KD(node)[call - 2];
					call--;
				    }
				    {
					PD(node)[call] = PD(node)[call - 2];
					call--;
					KD(node)[call] = KD(node)[call - 1];
					call--;
					PD(node)[call] = PD(node)[call - 1];
				    }
				} else {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call -= 2;
				    *fare = call - 1;
				    for (; deck; deck--) {
					KD(node)[call] = KD(node)[call + 2];
					call++;
					PD(node)[call] = PD(node)[call + 2];
					call++;
				    }
				    {
					KD(node)[call] = KD(node)[call + 2];
					call++;
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				}
			    } else {
				if (call ^ 2) {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call -= 2;
				    *fare = call - 1;
				    for (; deck; deck--) {
					KD(node)[call] = KD(node)[call + 2];
					call++;
					PD(node)[call] = PD(node)[call + 2];
					call++;
				    }
				    {
					KD(node)[call] = KD(node)[call + 2];
					call++;
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				} else {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call - 2;
				    for (; deck; deck--) {
					PD(node)[call] = PD(node)[call + 2];
					call++;
					KD(node)[call] = KD(node)[call + 2];
					call++;
				    }
				    {
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				}
			    }
#endif				/* __HEAD_LEFT__ */
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck - 3) >> 1;
				    call--;
				    *fare = call;
				    for (; ever; ever--) {
					PD(node)[call] = PD(node)[call - 2];
					call--;
					KD(node)[call] = KD(node)[call - 2];
					call--;
				    }
				    {
					PD(node)[call] = PD(node)[call - 2];
					call--;
					KD(node)[call] = KD(node)[call - 1];
					call--;
					PD(node)[call] = PD(node)[call - 1];
				    }
				}
			    }
			}
		    }
		}
	    }
	} else {
	    unsigned deck, ever;

	    l2_q_xls(deck, slip);
	    if (1) {
		deck ^= integral_q_last;
		if (deck ^ (integral_q_bits - 1)) {
		    *KD(node) = news & ~(Q(1) << deck);

		    PD(node)[integral_q_bits - 1] =
			PD(node)[integral_q_bits - 3];

		    *fare = call;

		    call--;

		    ever = (integral_q_bits - 3 - deck) >> 1;
		    for (; ever; ever--) {
			KD(node)[call] = KD(node)[call - 2];
			call--;
			PD(node)[call] = PD(node)[call - 2];
			call--;
		    }
		    {
			KD(node)[call] = KD(node)[call - 1];
			call--;
			PD(node)[call] = PD(node)[call - 1];
		    }
		} else {
		    *KD(node) = news & ~(Q(1) << deck);

		    *fare = call;

		    PD(node)[integral_q_bits - 1] =
			PD(node)[integral_q_bits - 2];
		}
	    }
	}
    }

    return 0;
}


static int
edge(void *node, unsigned call, unsigned *fare)
{
    integral_q news, slip;

    news = *KD(node);

    slip = news & ~Lx55555555;

    if (1) {
	if (1) {
	    call++;

	    if (call & 1) {
		*KD(node) = news & ~(Q(1) << call);

		*fare = call;
	    } else {
		if (news & (Q(1) << (call + 1))) {
		    *fare = call - 1;

		    *KD(node) = news & ~(Q(1) << (call + 1));
		    if (2) {
			KD(node)[call] = KD(node)[call + 1];
			PD(node)[call - 1] = PD(node)[call];
		    }
		} else {
		    if (news & (Q(1) << (call - 1))) {
			*KD(node) = news & ~(Q(1) << (call - 1));
			KD(node)[call] = KD(node)[call - 1];
			call--;
			PD(node)[call] = PD(node)[call - 1];

			*fare = call + 2;
		    } else {
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << call);
			if (back) {
			    l2_q_xfs(ever, back);
#if __HEAD_LEFT__
			    slip &= ((Q(1) << ever) - (Q(1) << call))
				>> (ever - call);
			    if (slip) {
				l2_q_xls(deck, slip);
				deck ^= integral_q_last;
				if (1) {
				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    *fare = call + 1;
				    for (; ever; ever--) {
					KD(node)[call] = KD(node)[call - 2];
					call--;
					PD(node)[call] = PD(node)[call - 2];
					call--;
				    }
				    {
					KD(node)[call] = KD(node)[call - 1];
					call--;
					PD(node)[call] = PD(node)[call - 1];
				    }
				}
			    } else {
				if (2) {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call;
				    for (; deck; deck--) {
					PD(node)[call] = PD(node)[call + 2];
					call++;
					KD(node)[call] = KD(node)[call + 2];
					call++;
				    }
				    {
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				}
			    }
#else
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (deck ^ integral_q_bits) {
				deck ^= integral_q_last;
				if (call - deck < ever - call) {
				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    *fare = call + 1;
				    for (; ever; ever--) {
					KD(node)[call] = KD(node)[call - 2];
					call--;
					PD(node)[call] = PD(node)[call - 2];
					call--;
				    }
				    {
					KD(node)[call] = KD(node)[call - 1];
					call--;
					PD(node)[call] = PD(node)[call - 1];
				    }
				} else {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call;
				    for (; deck; deck--) {
					PD(node)[call] = PD(node)[call + 2];
					call++;
					KD(node)[call] = KD(node)[call + 2];
					call++;
				    }
				    {
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				}
			    } else {
				if (2) {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call;
				    for (; deck; deck--) {
					PD(node)[call] = PD(node)[call + 2];
					call++;
					KD(node)[call] = KD(node)[call + 2];
					call++;
				    }
				    {
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				}
			    }
#endif				/* __HEAD_LEFT__ */
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    *fare = call + 1;
				    for (; ever; ever--) {
					KD(node)[call] = KD(node)[call - 2];
					call--;
					PD(node)[call] = PD(node)[call - 2];
					call--;
				    }
				    {
					KD(node)[call] = KD(node)[call - 1];
					call--;
					PD(node)[call] = PD(node)[call - 1];
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return 0;
}


int
_libx1f4l2_pack_bqpset(void *bqfset, void *date, integral_q *data,
		       integral_q **path, integral_q **lead, integral_q pipe,
		       void **lift, unsigned *mile, integral_q **lock,
		       integral_q **lane, integral_q **turn, integral_q *text,
		       void *near, integral_q mode)
{
    int half, status;
    integral_q away, *club, *file, *tier;
    unsigned call, fill = 0;
    void *node;

    club = *lead;

    file = *lock;

    tier = *lane;

    node = *lift;

    call = *mile;

    if (1) {
	if (call ^ integral_q_last) {
	    if (pipe & ((Q(1) << call) - 1) << 1) {
	    } else {
		if (1) {
		    if (mode < file[half_integral_q_bits]) {
			fill = 1;
		    } else {
		    }
		}
	    }
	} else {
	    if (mode < file[half_integral_q_bits]) {
	    } else {
		fill = 2;
	    }
	}
    }

    if (1) {
	integral_q *fast, pipe, *side;
	unsigned deck;

	fast = club;

	pipe = *fast & ~Lx55555555;

	if (pipe) {
	    integral_q news;

	    news = pipe;

	    if (news & Q_42_) {
		*fast = Lxdddddddd | Q(2);

		if (news & 2) {
		    fast += 4;

		    side = fast - 1;

		    *side = *fast;
		    fast += 2;
		    side++;
		} else {
		    if (news & 8) {
			fast += 2;

			side = fast - 1;

			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast += 2;
			side++;
		    } else {
			fast += 2;

			side = fast - 1;

			*side = *fast;
			fast += 2;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
		    }
		}
	    } else {
		fast += 4;

		side = fast - 1;

		*side = *fast;
		fast += 2;
		side++;
	    }

	    news |= Q(1) << (integral_q_bits - 2);
	    news >>= 6;

	    for (; !(news & Q_63_); news >>= 6) {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		fast += 2;
		side++;
		*side = *fast;
		fast += 2;
		side++;
	    }

	    if (news & ~((Q(1) << 6) - 1)) {
		*club = Lxdddddddd | Q(2) << (side - club);

		if (news & 2) {
		    *side = *fast;
		    fast++;
		    side++;
		    *side = *fast;
		    fast++;
		    side++;
		    *side = *fast;
		    fast += 2;
		    side++;
		    *side = *fast;
		    fast += 2;
		    side++;
		} else {
		    if (news & 8) {
			*side = *fast;
			fast += 2;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast += 2;
			side++;
		    } else {
			*side = *fast;
			fast += 2;
			side++;
			*side = *fast;
			fast += 2;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
		    }
		}

		news >>= 6;
	    }

	    for (; !(news & Q_21_); news >>= 6) {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		fast += 2;
		side++;
		*side = *fast;
		fast += 2;
		side++;
	    }

	    if (news & Q_42_) {
		*club = Lxdddddddd | Q(2) << (side - club);

		if (half_integral_q_bits % 3 ^ 2) {
		    *side = *fast;
		    fast++;
		    side++;
		    *side = *fast;
		    side++;
		    *side = **path;

		    fast = file;

		    fast += 2;
		    side++;
		    *side = *fast;
		    side++;
		} else {
		    *side = *fast;
		    if (news & 2) {
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
		    } else {
			fast += 2;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
		    }

		    side++;

		    *side = **path;

		    fast = file;

		    side++;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    *side = *fast;
		    side += 2;
		    *side = **path;

		    fast = file;

		    fast += 2;
		    side++;
		    *side = *fast;
		    side++;
		} else {
		    *side = *fast;
		    fast += 2;
		    side += 2;
		    *side = *fast;
		    side++;
		    *side = **path;

		    fast = file;

		    side++;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		fast += 2;
		*side = *fast;
		side += 2;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    fast += 2;

	    away = *fast;

	    if (fill) {
		half = fill - 1;
	    } else {
		half = mode < away;
	    }

	    news = pipe;

	    fast = club + integral_q_bits;

	    side = fast;

	    fast--;

	    news |= Q(1) << (integral_q_bits - 2);

	    for (; !(news & Q_42_); news >>= 6) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    if (news & ~((Q(1) << 6) - 1)) {
		if (news & 2) {
		    fast++;
		    *side = *fast;
		    side++;
		    fast++;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		} else {
		    if (news & 8) {
			fast += 2;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast += 2;
			*side = *fast;
			side++;
		    } else {
			fast += 2;
			*side = *fast;
			side++;
			fast += 2;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
		    }
		}

		news >>= 6;
	    }

	    for (; !(news & Q_21_); news >>= 6) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    if (news & Q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    fast++;
		    *side = *fast;
		    side++;
		    fast++;
		    *side = *fast;

		    fast = file + integral_q_bits + 1;

		    side++;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		} else {
		    if (news & 2) {
			fast++;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast += 2;
			*side = *fast;
		    } else {
			fast += 2;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
		    }

		    fast = file + integral_q_bits + 1;

		    side++;
		    *side = *fast;
		    side++;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    side++;
		    fast += 2;
		    *side = *fast;

		    fast = file + integral_q_bits + 1;

		    side++;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		} else {
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;

		    fast = file + integral_q_bits + 1;

		    side++;
		    *side = *fast;
		    side++;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }
	} else {
	    *fast = Lxdddddddd;

	    fast += 4;

	    side = fast - 1;

	    {
		*side = *fast;
		fast += 2;
		side++;
	    }

	    deck = integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		fast += 2;
		side++;
		*side = *fast;
		fast += 2;
		side++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		*side = *fast;
		side += 2;
		*side = **path;

		fast = file;

		fast += 2;
		side++;
		*side = *fast;
		side++;
	    } else {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		side++;
		*side = **path;

		fast = file;

		side++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		fast += 2;
		*side = *fast;
		side += 2;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    fast += 2;

	    away = *fast;

	    if (fill) {
		half = fill - 1;
	    } else {
		half = mode < away;
	    }

	    fast = club + integral_q_bits;

	    side = fast;

	    fast--;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		side++;
		fast += 2;
		*side = *fast;

		fast = file + integral_q_bits + 1;

		side++;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    } else {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;

		fast = file + integral_q_bits + 1;

		side++;
		*side = *fast;
		side++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }
	}
    }

    tier = *lane;

    if (1) {
	integral_q *fast, pipe, *side;
	unsigned deck;

	fast = tier;

	pipe = *tier & ~Lx55555555;

	if (pipe) {
	    integral_q news;

	    news = pipe;

	    fast += integral_q_bits << 1;

	    side = fast;

	    fast++;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    if (news & q_21_) {
	    } else {
		if (news & Q(1) << (integral_q_bits - 1)) {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    fast--;
		    *side = *fast;
		    side--;
		    fast--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    } else {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			fast++;
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    if (news & q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    fast--;
		    *side = *fast;

		    fast = file + (integral_q_bits << 1) - 1;

		    side--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		} else {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    if (news & Q(1) << (integral_q_bits - 1)) {
			side--;
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    } else {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    }

		    fast = file + (integral_q_bits << 1) - 1;

		    side--;
		    *side = *fast;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    side--;
		    fast -= 2;
		    *side = *fast;

		    fast = file + (integral_q_bits << 1) - 1;

		    side--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		} else {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;

		    fast = file + (integral_q_bits << 1) - 1;

		    side--;
		    *side = *fast;
		    side--;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    news = pipe;

	    fast = tier + integral_q_bits;

	    side = fast;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    if (news & q_21_) {
	    } else {
		*tier = Lxdddddddd | Q(2) << (side - tier - 4);

		if (news & Q(1) << (integral_q_bits - 1)) {
		    side--;
		    fast--;
		    *side = *fast;
		    side--;
		    fast--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
		    } else {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    if (news & q_42_) {
		*tier = Lxdddddddd | Q(2) << (side - tier - 4);

		if (half_integral_q_bits % 3 ^ 2) {
		    side--;
		    fast--;
		    *side = *fast;

		    fast = file + integral_q_bits - 2;

		    side--;
		    *side = **turn;
		    side--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		} else {
		    side--;
		    if (news & Q(1) << (integral_q_bits - 1)) {
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    } else {
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    }

		    side--;
		    *side = **turn;

		    fast = file + integral_q_bits - 2;

		    side--;
		    *side = *fast;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    fast = file + integral_q_bits - 2;

		    side--;
		    *side = **turn;
		    side--;
		    *side = *fast;
		    side -= 2;
		    fast -= 2;
		    *side = *fast;
		} else {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    *side = **turn;

		    fast = file + integral_q_bits - 2;

		    side -= 2;
		    *side = *fast;
		}
	    }

	    if (half) {
		**turn = away;
	    } else {
		**path = away;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
	    }
	} else {
	    fast += integral_q_bits << 1;

	    side = fast;

	    fast++;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		side--;
		fast -= 2;
		*side = *fast;

		fast = file + (integral_q_bits << 1) - 1;

		side--;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    } else {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;

		fast = file + (integral_q_bits << 1) - 1;

		side--;
		*side = *fast;
		side--;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    fast = tier + integral_q_bits;

	    side = fast;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		fast = file + integral_q_bits - 2;

		side--;
		*side = **turn;
		side--;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    } else {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		*side = **turn;

		fast = file + integral_q_bits - 2;

		side -= 2;
		*side = *fast;
	    }

	    if (half) {
		**turn = away;
	    } else {
		**path = away;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
	    }

	    *side = Lxdddddddd;
	}
    }

    if (1) {
	if (half) {
	    east(node, call, mile);

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		if (fill) {
		    *lift = near;

		    *lock = tier;

		    *path = *turn;

		    if (*KD(near) & Q(2)) {
			*mile = 0;

			*lane = PD(near)[1];

			*turn = KD(near) + 1;
		    } else {
			*mile = 1;

			*lane = PD(near)[*KD(near) & Q(8) ? 2 : 3];

			*turn = KD(near) + 2;
		    }
		} else {
		    call = *mile;

		    if (call & 1) {
			if (*KD(node) & Q(1) << call) {
			    *lead = PD(node)[call - 1];
			    *path = KD(node) + call;
			} else {
			    if (call ^ 1) {
				*lead = PD(node)[call - 2];
				*path = KD(node) + call - 1;
			    } else {
				*path = data;
				if (date) {
				    *lead = PD(date)[integral_q_last];
				} else {
				    *lead = NULL;
				}
			    }
			}
		    } else {
			if (call) {
			    *lead = PD(node)[call - 1];
			    *path = KD(node) + call;
			} else {
			    *path = data;
			    if (date) {
				*lead = PD(date)[integral_q_last];
			    } else {
				*lead = NULL;
			    }
			}
		    }

		    *lock = club;

		    if (call ^ integral_q_last) {
			if (status ^ (LAST_ERROR + call + 2)) {
			    *turn = KD(node) + call + 1;
			} else {
			    if (call ^ (integral_q_bits - 3)) {
				*turn = KD(node) + call + 3;
			    } else {
				*turn = text;
			    }
			}
		    } else {
			*turn = text;
		    }
		}
	    }
	} else {
	    edge(node, call, mile);

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		if (fill) {
		    *lift = date;

		    *lock = club;

		    *turn = *path;

		    *mile = integral_q_last;

		    if (*KD(date) & Q(1) << integral_q_last) {
			*lead = PD(date)[integral_q_bits - 2];

			*path = KD(date) + integral_q_last;
		    } else {
			*lead = PD(date)[integral_q_bits - 3];

			*path = KD(date) + integral_q_bits - 2;
		    }
		} else {
		    call = *mile;

		    if (call & 1) {
			if (*KD(node) & Q(1) << call) {
			    *path = KD(node) + call;
			} else {
			    if (call ^ 1) {
				if (status ^ (LAST_ERROR + call - 2)) {
				    *path = KD(node) + call - 1;
				} else {
				    if (call ^ 3) {
					*path = KD(node) + call - 1;
				    } else {
					*path = data;
				    }
				}
			    } else {
				*path = data;
			    }
			}
		    } else {
			if (call) {
			    *path = KD(node) + call;
			} else {
			    *path = data;
			}
		    }

		    *lock = tier;

		    if (call ^ integral_q_last) {
			*turn = KD(node) + call + 1;
			*lane = PD(node)[call + 1];
		    } else {
			*turn = text;
			if (near) {
			    if (*KD(near) & 2) {
				*lane = PD(near)[0];
			    } else {
				*lane = PD(near)[1];
			    }
			} else {
			    *lane = NULL;
			}
		    }
		}
	    }
	}
    }

    return status;
}
