/*
 * bqpx.p.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bcount.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#define __HALF_TRANSFER__		1

#define __UNROLL_TRANSFER__		0

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_four_bqpset(void *bqfset, integral_q last, integral_q **lead,
		       integral_q pipe, void **lift, unsigned *mile,
		       integral_q **lock, integral_q **spin, integral_q **lane,
		       integral_q next, unsigned *rate)
{
    integral_q *club, *file, *past, *tier;
    unsigned call, copy, deck, ever;
    void *node;

    club = *lead;

    file = *lock;

    tier = *lane;

    node = *lift;

    call = *mile;

    copy = *rate;

    past = *spin;

    if (1) {
	integral_q *fast;

	*KD(file) = Lx55555555;

	fast = file + copy;

	deck = (integral_q_bits - copy - 2) >> 1;

#if __UNROLL_TRANSFER__
# error
#else
	for (; deck; deck--) {
	    *fast = *(fast + 2);
	    fast += 2;
	}
#endif				/* __UNROLL_TRANSFER__ */
	{
	    *fast = *past;
	}

	{
	    *past = *(tier + 2);
	}

	*KD(tier) = Lx55555555 ^ Q(4);
    }

    if (1) {
	club = file;

	file = tier;
    } else {
    }

    if (call) {
	if (pipe & Q(1) << 3) {
	    call = 2;
	    past = KD(node) + 3;
	    tier = PD(node)[3];
	} else {
	    call = 3;
	    past = KD(node) + 4;
	    if (pipe & Q(1) << 5) {
		tier = PD(node)[4];
	    } else {
		tier = PD(node)[5];
	    }
	}
    } else {
	call = 1;
	past = KD(node) + 2;
	if (pipe & Q(1) << 3) {
	    tier = PD(node)[2];
	} else {
	    tier = PD(node)[3];
	}
    }

    next = *tier & ~Lx55555555;
    if (next) {
#if __HALF_TRANSFER__
	if (1) {
	    integral_q *fast, *side, text;

	    fast = file;

	    fast += 2;

	    deck = (integral_q_bits - 2 - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
	    for (; deck; deck--) {
		*fast = *(fast + 2);
		fast += 2;
	    }
# endif				/* __UNROLL_TRANSFER__ */

	    fast = file;

	    l2_q_bitcount(ever, next);

	    if (ever < 4) {
		ever = 1;

		*KD(fast) = Lx55555555;

		fast += integral_q_bits - 2;
	    } else {
		ever &= ~1;

		*KD(fast) = Lx55555555
		    | ~Q(0) << (integral_q_bits - ever + 2);

		if (ever < 8) {
		    ever >>= 1;

		    fast += integral_q_bits - ever;
		} else {
		    fast += integral_q_bits - ever + 3;

		    side = fast + 1;

		    ever >>= 1;

		    deck = ever - 3;
		    for (; deck; deck--) {
			*fast = *side;
			side += 2;
			fast++;
		    }
		}
	    }

	    *fast = *past;

	    fast++;

	    ever--;

	    side = tier;

	    text = *side;

	    while (ever & ~1) {
		if (text & Q(2)) {
		    side++;
		    *fast = *side;
		    fast++;
		    side++;
		    *fast = *side;
		    fast++;

		    ever -= 2;
		} else {
		    ever--;

		    side += 2;
		    *fast = *side;
		    fast++;
		}

		text >>= 2;
	    }
	    if (ever) {
		if (text & Q(2)) {
		    side++;
		    *fast = *side;
		    side++;
		    *past = *side;

		    ever = 0;
		} else {
		    side += 2;
		    *fast = *side;
		}

		text >>= 2;
	    } else {
		ever = 1;
	    }
	    if (ever) {
		if (text & Q(2)) {
		    side++;
		    *past = *side;

		    side++;

		    fast = tier + 2;

		    text >>= 1;
		} else {
		    side += 2;
		    *past = *side;

		    side++;

		    fast = tier + 2;

		    text >>= 2;

		    if (fast < side) {
			text >>= 1;
			if (text & Q(1)) {
			    *fast = *side;
			    fast += 2;
			} else {
			}

			side++;
		    }
		}
	    } else {
		side++;

		fast = tier + 2;

		if (fast < side) {
		    text >>= 1;
		    if (text & Q(1)) {
			*fast = *side;
			fast += 2;
		    } else {
		    }

		    side++;
		}
	    }
	    while (fast < side) {
		if (text & Q(4)) {
		    *fast = *side;
		    fast += 2;
		    side++;
		    *fast = *side;
		    fast += 2;
		    side++;
		} else {
		    *fast = *side;
		    fast += 2;
		    side += 2;
		}

		text >>= 2;
	    }

	    *KD(tier) &= Lx55555555 | ~Q(0) << 2 << (fast - tier - 2);
	}
#else
# error
#endif				/* __HALF_TRANSFER__ */
    } else {
	*rate = 2;

	*mile = call;

	*lane = tier;

	*spin = past;

	*lock = file;

	*lead = club;
    }

    return 0;
}
