/*
 * bqpx.o.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_root_bqpset(void *bqfset, void *node, unsigned rate)
{
    int status;
    integral_q *call, *data, *file, mode, news, pipe, *text;
    unsigned i;

    mode = LD(node)[0];

    call = ND(node)[0];

    file = ND(node)[1];

    text = (integral_q *) node;

    *text++ = integral_q_bits;

    data = call;
    if (*data & ~Lx55555555) {
	pipe = *data & ~Lx55555555;

	news = pipe;

	news >>= 2;

	for (; news; news >>= 2) {
	    data += 2;
	    *text = *data;
	    text++;
	}

	{
	    *text++ = *(data + 1);
	}

	i = ((call + integral_q_bits - data) >> 1) - 1;
	for (; i; i--) {
	    data += 2;
	    *text = *data;
	    text++;
	}

	{
	    *text++ = mode;
	}

	data = file;

	data += 2;

	i = half_integral_q_bits - 1;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	text += integral_q_bits_and_half - integral_q_bits - 1;

	data = call + integral_q_bits + 1;

	news = pipe;

	news >>= 2;

	for (; news; news >>= 2) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	{
	    *text++ = *(data - 1);
	}

	i = ((call + ((integral_q_bits << 1) + 1) - data) >> 1) - 0;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	data = file + integral_q_bits + 1;

	i = half_integral_q_bits;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}
    } else {
	data += 2;

	i = half_integral_q_bits - 1;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	{
	    *text++ = mode;
	}

	data = file;

	pipe = *data & ~Lx55555555;

	news = pipe;

	news >>= 2;

	for (; news; news >>= 2) {
	    data += 2;
	    *text = *data;
	    text++;
	}

	{
	    *text++ = *(data + 1);
	}

	i = ((file + integral_q_bits - data) >> 1) - 1;
	for (; i; i--) {
	    data += 2;
	    *text = *data;
	    text++;
	}

	text += integral_q_bits_and_half - integral_q_bits - 1;

	data = call + integral_q_bits + 1;

	i = half_integral_q_bits;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	data = file + integral_q_bits + 1;

	news = pipe;

	news >>= 2;

	for (; news; news >>= 2) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	{
	    *text++ = *(data - 1);
	}

	i = ((file + ((integral_q_bits << 1) + 1) - data) >> 1) - 0;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}
    }

    if (2) {
	if (1) {
	    int excess;

	    bqfset(bqfset)->link_a.fpnews.link_v.rate = rate;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;
	    }

	    excess = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, call);
	    if (excess) {
		status = FREE_ERROR;
	    }

	    if (status) {
		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		status = LAST_ERROR + 2;
	    }
	}
    }

    return status;
}
