/*
 * bqpx.n.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_lift_bqpset(void *bqfset, void *date, integral_q *data,
		       integral_q **path, integral_q **lead, integral_q pipe,
		       void **lift, unsigned *mile, integral_q **lock,
		       integral_q **lane, integral_q **turn, integral_q *text,
		       void *near, integral_q mode)
{
    int status;
    integral_q *club, *file, *tier;
    unsigned call;
    void *node;

    call = *mile;

    club = *lead;

    file = *lock;

    node = *lift;

    tier = *lane;

    if (0) {
    } else {
	integral_q last, next;
	unsigned deck, ever;
	unsigned hold = 0;

	if (1) {
	    if (club) {
		last = *club & ~Lx55555555;
		if (last) {
		    if (last & (last - 1)) {
			deck = 4;
			ever = 0;
			next = ~Q(0);
		    } else {
			if (tier) {
			    deck = 1;
			    next = *tier & ~Lx55555555;
			    if (next) {
				if (next & (next - 1)) {
				    ever = 4;
				} else {
				    ever = 1;
				}
			    } else {
				ever = 0;
			    }
			} else {
			    deck = 4;
			    ever = 0;
			    next = ~Q(0);
			}
		    }
		} else {
		    deck = 0;
		    if (tier) {
			next = *tier & ~Lx55555555;
			if (next) {
			    if (next & (next - 1)) {
				ever = 4;
			    } else {
				ever = 1;
			    }
			} else {
			    ever = 0;
			}
		    } else {
			ever = 0;
			next = ~Q(0);
			if (pipe & Q(1) << integral_q_last) {
			    hold = integral_q_bits - 3;
			} else {
			    if (pipe & Q(1) << (integral_q_bits - 3)) {
				hold = integral_q_bits - 4;
			    } else {
				hold = integral_q_bits - 5;
			    }
			}

			last = *KD(PD(node)[hold]) & ~Lx55555555;
			if (last & (last - 1)) {
			    deck = 4;
			} else {
			    deck = 1;
			}
		    }
		}
	    } else {
		deck = 0;
		last = ~Q(0);
		next = *tier & ~Lx55555555;
		if (next) {
		    ever = 4;
		} else {
		    ever = 0;
		    if (call) {
			if (pipe & Q(1) << 3) {
			    hold = 3;
			} else {
			    if (pipe & Q(1) << 5) {
				hold = 4;
			    } else {
				hold = 5;
			    }
			}
		    } else {
			if (pipe & Q(1) << 3) {
			    hold = 2;
			} else {
			    hold = 3;
			}
		    }

		    next = *KD(PD(node)[hold]) & ~Lx55555555;
		    if (next & (next - 1)) {
			ever = 4;
		    } else {
			ever = 1;
		    }
		}
	    }
	}

	if (deck | ever) {
	    status = 0;

	    if ((deck | ever) & 4) {
		if (call ^ (integral_q_bits - 1)) {
		    if (pipe & ((Q(1) << call) - 1) << 1) {
		    } else {
			ever += 2;
		    }
		} else {
		    deck += 2;
		}

		if (deck < ever) {
		    integral_q data, *fast, *side, text;

		    if (hold) {
			club = tier;

			tier = PD(node)[hold];
		    }

		    fast = tier;

		    text = next;
		    text &= (text - 1) << 1;

		    *KD(fast) = Lx55555555 | (next & ~text);

		    text >>= 2;
		    if (text) {
			fast += 2;

			side = fast + integral_q_bits - 1;

			last = *fast;

			data = *side;

			text >>= 2;

			for (; text; text >>= 2) {
			    *fast = *(fast + 2);
			    fast += 2;
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *fast = *(fast + 1);
			}
			{
			    *side = *(side + 1);
			}
		    } else {
			last = fast[1];

			data = fast[integral_q_bits];
		    }

		    if (hold) {
			fast = club + 2;

			side = fast + integral_q_bits - 1;

			if (hold & 1) {
			    if (pipe & Q(1) << hold) {
				text = KD(node)[hold];

				KD(node)[hold] = last;
			    } else {
				hold--;

				text = KD(node)[hold];

				KD(node)[hold] = last;

				hold++;
			    }
			} else {
			    text = KD(node)[hold];

			    KD(node)[hold] = last;
			}

			last = *fast;

			next = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *fast = *(fast + 2);
			    fast += 2;
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *fast = text;
			}
			{
			    *side = next;
			}
		    }

		    fast = file;

		    *KD(fast) = Lx55555555 | Q(1) << integral_q_last;

		    if (0) {
		    } else {
			fast += integral_q_last;

			*fast = **turn;

			fast += integral_q_bits;

			{
			    *(fast - 1) = *fast;
			}

			{
			    *fast = data;
			}
		    }

		    **turn = last;
		} else {
		    integral_q data, *fast, *side, text;

		    if (hold) {
			tier = club;

			club = PD(node)[hold];
		    }

		    fast = club;

		    text = last;

		    if (text & Q(1) << integral_q_last) {
			next = fast[integral_q_last];

		        fast += (integral_q_bits << 1) - 1;

			data = *fast;
			*fast = *(fast - 1);

			*KD(club) = Lx55555555
			    | (last ^ Q(1) << integral_q_last);
		    } else {
			fast += integral_q_bits - 2;

			side = fast + integral_q_bits + 1;

			next = *fast;

			data = *side;

			text <<= 2;

			for (; !(text & Q(1) << integral_q_last); text <<= 2) {
			    *fast = *(fast - 2);
			    fast -= 2;
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *fast = *(fast - 1);
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 1);
			}

			*KD(club) = Lx55555555
			    | (last ^ Q(1) << (fast - club - 1));
		    }

		    if (hold) {
			fast = tier + integral_q_bits - 2;

			side = fast + integral_q_bits + 1;

			if (1) {
			    hold++;

			    text = KD(node)[hold];

			    KD(node)[hold] = next;

			    hold--;
			}

			next = *fast;

			last = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *fast = *(fast - 2);
			    fast -= 2;
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *fast = text;
			}
			{
			    *side = last;
			}
		    }

		    fast = file;

		    *KD(fast) = Lx55555555 | 2;

		    if (0) {
		    } else {
			fast += 1;

			side = fast + integral_q_bits - 1;

			{
			    *fast = **path;
			}
			{
			    *side = data;
			}
		    }

		    **path = next;
		}
	    } else {
		if (club) {
		    if (tier) {
		    } else {
			if (pipe & Q(1) << integral_q_last) {
			    call = integral_q_bits - 2;
			} else {
			    call = integral_q_bits - 3;
			}

			*mile = call;

			*lane = file;
			*lock = club;
			*lead = PD(node)[hold];

			*turn = *path;
			if (pipe & Q(1) << integral_q_last) {
			    *path = KD(node) + integral_q_bits - 2;
			} else {
			    if (pipe & Q(1) << (integral_q_bits - 3)) {
				*path = KD(node) + integral_q_bits - 3;
			    } else {
				*path = KD(node) + integral_q_bits - 4;
			    }
			}
		    }
		} else {
		    if (call) {
			if (pipe & Q(1) << 3) {
			    call = 2;
			} else {
			    call = 3;
			}
		    } else {
			call++;
		    }

		    *mile = call;

		    *lead = file;
		    *lock = tier;
		    *lane = PD(node)[hold];

		    *path = *turn;
		    *turn = KD(node) + call + 1;
		}

		status = _libx1f4l2_pack_bqpset
		    (bqfset, date, data, path, lead, pipe, lift, mile, lock,
		     lane, turn, text, near, mode);
	    }
	} else {
	    status = _libx1f4l2_pack_bqpset
		(bqfset, date, data, path, lead, pipe, lift, mile, lock, lane,
		 turn, text, near, mode);
	}
    }

    return status;
}
