/*
 * bqpx.l.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#define Q_21_				Q(21)

#define Q_42_				Q(42)

#define Q_63_				Q(63)

#undef Q
#define Q(e)				((integral_q) (e))

#define q_21_				(Q_21_ << (integral_q_bits - 6))

#define q_42_				(Q_42_ << (integral_q_bits - 6))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_lane_bqpset(void *bqfset, unsigned mind, void *node,
		       integral_q **lead, integral_q **path, unsigned *pace,
		       integral_q *file, integral_q **turn, integral_q **lane,
		       unsigned rate, integral_q mode)
{
    int status;
    integral_q *club, *tier;
    unsigned pick;

    pick = *pace;

    club = *lead;

    if (1) {
	integral_q *fast, pipe, *side;
	unsigned deck;

	fast = club;

	pipe = *fast & ~Lx55555555;

	if (pipe) {
	    integral_q news;

	    news = pipe;

	    if (news & Q_42_) {
		*fast = Lxdddddddd | Q(2);

		if (news & 2) {
		    fast += 4;

		    side = fast - 1;

		    *side = *fast;
		    fast += 2;
		    side++;
		} else {
		    if (news & 8) {
			fast += 2;

			side = fast - 1;

			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast += 2;
			side++;
		    } else {
			fast += 2;

			side = fast - 1;

			*side = *fast;
			fast += 2;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
		    }
		}
	    } else {
		fast += 4;

		side = fast - 1;

		*side = *fast;
		fast += 2;
		side++;
	    }

	    news |= Q(1) << (integral_q_bits - 2);
	    news >>= 6;

	    for (; !(news & Q_63_); news >>= 6) {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		fast += 2;
		side++;
		*side = *fast;
		fast += 2;
		side++;
	    }

	    if (news & ~((Q(1) << 6) - 1)) {
		*club = Lxdddddddd | Q(2) << (side - club);

		if (news & 2) {
		    *side = *fast;
		    fast++;
		    side++;
		    *side = *fast;
		    fast++;
		    side++;
		    *side = *fast;
		    fast += 2;
		    side++;
		    *side = *fast;
		    fast += 2;
		    side++;
		} else {
		    if (news & 8) {
			*side = *fast;
			fast += 2;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast += 2;
			side++;
		    } else {
			*side = *fast;
			fast += 2;
			side++;
			*side = *fast;
			fast += 2;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
		    }
		}

		news >>= 6;
	    }

	    for (; !(news & Q_21_); news >>= 6) {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		fast += 2;
		side++;
		*side = *fast;
		fast += 2;
		side++;
	    }

	    if (news & Q_42_) {
		*club = Lxdddddddd | Q(2) << (side - club);

		if (half_integral_q_bits % 3 ^ 2) {
		    *side = *fast;
		    fast++;
		    side++;
		    *side = *fast;
		    side++;
		    *side = KD(node)[pick];

		    fast = file;

		    fast += 2;
		    side++;
		    *side = *fast;
		    side++;
		} else {
		    *side = *fast;
		    if (news & 2) {
			fast++;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
		    } else {
			fast += 2;
			side++;
			*side = *fast;
			fast++;
			side++;
			*side = *fast;
		    }

		    side++;

		    *side = KD(node)[pick];

		    fast = file;

		    side++;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    *side = *fast;
		    side += 2;
		    *side = KD(node)[pick];

		    fast = file;

		    fast += 2;
		    side++;
		    *side = *fast;
		    side++;
		} else {
		    *side = *fast;
		    fast += 2;
		    side += 2;
		    *side = *fast;
		    side++;
		    *side = KD(node)[pick];

		    fast = file;

		    side++;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		fast += 2;
		*side = *fast;
		side += 2;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    fast += 2;

	    KD(node)[pick] = *fast;

	    news = pipe;

	    fast = club + integral_q_bits;

	    side = fast;

	    fast--;

	    news |= Q(1) << (integral_q_bits - 2);

	    for (; !(news & Q_42_); news >>= 6) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    if (news & ~((Q(1) << 6) - 1)) {
		if (news & 2) {
		    fast++;
		    *side = *fast;
		    side++;
		    fast++;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		} else {
		    if (news & 8) {
			fast += 2;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast += 2;
			*side = *fast;
			side++;
		    } else {
			fast += 2;
			*side = *fast;
			side++;
			fast += 2;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
		    }
		}

		news >>= 6;
	    }

	    for (; !(news & Q_21_); news >>= 6) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    if (news & Q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    fast++;
		    *side = *fast;
		    side++;
		    fast++;
		    *side = *fast;

		    fast = file + integral_q_bits + 1;

		    side++;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		} else {
		    if (news & 2) {
			fast++;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast += 2;
			*side = *fast;
		    } else {
			fast += 2;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
			side++;
			fast++;
			*side = *fast;
		    }

		    fast = file + integral_q_bits + 1;

		    side++;
		    *side = *fast;
		    side++;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    side++;
		    fast += 2;
		    *side = *fast;

		    fast = file + integral_q_bits + 1;

		    side++;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		} else {
		    side++;
		    fast += 2;
		    *side = *fast;
		    side++;
		    fast += 2;
		    *side = *fast;

		    fast = file + integral_q_bits + 1;

		    side++;
		    *side = *fast;
		    side++;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }
	} else {
	    *fast = Lxdddddddd;

	    fast += 4;

	    side = fast - 1;

	    {
		*side = *fast;
		fast += 2;
		side++;
	    }

	    deck = integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		fast += 2;
		side++;
		*side = *fast;
		fast += 2;
		side++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		*side = *fast;
		side += 2;
		*side = KD(node)[pick];

		fast = file;

		fast += 2;
		side++;
		*side = *fast;
		side++;
	    } else {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		side++;
		*side = KD(node)[pick];

		fast = file;

		side++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		fast += 2;
		*side = *fast;
		side += 2;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    fast += 2;

	    KD(node)[pick] = *fast;

	    fast = club + integral_q_bits;

	    side = fast;

	    fast--;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		side++;
		fast += 2;
		*side = *fast;

		fast = file + integral_q_bits + 1;

		side++;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    } else {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;

		fast = file + integral_q_bits + 1;

		side++;
		*side = *fast;
		side++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }
	}
    }

    tier = *lane;

    if (1) {
	integral_q *fast, pipe, *side;
	unsigned deck;

	fast = tier;

	pipe = *tier & ~Lx55555555;

	if (pipe) {
	    integral_q news;

	    news = pipe;

	    fast += integral_q_bits << 1;

	    side = fast;

	    fast++;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    if (news & q_21_) {
	    } else {
		if (news & Q(1) << (integral_q_bits - 1)) {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    fast--;
		    *side = *fast;
		    side--;
		    fast--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    } else {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			fast++;
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    if (news & q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    fast--;
		    *side = *fast;

		    fast = file + (integral_q_bits << 1) - 1;

		    side--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		} else {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    if (news & Q(1) << (integral_q_bits - 1)) {
			side--;
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    } else {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    }

		    fast = file + (integral_q_bits << 1) - 1;

		    side--;
		    *side = *fast;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    side--;
		    fast -= 2;
		    *side = *fast;

		    fast = file + (integral_q_bits << 1) - 1;

		    side--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		} else {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;

		    fast = file + (integral_q_bits << 1) - 1;

		    side--;
		    *side = *fast;
		    side--;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    news = pipe;

	    fast = tier + integral_q_bits;

	    side = fast;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    if (news & q_21_) {
	    } else {
		*tier = Lxdddddddd | Q(2) << (side - tier - 4);

		if (news & Q(1) << (integral_q_bits - 1)) {
		    side--;
		    fast--;
		    *side = *fast;
		    side--;
		    fast--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
		    } else {
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    if (news & q_42_) {
		*tier = Lxdddddddd | Q(2) << (side - tier - 4);

		if (half_integral_q_bits % 3 ^ 2) {
		    side--;
		    fast--;
		    *side = *fast;

		    fast = file + integral_q_bits - 2;

		    side--;
		    *side = KD(node)[pick + 1];
		    side--;
		    *side = *fast;
		    side--;
		    fast -= 2;
		    *side = *fast;
		} else {
		    side--;
		    if (news & Q(1) << (integral_q_bits - 1)) {
			fast--;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    } else {
			fast -= 2;
			*side = *fast;
			side--;
			fast--;
			*side = *fast;
		    }

		    side--;
		    *side = KD(node)[pick + 1];

		    fast = file + integral_q_bits - 2;

		    side--;
		    *side = *fast;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    fast = file + integral_q_bits - 2;

		    side--;
		    *side = KD(node)[pick + 1];
		    side--;
		    *side = *fast;
		    side -= 2;
		    fast -= 2;
		    *side = *fast;
		} else {
		    side--;
		    fast -= 2;
		    *side = *fast;
		    side--;
		    *side = KD(node)[pick + 1];

		    fast = file + integral_q_bits - 2;

		    side -= 2;
		    *side = *fast;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
	    }
	} else {
	    fast += integral_q_bits << 1;

	    side = fast;

	    fast++;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		side--;
		fast -= 2;
		*side = *fast;

		fast = file + (integral_q_bits << 1) - 1;

		side--;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    } else {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;

		fast = file + (integral_q_bits << 1) - 1;

		side--;
		*side = *fast;
		side--;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    fast = tier + integral_q_bits;

	    side = fast;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		fast = file + integral_q_bits - 2;

		side--;
		*side = KD(node)[pick + 1];
		side--;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    } else {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		*side = KD(node)[pick + 1];

		fast = file + integral_q_bits - 2;

		side -= 2;
		*side = *fast;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
	    }

	    *side = Lxdddddddd;
	}
    }

    if (2) {
	if (1) {
	    integral_q *side;
	    void **trap;

	    trap = ND(node) + pick;

	    memmove(trap, trap + 1, (mind - pick) * sizeof(void *));

	    side = KD(node) + pick + 1;

	    memmove(side, side + 1, (mind - pick) * sizeof(integral_q));

	    mind--;

	    *KD(node) = mind;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		if (1) {
		    if (mode < KD(node)[pick]) {
			pick--;
		    }
		}

		*pace = pick;

		if (pick) {
		    *path = KD(node) + pick;
		    *lead = ND(node)[pick - 1];
		} else {
		    *path = NULL;
		    *lead = NULL;
		}
		if (pick ^ mind) {
		    *lane = ND(node)[pick + 1];
		    *turn = KD(node) + pick + 1;
		} else {
		    *lane = NULL;
		    *turn = NULL;
		}
	    }
	}
    }

    return status;
}
