/*
 * bqpx.k.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#define __SIDE_FILL__			1

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_join_bqpset(void *bqfset, unsigned mind, void *node,
		       integral_q **lead, integral_q **path, unsigned *pace,
		       integral_q *file, integral_q **turn, integral_q **lane,
		       unsigned rate, integral_q mode)
{
    int status;

    if (mind ^ 1) {
#if __SIDE_FILL__
	int half;
#endif				/* __SIDE_FILL__ */
	integral_q *club, *fast, *side, *tier;
	unsigned deck, pick;

	pick = *pace;

	club = *lead;

	if (mind ^ pick) {
	    tier = *lane;

#if __SIDE_FILL__
	    if (pick) {
	    } else {
		fast = ND(node)[pick + 2];

		if (*fast ^ Lx55555555) {
		} else {
		    club = file;
		    file = tier;

		    pick++;

		    tier = fast;
		}
	    }
#endif				/* __SIDE_FILL__ */
	} else {
	    tier = file;
	    file = club;

	    pick--;

#if __SIDE_FILL__
	    club = ND(node)[pick - 1];
	    if (*club ^ Lx55555555) {
		club = NULL;
	    }
#endif				/* __SIDE_FILL__ */
	}

#if __SIDE_FILL__
	if (!club) {
#elif 0
	}
#else
	{
#endif				/* __SIDE_FILL__ */
	    fast = tier;

	    side = fast;

	    *side = ~Q(0);

	    fast += integral_q_bits - 2;

	    side = fast + 1;

	    deck = half_integral_q_bits - 1;
	    for (; deck; deck--) {
		*side = *fast;
		fast -= 2;
		side--;
	    }

	    if (0) {
	    } else{
		*side = KD(node)[pick + 1];
	    }

	    side--;

	    fast = file;

	    fast += integral_q_bits - 2;

	    deck = half_integral_q_bits - 1;
	    for (; deck; deck--) {
		*side = *fast;
		fast -= 2;
		side--;
	    }

	    side += (integral_q_bits << 1) - 2;

	    fast = side - 1;

	    deck = half_integral_q_bits - 1;
	    for (; deck; deck--) {
		*side = *fast;
		fast -= 2;
		side--;
	    }

	    fast = file + (integral_q_bits << 1) - 1;

	    deck = half_integral_q_bits;
	    for (; deck; deck--) {
		*side = *fast;
		fast -= 2;
		side--;
	    }

#if __SIDE_FILL__
	    half = 0;
	} else {
	    fast = club;

	    *fast = Lxdddddddd;

	    fast += 4;

	    side = fast - 1;

	    {
		*side = *fast;
		fast += 2;
		side++;
	    }

	    deck = integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		fast += 2;
		side++;
		*side = *fast;
		fast += 2;
		side++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		*side = *fast;
		side += 2;
		*side = KD(node)[pick];

		fast = file;

		fast += 2;
		side++;
		*side = *fast;
		side++;
	    } else {
		*side = *fast;
		fast += 2;
		side += 2;
		*side = *fast;
		side++;
		*side = KD(node)[pick];

		fast = file;

		side++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		fast += 2;
		*side = *fast;
		side += 2;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    fast += 2;

	    KD(node)[pick] = *fast;

	    half = 1;

	    fast = club + integral_q_bits;

	    side = fast;

	    fast--;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		side++;
		fast += 2;
		*side = *fast;

		fast = file + integral_q_bits + 1;

		side++;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    } else {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;

		fast = file + integral_q_bits + 1;

		side++;
		*side = *fast;
		side++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
		fast += 2;
		*side = *fast;
		side++;
	    }

	    fast = tier + (integral_q_bits << 1);

	    side = fast;

	    fast++;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		side--;
		fast -= 2;
		*side = *fast;

		fast = file + (integral_q_bits << 1) - 1;

		side--;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    } else {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;

		fast = file + (integral_q_bits << 1) - 1;

		side--;
		*side = *fast;
		side--;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side--;
	    }

	    fast = tier + integral_q_bits;

	    side = fast;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		fast = file + integral_q_bits - 2;

		side--;
		*side = KD(node)[pick + 1];
		side--;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    } else {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		*side = KD(node)[pick + 1];

		fast = file + integral_q_bits - 2;

		side -= 2;
		*side = *fast;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
		fast -= 2;
		*side = *fast;
	    }

	    {
		side--;
		fast -= 2;
		*side = *fast;
		side--;
		fast -= 2;
		*side = *fast;
		side -= 2;
	    }

	    *side = Lxdddddddd;
#endif				/* __SIDE_FILL__ */
	}

	if (1) {
	    void **trap;

	    trap = ND(node) + pick;

	    memmove(trap, trap + 1, (mind - pick) * sizeof(void *));

	    side = KD(node) + pick + 1;

	    memmove(side, side + 1, (mind - pick) * sizeof(integral_q));

	    mind--;

	    *KD(node) = mind;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
#if __SIDE_FILL__
		if (half) {
		    if (mode < KD(node)[pick]) {
			pick--;
		    }
		}
#endif				/* __SIDE_FILL__ */

		*pace = pick;

		if (pick) {
		    *path = KD(node) + pick;
		    *lead = ND(node)[pick - 1];
		} else {
		    *path = NULL;
		    *lead = NULL;
		}
		if (pick ^ mind) {
		    *lane = ND(node)[pick + 1];
		    *turn = KD(node) + pick + 1;
		} else {
		    *lane = NULL;
		    *turn = NULL;
		}
	    }
	}
    } else {
	integral_q *call, *data, *text;
	unsigned i;

	mode = LD(node)[0];

	call = ND(node)[0];

	file = ND(node)[1];

	text = (integral_q *) node + 0;

	*text++ = integral_q_bits - 1;

	data = call + 2;

	i = half_integral_q_bits - 1;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	{
	    *text++ = mode;
	}

	data = file + 2;

	i = half_integral_q_bits - 1;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	text = (integral_q *) node + integral_q_bits_and_half;

	data = call + integral_q_bits + 1;

	i = half_integral_q_bits;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	data = file + integral_q_bits + 1;

	i = half_integral_q_bits;
	for (; i; i--) {
	    *text = *data;
	    text++;
	    data += 2;
	}

	if (1) {
	    int excess;

	    bqfset(bqfset)->link_a.fpnews.link_v.rate = rate;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;
	    }

	    excess = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, call);
	    if (excess) {
		status = FREE_ERROR;
	    }

	    if (status) {
		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		status = LAST_ERROR + 2;
	    }
	}
    }

    return status;
}
