/*
 * bqpx.i.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-index.h>
#include <bqpx-types.h>
#include <xfs.h>
#include <xls.h>

#define here_slip(text) \
    side = (text)

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_hale_bqpset(void *bqfset, void *node, void *mode, unsigned copy,
		       void **fare, unsigned rate)
{
    int status;

    do {
	integral_q slip;
	unsigned i, side;
	void *down, *sect;

	down = *fare;

	if (rate ^ 1) {
	    side = 1013;
	    slip = LD(down)[half_integral_q_bits - 1];
	} else {
	    side_line(down, (integral_q) mode, here_slip);
	    if ((integral_q) mode ^ KD(down)[side]) {
		if ((integral_q) mode < KD(down)[side]) {
		    side--;
		} else {
		}
		if (side ^ (half_integral_q_bits - 1)) {
		    if (side < half_integral_q_bits - 1) {
			slip = LD(down)[half_integral_q_bits - 2];
		    } else {
			slip = LD(down)[half_integral_q_bits - 1];
		    }
		} else {
		    slip = (integral_q) mode;
		}
	    } else {
		status = EVER_MATCH;
		if (1) {
		    break;
		}
	    }
	}

	status = bqfset(bqfset)->link_m.link
	    (bqfset(bqfset)->link_m.data, &sect,
	     (integral_q_bits << (rate ^ 1 ? 1 : 0)) * SIZEOF_integral_q);
	if (status) {
	    status = LINK_ERROR;
	    if (1) {
		break;
	    }
	} else {
	    if (1) {
		unsigned flow, size;

		size = *KD(node);

		size++;

		KD(node)[0] = size;

		flow = size - copy - 1;
		for (; flow; flow--) {
		    KD(node)[size] = KD(node)[size - 1];
		    ND(node)[size] = ND(node)[size - 1];
		    size--;
		}

		ND(node)[size] = sect;

		KD(node)[size] = slip;
	    }

	    if (rate ^ 1) {
		KD(sect)[0] = Lx55555555;

		KD(down)[0] = Lx55555555;

		for (i = 0; i < half_integral_q_bits - 1; i++) {
		    LD(sect)[1 + (i << 1)] =
			LD(down)[half_integral_q_bits - 1 + 1 + i];
		    PD(sect)[1 + (i << 1)] =
			PD(down)[half_integral_q_bits - 1 + 1 + i];
		}

		PD(sect)[integral_q_last] = PD(down)[integral_q_last];

		PD(down)[integral_q_last] = PD(down)[half_integral_q_bits - 1];

		for (i = half_integral_q_bits - 2; ~i; i--) {
		    LD(down)[1 + (i << 1)] = LD(down)[i];
		    PD(down)[1 + (i << 1)] = PD(down)[i];
		}

		if ((integral_q) mode < slip) {
		} else {
		    if ((integral_q) mode ^ slip) {
			*fare = sect;
		    } else {
			status = EVER_MATCH;
		    }
		}
	    } else {
		integral_q *data, *text;

		KD(sect)[0] = Lx55555555 | 2;

		KD(down)[0] = Lx55555555;

		data = KD(down) + integral_q_last;

		text = KD(sect) + integral_q_bits - 2;

		if (side < half_integral_q_bits - 1) {
		    i = half_integral_q_bits - 1;
		    for (; i; i--) {
			*text = *data;
			data--;
			text -= 2;
		    }

		    text[1] = *data;

		    data -= 2;

		    text = KD(down) + integral_q_bits - 2;

		    i = half_integral_q_bits - 2 - side;
		    for (; i; i--) {
			*text = *data;
			data--;
			text -= 2;
		    }

		    *text = (integral_q) mode;

		    text -= 2;

		    i = side;
		    for (; i; i--) {
			*text = *data;
			data--;
			text -= 2;
		    }
		} else {
		    if (side ^ (half_integral_q_bits - 1)) {
			i = integral_q_last - side;
			for (; i; i--) {
			    *text = *data;
			    data--;
			    text -= 2;
			}

			if (side ^ half_integral_q_bits) {
			    *text = (integral_q) mode;

			    text -= 2;

			    i = side - half_integral_q_bits - 1;
			    for (; i; i--) {
				*text = *data;
				data--;
				text -= 2;
			    }

			    text[1] = *data;

			    data--;
			} else {
			    text[1] = (integral_q) mode;
			}
		    } else {
			i = half_integral_q_bits - 1;
			for (; i; i--) {
			    *text = *data;
			    data--;
			    text -= 2;
			}

			text[1] = *data;
		    }

		    data--;

		    text = KD(down) + integral_q_bits - 2;

		    i = half_integral_q_bits - 1;
		    for (; i; i--) {
			*text = *data;
			data--;
			text -= 2;
		    }
		}
	    }
	}
    } while (0);

    return status;
}
