/*
 * bqpx.g.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#define here_slip(text) \
    side = (text)

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_long_bqpset(void *bqfset, void *mode, unsigned rate)
{
    int status;

    do {
	integral_q slip;
	unsigned i, side;
	void *node, *root, *sect;

	root = bqfset(bqfset)->link_a.fpnews.node;

	if (rate) {
	    side = 1013;
	    slip = KD(root)[integral_q_bits_and_half >> 1];
	} else {
	    integral_q *call;
	    unsigned mind;

	    call = root;

	    mind = *call;

	    call++;

	    mind--;
	    while (mind) {
		unsigned half;

		half = (mind + 1) >> 1;
		if ((integral_q) mode < call[half]) {
		    mind = half - 1;
		} else {
		    call += half;
		    mind -= half;
		}
	    }

	    if (*call == (integral_q) mode) {
		status = EVER_MATCH;
		if (1) {
		    break;
		}
	    } else {
		if (*call < (integral_q) mode) {
		} else {
		    call--;
		}

		side = call - (integral_q *) root;

		if (side ^ ((integral_q_bits_and_half >> 1) - 1)) {
		    if (side < (integral_q_bits_and_half >> 1) - 1) {
			slip = LD(root)[(integral_q_bits_and_half >> 1) - 2];
		    } else {
			slip = LD(root)[(integral_q_bits_and_half >> 1) - 1];
		    }
		} else {
		    slip = (integral_q) mode;
		}
	    }
	}

	if (rate) {
	    status = bqfset(bqfset)->link_m.link
		(bqfset(bqfset)->link_m.data, &node,
		 (integral_q_bits << 1) * SIZEOF_integral_q);
	    if (status) {
		status = LINK_ERROR;
	    } else {
		status = bqfset(bqfset)->link_m.link
		    (bqfset(bqfset)->link_m.data, &sect,
		     (integral_q_bits << 1) * SIZEOF_integral_q);
		if (status) {
		    status = LINK_ERROR;

		    bqfset(bqfset)->link_m.free
			(bqfset(bqfset)->link_m.data, node);
		} else {
		    integral_q *data, *text;
		    void **dash, **near;

		    KD(sect)[0] = Lxdddddddd;

		    KD(node)[0] = Lxdddddddd;

		    dash = ND(root) + 0;

		    data = KD(root) + 1;

		    near = PD(node) + 1;

		    text = KD(node) + 2;

		    {
			*text = *data;
			data++;
			text++;
			*text = *data;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
		    }
		    i = (integral_q_bits >> 2) - 1;
		    for (; i; i--) {
			data++;
			text++;
			*text = *data;
			data++;
			text += 2;
			*text = *data;
			data++;
			text++;
			*text = *data;
			dash++;
			near += 2;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
		    }

		    dash++;

		    data += 2;

		    near = PD(sect) + 1;

		    text = KD(sect) + 2;

		    {
			*text = *data;
			data++;
			text++;
			*text = *data;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
		    }
		    i = (integral_q_bits >> 2) - 1;
		    for (; i; i--) {
			data++;
			text++;
			*text = *data;
			data++;
			text += 2;
			*text = *data;
			data++;
			text++;
			*text = *data;
			dash++;
			near += 2;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
		    }

		    KD(root)[0] = 1;

		    LD(root)[0] = slip;

		    ND(root)[0] = node;
		    ND(root)[1] = sect;

		    bqfset(bqfset)->link_a.fpnews.link_v.rate++;
		}
	    }
	} else {
	    status = bqfset(bqfset)->link_m.link
		(bqfset(bqfset)->link_m.data, &node,
		 (integral_q_bits << 0) * SIZEOF_integral_q);
	    if (status) {
		status = LINK_ERROR;
	    } else {
		status = bqfset(bqfset)->link_m.link
		    (bqfset(bqfset)->link_m.data, &sect,
		     (integral_q_bits << 0) * SIZEOF_integral_q);
		if (status) {
		    status = LINK_ERROR;

		    bqfset(bqfset)->link_m.free
			(bqfset(bqfset)->link_m.data, node);
		} else {
		    integral_q *data, *text;

		    KD(sect)[0] = Lxdddddddd | 2;

		    KD(node)[0] = Lxdddddddd;

		    if (side < (integral_q_bits_and_half >> 1)) {
			data = KD(root) + integral_q_bits_and_half - 1;

			text = KD(sect) + integral_q_bits - 1;

			i = (integral_q_bits >> 2) - 1;
			for (; i; i--) {
			    *text = *data;
			    text--;
			    data--;
			    *text = *data;
			    text -= 2;
			    data--;
			    *text = *data;
			    text--;
			    data--;
			}
			{
			    *text = *data;
			    text--;
			    data--;
			    *text = *data;
			    text--;
			    data--;
			    *text = *data;
			    data--;
			}

			if (side ^ ((integral_q_bits_and_half >> 1) - 1)) {
			    data--;

			    text = KD(node) + integral_q_bits - 1;

			    i = ((integral_q_bits_and_half >> 1) - 2 - side)
				/ 3;
			    for (; i; i--) {
				*text = *data;
				text--;
				data--;
				*text = *data;
				text -= 2;
				data--;
				*text = *data;
				text--;
				data--;
			    }
			    if (1 < side) {
				i = side % 3;
				if (i) {
				    if (i ^ 1) {
					*text = *data;
					text--;
					data--;
					*text = *data;
					text -= 2;
					*text = (integral_q) mode;
					text--;
					data--;
				    } else {
					*text = (integral_q) mode;
					text--;
					*text = *data;
					text -= 2;
					data--;
					*text = *data;
					text--;
					data--;
				    }
				} else {
				    *text = *data;
				    text--;
				    *text = (integral_q) mode;
				    text -= 2;
				    data--;
				    *text = *data;
				    text--;
				    data--;
				}
				i = (side - 2) / 3;
				for (; i; i--) {
				    *text = *data;
				    text--;
				    data--;
				    *text = *data;
				    text -= 2;
				    data--;
				    *text = *data;
				    text--;
				    data--;
				}
				{
				    *text = *data;
				    text--;
				    data--;
				    *text = *data;
				}
			    } else {
				if (side) {
				    *text = (integral_q) mode;
				    text--;
				    *text = *data;
				} else {
				    *text = *data;
				    text--;
				    *text = (integral_q) mode;
				}
			    }
			} else {
			    text = KD(node) + integral_q_bits - 1;

			    i = (integral_q_bits >> 2) - 1;
			    for (; i; i--) {
				*text = *data;
				text--;
				data--;
				*text = *data;
				text -= 2;
				data--;
				*text = *data;
				text--;
				data--;
			    }
			    {
				*text = *data;
				text--;
				data--;
				*text = *data;
			    }
			}
		    } else {
			side -= (integral_q_bits_and_half >> 1);

			data = KD(root) + 1;

			text = KD(node) + 2;

			{
			    *text = *data;
			    data++;
			    text++;
			    *text = *data;
			}
			i = (integral_q_bits >> 2) - 1;
			for (; i; i--) {
			    data++;
			    text++;
			    *text = *data;
			    data++;
			    text += 2;
			    *text = *data;
			    data++;
			    text++;
			    *text = *data;
			}

			text = KD(sect) + 1;

			data += 2;

			if (side < 3) {
			    if (side) {
				if (side ^ 1) {
				    *text = *data;
				    data++;
				    text++;
				    *text = *data;
				    text++;
				    *text = (integral_q) mode;
				} else {
				    *text = *data;
				    text++;
				    *text = (integral_q) mode;
				    data++;
				    text++;
				    *text = *data;
				}
			    } else {
				*text = (integral_q) mode;
				text++;
				*text = *data;
				data++;
				text++;
				*text = *data;
			    }
			} else {
			    {
				*text = *data;
				data++;
				text++;
				*text = *data;
				data++;
				text++;
				*text = *data;
			    }
			    i = side / 3 - 1;
			    for (; i; i--) {
				data++;
				text++;
				*text = *data;
				data++;
				text += 2;
				*text = *data;
				data++;
				text++;
				*text = *data;
			    }
			    i = side % 3;
			    if (i) {
				if (i ^ 1) {
				    data++;
				    text++;
				    *text = *data;
				    data++;
				    text += 2;
				    *text = *data;
				    text++;
				    *text = (integral_q) mode;
				} else {
				    data++;
				    text++;
				    *text = *data;
				    text += 2;
				    *text = (integral_q) mode;
				    data++;
				    text++;
				    *text = *data;
				}
			    } else {
				text++;
				*text = (integral_q) mode;
				data++;
				text += 2;
				*text = *data;
				data++;
				text++;
				*text = *data;
			    }
			}
			i = ((integral_q_bits_and_half >> 1) - 1 - side) / 3;
			for (; i; i--) {
			    data++;
			    text++;
			    *text = *data;
			    data++;
			    text += 2;
			    *text = *data;
			    data++;
			    text++;
			    *text = *data;
			}
		    }

		    ND(root)[0] = node;
		    ND(root)[1] = sect;

		    LD(root)[0] = slip;

		    KD(root)[0] = 1;

		    bqfset(bqfset)->link_a.fpnews.link_v.rate++;
		}
	    }
	}
    } while (0);

    return status;
}
