/*
 * bqpx.7.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-break.h>
#include <bqpx-seven.h>
#include <bqpx-types.h>

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

#define case_link(copy) \
    node = PD(node)[(copy)]

#define case_miss() \
    status = 1;								      \
    if (1) {								      \
	break;								      \
    }

static int clip(void *, integral_q);
static int pick(void *, integral_q, unsigned *);

static int
clip(void *node, integral_q mode)
{
    int status;
    integral_q *call;
    unsigned size;

    call = node;

    size = *call;
    if (size) {
	call++;

	size--;
	while (size) {
	    unsigned half;

	    half = (size + 1) >> 1;
	    if (mode < call[half]) {
		size = half - 1;
	    } else {
		call += half;
		size -= half;
	    }
	}

	if (*call == mode) {
	    status = 1;
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


static int
pick(void *node, integral_q mode, unsigned *pick)
{
    int status;
    integral_q *call;
    unsigned size;

    call = node;

    size = *call;

    call++;

    size--;
    while (size) {
	unsigned half;

	half = (size + 1) >> 1;
	if (mode < call[half]) {
	    size = half - 1;
	} else {
	    call += half;
	    size -= half;
	}
    }

    if (*call == mode) {
	status = 1;
    } else {
	status = 0;

	if (mode < *call) {
	} else {
	    call++;
	}

	*pick = call - 1 - (integral_q *) node;
    }

    return status;
}


int
x1f4_find_bqpset(void *bqfset, integral_q mode)
{
    int status;
    unsigned rate;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
    if (rate) {
	unsigned copy;
	void *node;

	node = bqfset(bqfset)->link_a.fpnews.node;

	status = pick(node, mode, &copy);
	if (status) {
	} else {
	    node = ND(node)[copy];

	    rate--;

	    while (1) {
		if (rate) {
		    pipe_text(node, mode, case_miss, case_link);

		    rate--;
		} else {
		    high_find(node, mode, status);

		    break;
		}
	    }
	}
    } else {
	status = clip(bqfset(bqfset)->link_a.fpnews.node, mode);
    }

    return status;
}
