/*
 * bqpx.4.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bcount.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#define __COMMENT_FLOW__		1

#if __COMMENT_FLOW__
# include <stdio.h>
#endif				/* __COMMENT_FLOW__ */

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int deck(void *, integral_q *);
static int east(void *, unsigned, unsigned, integral_q *);
static int even(void *, unsigned, integral_q *);
static int ever(void *, unsigned, integral_q *);
static int fine(void *, unsigned, integral_q *);
static int lock(void *, unsigned);
static int mind(void *);

static int
deck(void *node, integral_q *line)
{
    int status;
    integral_q *call, news;

    call = node;

    news = *call;

    if (1) {
	integral_q pick = 1, slip;
	unsigned i = integral_q_last;

	slip = *line;

	status = 0;

	call++;

	for (; i; i--) {
	    pick <<= 1;

	    if (news & pick) {
		if (*call < slip) {
#if __COMMENT_FLOW__
		    fprintf(stderr, "unordered leaf\n");
		    fprintf(stderr, "position %2u, map %08x\n",
			    integral_q_bits - i,
			    (unsigned) *(call + i - integral_q_bits));
		    fprintf(stderr, "expected %u+, got %u\n",
			    (unsigned) slip, (unsigned) *(call - 0));
#endif				/* __COMMENT_FLOW__ */

		    status = 138;

		    break;
		} else {
		    slip = *call;
		}
	    }

	    call++;
	}

	if (status) {
	} else {
	    *line = slip;
	}
    }

    return status;
}


static int
east(void *node, unsigned bits, unsigned rate, integral_q *line)
{
    int status;
    integral_q *call;

    call = node;

    if (bits ^ 3) {
	call++;

	status = fine((void *) *(call + integral_q_bits), rate, line);
    } else {
	status = fine((void *) *(call + integral_q_bits), rate, line);
	if (status) {
	} else {
	    call++;

	    if (*call < *line) {
#if __COMMENT_FLOW__
		fprintf(stderr, "unordered node (1)\n");
		fprintf(stderr, "expected %u+, got %u\n", (unsigned) *line,
			(unsigned) *call);
#endif				/* __COMMENT_FLOW__ */

		status = 139;
	    } else {
		*line = *call;

		status = fine((void *) *(call + integral_q_bits), rate, line);
	    }
	}
    }

    return status;
}


static int
even(void *node, unsigned rate, integral_q *line)
{
    int status;
    integral_q *call, news;
    unsigned four = (integral_q_bits - 2) >> 1;

    call = node;

    news = *call;

    for (; four; four--) {
	call += 2;

	if (*call < *line) {
#if __COMMENT_FLOW__
	    fprintf(stderr, "unordered node (2)\n");
	    fprintf(stderr, "expected %u+, got %u\n", (unsigned) *line,
		    (unsigned) *call);
#endif				/* __COMMENT_FLOW__ */

	    status = 139;

	    break;
	} else {
	    *line = *call;

	    news >>= 2;

	    status = east(call, news & 3, rate, line);
	    if (status) {
		break;
	    }
	}
    }

    return status;
}


static int
ever(void *node, unsigned rate, integral_q *line)
{
    int status;
    integral_q *call, news;

    call = node;

    news = *call;

    if (news & 2) {
	call++;

	status = fine((void *) *(call + integral_q_last), rate, line);
	if (status) {
	} else {
	    if (*call < *line) {
#if __COMMENT_FLOW__
		fprintf(stderr, "unordered node (3)\n");
		fprintf(stderr, "expected %u+, got %u\n", (unsigned) *line,
			(unsigned) *call);
#endif				/* __COMMENT_FLOW__ */

		status = 139;
	    } else {
		*line = *call;

		status = fine((void *) *(call + integral_q_bits), rate, line);
		if (status) {
		} else {
		    call++;

		    if (*call < *line) {
#if __COMMENT_FLOW__
			fprintf(stderr, "unordered node (4)\n");
			fprintf(stderr, "expected %u+, got %u\n",
				(unsigned) *line, (unsigned) *call);
#endif				/* __COMMENT_FLOW__ */

			status = 139;
		    } else {
			*line = *call;

			status = even(node, rate, line);
		    }
		}
	    }
	}
    } else {
	call += 2;

	status = fine((void *) *(call + integral_q_last), rate, line);
	if (status) {
	} else {
	    if (*call < *line) {
#if __COMMENT_FLOW__
		fprintf(stderr, "unordered node (5)\n");
		fprintf(stderr, "expected %u+, got %u\n", (unsigned) *line,
			(unsigned) *call);
#endif				/* __COMMENT_FLOW__ */

		status = 139;
	    } else {
		*line = *call;

		status = even(node, rate, line);
	    }
	}
    }

    return status;
}


static int
fine(void *node, unsigned rate, integral_q *line)
{
    int status;
    integral_q *call;

    call = node;
    if (*call & 1) {
	integral_q news;

	news = *call;

	if (news ^ 1) {
	    if ((news & Lx55555555) ^ Lx55555555) {
		status = 136;

#if __COMMENT_FLOW__
		fprintf(stderr, "missing bit pattern (%08x found)\n",
			(unsigned) news);
#endif				/* __COMMENT_FLOW__ */
	    } else {
		if (rate) {
		    status = ever(node, rate - 1, line);
		} else {
		    status = deck(node, line);
		}
	    }
	} else {
	    status = 135;

#if __COMMENT_FLOW__
	    fprintf(stderr, "null size\n");
#endif				/* __COMMENT_FLOW__ */
	}
    } else {
	status = 133;

#if __COMMENT_FLOW__
	fprintf(stderr, "first bit not set\n");
#endif				/* __COMMENT_FLOW__ */
    }

    return status;
}


static int
lock(void *node, unsigned rate)
{
    int status;
    integral_q *call;
    unsigned size;

    call = node;

    size = *call;
    if (size) {
	rate--;

	if (1) {
	    integral_q slip = 0;
	    unsigned i = 0;

	    call++;

	    status = fine
		((void *) *(call + integral_q_bits_and_half - 1), rate, &slip);
	    if (status) {
	    } else {
		for (; i < size; i++) {
		    if (*call < slip) {
#if __COMMENT_FLOW__
			fprintf(stderr, "unordered elements\n");
#endif				/* __COMMENT_FLOW__ */

			status = 129;

			break;
		    } else {
			slip = *call;

			status = fine
			    ((void *) *(call + integral_q_bits_and_half), rate,
			     &slip);
			if (status) {
			    break;
			} else {
			    slip = *call;

			    call++;
			}
		    }
		}
	    }
	}
    } else {
	status = 128;

#if __COMMENT_FLOW__
	fprintf(stderr, "null root size\n");
#endif				/* __COMMENT_FLOW__ */
    }

    return status;
}


static int
mind(void *node)
{
    int status;
    integral_q *call;
    unsigned size;

    call = node;

    size = *call;
    if (size) {
	size--;
	if (size) {
	    unsigned i = 0;

	    call++;

	    for (; i < size; i++) {
		if (*(call + 1) < *call) {
		    break;
		}

		call++;
	    }

	    if (i ^ size) {
		status = 129;

#if __COMMENT_FLOW__
		fprintf(stderr, "unordered elements, root node\n");
#endif				/* __COMMENT_FLOW__ */
	    } else {
		status = 0;
	    }
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


int
x1f4_flow_bqpset(void *bqfset)
{
    int status;
    unsigned rate;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
    if (rate) {
	status = lock(bqfset(bqfset)->link_a.fpnews.node, rate);
    } else {
	status = mind(bqfset(bqfset)->link_a.fpnews.node);
    }

    return status;
}
