/*
 * bqpx.2.c
 * Copyright (C) 2009-2010, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-config.h>

#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-seven.h>
#include <bqpx-shift.h>
#include <bqpx-types.h>
#include <reverse.h>
#include <xfs.h>
#include <xls.h>

#define __LOCK_EXCESS__			1
#define __LOCK_SELECT__			2
#define __LOCK_TARGET__			3

#define __LOCK_METHOD__			__LOCK_EXCESS__

#define ____LOCK_METHOD__		__LOCK_METHOD__

#define __HEAD_LEFT__			1

#undef Q
#define Q(e)				((integral_q) (e))

#define true(e)				1

#define false(e)			0

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

#define case_link(rate) \
    copy = (rate)

#define case_miss() \
    status = EVER_MATCH;						      \
    if (1) {								      \
	break;								      \
    }

static int fine(void *, integral_q, unsigned *);
static int lock(void *, void *, unsigned, integral_q);
static int mind(void *, void *, integral_q);

static int
fine(void *node, integral_q mode, unsigned *pick)
{
    int status;
    integral_q *call;
    unsigned size;

    call = node;

    size = *call;

    call++;

    size--;
    while (size) {
	unsigned half;

	half = (size + 1) >> 1;
	if (mode < call[half]) {
	    size = half - 1;
	} else {
	    call += half;
	    size -= half;
	}
    }

    if (*call == mode) {
	status = EVER_MATCH;
    } else {
	status = 0;

	if (mode < *call) {
	} else {
	    call++;
	}

	*pick = call - 1 - (integral_q *) node;
    }

    return status;
}


static int
lock(void *bqfset, void *node, unsigned rate, integral_q mode)
{
    int status;

    while (1) {
	if (rate) {
	    unsigned copy;
	    void *down;

	    pipe_text(node, mode, case_miss, case_link);

	    down = PD(node)[copy];

	    if (~*(integral_q *) down) {
	    } else {
		status = _libx1f4l2_fare_bqpset
		    (bqfset, node, (void *) mode, copy, &down, rate);
		if (status) {
		    break;
		} else {
		    if (rate ^ 1) {
		    } else {
			break;
		    }
		}
	    }

	    rate--;

	    node = down;
	} else {
	    integral_q news;
	    unsigned test;

	    news = *KD(node);

	    status = 0;

#if SIZEOF_integral_q == 8
	    if (mode < KD(node)[040]) {
#endif				/* SIZEOF_integral_q == 8 */
		if (mode < KD(node)[020]) {
		    if (mode < KD(node)[010]) {
			if (mode < KD(node)[004]) {
			    if (mode < KD(node)[002]) {
				if (news & 2) {
				    if (mode ^ KD(node)[1]) {
					unsigned deck, ever;

					if (mode < KD(node)[1]) {
					    test = 1;
					} else {
					    test = 2;
					}

					l2_q_xfs(ever, ~news);
					if (1) {
					    *KD(node) = news | Q(1) << ever;
					    deck = ever - test;
					    SHIFT_M(node, ever, deck);
					    KD(node)[test] = mode;
					}
				    } else {
					status = EVER_MATCH;
				    }
				} else {
				    KD(node)[1] = mode;
				    *KD(node) = news | 2;
				}

				break;
			    } else {
				test = 002;
			    }
			} else {
			    if (mode < KD(node)[006]) {
				test = 004;
			    } else {
				test = 006;
			    }
			}
		    } else {
			if (mode < KD(node)[014]) {
			    if (mode < KD(node)[012]) {
				test = 010;
			    } else {
				test = 012;
			    }
			} else {
			    if (mode < KD(node)[016]) {
				test = 014;
			    } else {
				test = 016;
			    }
			}
		    }
		} else {
		    if (mode < KD(node)[030]) {
			if (mode < KD(node)[024]) {
			    if (mode < KD(node)[022]) {
				test = 020;
			    } else {
				test = 022;
			    }
			} else {
			    if (mode < KD(node)[026]) {
				test = 024;
			    } else {
				test = 026;
			    }
			}
		    } else {
			if (mode < KD(node)[034]) {
			    if (mode < KD(node)[032]) {
				test = 030;
			    } else {
				test = 032;
			    }
			} else {
			    if (mode < KD(node)[036]) {
				test = 034;
			    } else {
				test = 036;
			    }
			}
		    }
		}
#if SIZEOF_integral_q == 8
	    } else {
		if (mode < KD(node)[060]) {
		    if (mode < KD(node)[050]) {
			if (mode < KD(node)[044]) {
			    if (mode < KD(node)[042]) {
				test = 040;
			    } else {
				test = 042;
			    }
			} else {
			    if (mode < KD(node)[046]) {
				test = 044;
			    } else {
				test = 046;
			    }
			}
		    } else {
			if (mode < KD(node)[054]) {
			    if (mode < KD(node)[052]) {
				test = 050;
			    } else {
				test = 052;
			    }
			} else {
			    if (mode < KD(node)[056]) {
				test = 054;
			    } else {
				test = 056;
			    }
			}
		    }
		} else {
		    if (mode < KD(node)[070]) {
			if (mode < KD(node)[064]) {
			    if (mode < KD(node)[062]) {
				test = 060;
			    } else {
				test = 062;
			    }
			} else {
			    if (mode < KD(node)[066]) {
				test = 064;
			    } else {
				test = 066;
			    }
			}
		    } else {
			if (mode < KD(node)[074]) {
			    if (mode < KD(node)[072]) {
				test = 070;
			    } else {
				test = 072;
			    }
			} else {
			    if (mode < KD(node)[076]) {
				test = 074;
			    } else {
				test = 076;
			    }
			}
		    }
		}
	    }
#endif				/* SIZEOF_integral_q == 8 */

	    if (news & (Q(2) << test)) {
		integral_q *fast;

		fast = KD(node) + test + 1;
		if (mode < *fast) {
		    if (mode ^ *(fast - 1)) {
			if (news & (Q(1) << (test - 1))) {
#if ____LOCK_METHOD__ == __LOCK_SELECT__
			    integral_q last, next;

			    test++;
			    last = ~news;
			    next = last >> test;
			    last <<= integral_q_bits - test;
			    l2_q_reverse_1up(next);
			    next <<= 1;
			    if (last < next) {
				last = *fast;
				*fast = mode;
				fast++;
				next <<= 1;
				while (!(next
					 & Q(3) << (integral_q_bits - 2))) {
				    next <<= 2;
				    mode = *fast;
				    *fast = last;
				    fast++;
				    last = *fast;
				    *fast = mode;
				    fast++;
				}
				if (true(!(next & Q(1) << integral_q_last))) {
				    mode = *fast;
				    *fast = last;
				    fast++;
				    *fast = mode;
				} else {
				    *fast = last;
				}

				*KD(node) = news | Q(1) << (fast - KD(node));
			    } else {
				fast--;
				next = *fast;
				*fast = mode;
				fast--;
				last <<= 1;
				while (!(last
					 & Q(3) << (integral_q_bits - 2))) {
				    last <<= 2;
				    mode = *fast;
				    *fast = next;
				    fast--;
				    next = *fast;
				    *fast = mode;
				    fast--;
				}
				if (false(!(last & Q(1) << integral_q_last))) {
				    mode = *fast;
				    *fast = next;
				    fast--;
				    *fast = mode;
				} else {
				    *fast = next;
				}

				*KD(node) = news | Q(1) << (fast - KD(node));
			    }
#elif __LOCK_METHOD__ == __LOCK_EXCESS__
			    integral_q last, next;

			    test++;
			    last = ~news;
			    next = last >> test;
			    last <<= integral_q_bits - test;
			    l2_q_reverse_1up(last);
			    last <<= 2;
			    next |= last;
			    next &= (next - 1) << 1;
			    if (last & next) {
				fast--;
				last = *fast;
				*fast = mode;
				fast--;
				next >>= 4;
				while (next) {
				    next >>= 2;
				    mode = *fast;
				    *fast = last;
				    fast--;
				    last = *fast;
				    *fast = mode;
				    fast--;
				}
				if (0) {
				    mode = *fast;
				    *fast = last;
				    fast--;
				    *fast = mode;
				} else {
				    *fast = last;
				}

				*KD(node) = news | Q(1) << (fast - KD(node));
			    } else {
				last = *fast;
				*fast = mode;
				fast++;
				next >>= 3;
				while (next) {
				    next >>= 2;
				    mode = *fast;
				    *fast = last;
				    fast++;
				    last = *fast;
				    *fast = mode;
				    fast++;
				}
				if (1) {
				    mode = *fast;
				    *fast = last;
				    fast++;
				    *fast = mode;
				} else {
				    *fast = last;
				}

				*KD(node) = news | Q(1) << (fast - KD(node));
			    }
#elif __LOCK_METHOD__ == __LOCK_TARGET__
			    integral_q slip;
			    unsigned deck, ever;

			    test++;
			    slip = ~news & (~Q(0) << test);
			    if (slip) {
				l2_q_xfs(ever, slip);
# if __HEAD_LEFT__
				slip = ((Q(1) << ever) - (Q(1) << test))
				    >> (ever - test) & ~news;
				if (slip) {
				    l2_q_xls(deck, slip);
				    deck ^= integral_q_last;
				    if (1) {
					*KD(node) = news | Q(1) << deck;
					test--;
					ever = test - deck;
					STRIP_P(node, deck, ever);
					KD(node)[test] = mode;
				    }
				} else {
				    if (1) {
					*KD(node) = news | Q(1) << ever;
					deck = ever - test;
					TRANS_M(node, ever, deck);
					KD(node)[test] = mode;
				    }
				}
# else
				slip = ~news & ((Q(1) << test) - 1);
				if (slip) {
				    l2_q_xls(deck, slip);
				    deck ^= integral_q_last;
				    if (test - deck < ever - test) {
					*KD(node) = news | Q(1) << deck;
					test--;
					ever = test - deck;
					STRIP_P(node, deck, ever);
					KD(node)[test] = mode;
				    } else {
					*KD(node) = news | Q(1) << ever;
					deck = ever - test;
					TRANS_M(node, ever, deck);
					KD(node)[test] = mode;
				    }
				} else {
				    if (1) {
					*KD(node) = news | Q(1) << ever;
					deck = ever - test;
					TRANS_M(node, ever, deck);
					KD(node)[test] = mode;
				    }
				}
# endif				/* __HEAD_LEFT__ */
			    } else {
				l2_q_xls(deck, ~news);
				if (1) {
				    deck ^= integral_q_last;
				    if (1) {
					*KD(node) = news | Q(1) << deck;
					test--;
					ever = test - deck;
					STRIP_P(node, deck, ever);
					KD(node)[test] = mode;
				    }
				}
			    }
#endif				/* ____LOCK_METHOD__ == __LOCK_SELECT__ */
			} else {
			    test--;
			    fast = KD(node) + test;
			    *fast = *(fast + 1);
			    *(fast + 1) = mode;
			    *KD(node) = news | Q(1) << test;
			}
		    } else {
			status = EVER_MATCH;
		    }
		} else {
		    test++;
		    if (mode ^ *fast) {
			if (1) {
#if ____LOCK_METHOD__ == __LOCK_SELECT__
			    integral_q last, next;

			    last = ~news;
			    next = last >> 1 >> test;
			    test++;
			    last <<= integral_q_bits - test;
			    l2_q_reverse_1up(next);
			    next >>= 1;
			    if (last < next) {
				fast++;
				last = *fast;
				*fast = mode;
				fast++;
				next <<= 1;
				while (!(next
					 & Q(3) << (integral_q_bits - 2))) {
				    next <<= 2;
				    mode = *fast;
				    *fast = last;
				    fast++;
				    last = *fast;
				    *fast = mode;
				    fast++;
				}
				if (false(!(next & Q(1) << integral_q_last))) {
				    mode = *fast;
				    *fast = last;
				    fast++;
				    *fast = mode;
				} else {
				    *fast = last;
				}

				*KD(node) = news | Q(1) << (fast - KD(node));
			    } else {
				next = *fast;
				*fast = mode;
				fast--;
				last <<= 1;
				while (!(last
					 & Q(3) << (integral_q_bits - 2))) {
				    last <<= 2;
				    mode = *fast;
				    *fast = next;
				    fast--;
				    next = *fast;
				    *fast = mode;
				    fast--;
				}
				if (true(!(last & Q(1) << integral_q_last))) {
				    mode = *fast;
				    *fast = next;
				    fast--;
				    *fast = mode;
				} else {
				    *fast = next;
				}

				*KD(node) = news | Q(1) << (fast - KD(node));
			    }
#elif __LOCK_METHOD__ == __LOCK_EXCESS__
			    integral_q last, next;

			    last = ~news;
			    next = last >> 1 >> test;
			    test++;
			    last <<= integral_q_bits - test;
			    l2_q_reverse_1up(last);
			    next |= last;
			    next &= (next - 1) << 1;
			    if (last & next) {
				last = *fast;
				*fast = mode;
				fast--;
				next >>= 4;
				while (next) {
				    next >>= 2;
				    mode = *fast;
				    *fast = last;
				    fast--;
				    last = *fast;
				    *fast = mode;
				    fast--;
				}
				if (1) {
				    mode = *fast;
				    *fast = last;
				    fast--;
				    *fast = mode;
				} else {
				    *fast = last;
				}

				*KD(node) = news | Q(1) << (fast - KD(node));
			    } else {
				fast++;
				last = *fast;
				*fast = mode;
				fast++;
				next >>= 3;
				while (next) {
				    next >>= 2;
				    mode = *fast;
				    *fast = last;
				    fast++;
				    last = *fast;
				    *fast = mode;
				    fast++;
				}
				if (0) {
				    mode = *fast;
				    *fast = last;
				    fast++;
				    *fast = mode;
				} else {
				    *fast = last;
				}

				*KD(node) = news | Q(1) << (fast - KD(node));
			    }
#elif __LOCK_METHOD__ == __LOCK_TARGET__
			    integral_q slip;
			    unsigned deck, ever;

			    slip = ~news & (~Q(0) << test << 1);
			    if (slip) {
				test++;
				l2_q_xfs(ever, slip);
# if __HEAD_LEFT__
				slip = ((Q(1) << ever) - (Q(1) << test))
				    >> (ever - test) & ~news;
				if (slip) {
				    l2_q_xls(deck, slip);
				    deck ^= integral_q_last;
				    if (1) {
					*KD(node) = news | Q(1) << deck;
					test--;
					ever = test - deck;
					TRANS_P(node, deck, ever);
					KD(node)[test] = mode;
				    }
				} else {
				    if (1) {
					*KD(node) = news | Q(1) << ever;
					deck = ever - test;
					STRIP_M(node, ever, deck);
					KD(node)[test] = mode;
				    }
				}
# else
				slip = ~news & ((Q(1) << test) - 1);
				if (slip) {
				    l2_q_xls(deck, slip);
				    deck ^= integral_q_last;
				    if (test - deck < ever - test) {
					*KD(node) = news | Q(1) << deck;
					test--;
					ever = test - deck;
					TRANS_P(node, deck, ever);
					KD(node)[test] = mode;
				    } else {
					*KD(node) = news | Q(1) << ever;
					deck = ever - test;
					STRIP_M(node, ever, deck);
					KD(node)[test] = mode;
				    }
				} else {
				    if (1) {
					*KD(node) = news | Q(1) << ever;
					deck = ever - test;
					STRIP_M(node, ever, deck);
					KD(node)[test] = mode;
				    }
				}
# endif				/* __HEAD_LEFT */
			    } else {
				l2_q_xls(deck, ~news);
				if (1) {
				    deck ^= integral_q_last;
				    if (1) {
					*KD(node) = news | Q(1) << deck;
					ever = test - deck;
					TRANS_P(node, deck, ever);
					KD(node)[test] = mode;
				    }
				}
			    }
#endif				/* ____LOCK_METHOD__ == __LOCK_SELECT__ */
			}
		    } else {
			status = EVER_MATCH;
		    }
		}
	    } else {
		integral_q *fast;

		fast = KD(node) + test;
		if (mode ^ *fast) {
		    test++;
		    *(fast + 1) = mode;
		    *KD(node) = news | Q(1) << test;
		} else {
		    status = EVER_MATCH;
		}
	    }

	    break;
	}
    }

    return status;
}


static int
mind(void *bqfset, void *node, integral_q mode)
{
    int status;
    integral_q *call;
    unsigned mind;

    call = node;

    mind = *call;

    if (mind) {
	unsigned size;

	size = mind;

	call++;

	size--;
	while (size) {
	    unsigned half;

	    half = (size + 1) >> 1;
	    if (mode < call[half]) {
		size = half - 1;
	    } else {
		call += half;
		size -= half;
	    }
	}

	if (*call == mode) {
	    status = EVER_MATCH;
	} else {
#if __MICRO_FSETS__
	    do {
#endif				/* __MICRO_FSETS__ */
		unsigned miss;
#if __MICRO_FSETS__
		unsigned sans;
#endif				/* __MICRO_FSETS__ */

		miss = call - (integral_q *) node;

		mind++;

#if __MICRO_FSETS__
		sans = mind & mind << 1;
		if (sans & (sans - 1)) {
		} else {
		    sans |= sans >> 1;
		    if (mind ^ sans) {
		    } else {
			sans <<= 1;
			if (sans == integral_q_bits_and_half) {
			    sans *= SIZEOF_integral_q << 1;
			} else {
			    sans *= SIZEOF_integral_q;
			}

			status = bqfset(bqfset)->link_m.mode
			    (bqfset(bqfset)->link_m.data, &node, sans);
			if (status) {
			    status = MODE_ERROR;
			    if (1) {
				break;
			    }
			} else {
			    bqfset(bqfset)->link_a.fpnews.node = node;
			}

			call = node;
			call += miss;
		    }
		}
#endif				/* __MICRO_FSETS__ */

#if __MICRO_FSETS__
#else
		status = 0;
#endif				/* __MICRO_FSETS__ */

		if (*call < mode) {
		    call++;
		    miss++;
		} else {
		}

		memmove(call + 1, call, (mind - miss) * sizeof(integral_q));

		*call = mode;

		*((integral_q *) node) = mind;
#if __MICRO_FSETS__
	    } while (0);
#endif				/* __MICRO_FSETS__ */
	}
    } else {
	status = 0;

	*call = 1;
	call[1] = mode;
    }

    return status;
}


int
x1f4_post_bqpset(void *bqfset, integral_q mode)
{
    int status;

    do {
	unsigned rate;
	void *node;

	rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

	node = bqfset(bqfset)->link_a.fpnews.node;

	if (*(integral_q *) node ^ (integral_q_bits_and_half - 1)) {
	} else {
	    status = _libx1f4l2_long_bqpset(bqfset, (void *) mode, rate);
	    if (status) {
		break;
	    } else {
		if (rate) {
		    node = bqfset(bqfset)->link_a.fpnews.node;

		    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
		} else {
		    break;
		}
	    }
	}

	if (rate) {
	    unsigned copy;
	    void *down;

	    status = fine(node, mode, &copy);
	    if (status) {
		break;
	    }

	    down = ND(node)[copy];

	    if (~*(integral_q *) down) {
	    } else {
		status = _libx1f4l2_hale_bqpset
		    (bqfset, node, (void *) mode, copy, &down, rate);
		if (status) {
		    break;
		} else {
		    if (rate ^ 1) {
		    } else {
			break;
		    }
		}
	    }

	    rate--;

	    node = down;

	    status = lock(bqfset, node, rate, mode);
	} else {
	    status = mind(bqfset, node, mode);
	}
    } while (0);

    return status;
}
