/*
 * bqfx.w.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-names.h>
#include <bqfx-types.h>

static int mind(void *, unsigned, void *, int (*) (void *, void *));

static int
mind(void *node, unsigned size, void *back, int (*call) (void *, void *))
{
    int delete;
    integral_q news;

    news = *(integral_q *) node;
    if (news & 2) {
	node = (char *) node + size;
	delete = call(back, node);
	if (delete) {
	} else {
	    news >>= 2;
	    while (news) {
		node = (char *) node + size;
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    node = (char *) node + size;
		    if (news & 2) {
			delete = call(back, node);
			if (delete) {
			    break;
			}
		    }
		}

		news >>= 2;
	    }
	}
    } else {
	node = (char *) node + size;
	news >>= 2;
	do {
	    node = (char *) node + size;
	    delete = call(back, node);
	    if (delete) {
		break;
	    } else {
		node = (char *) node + size;
		if (news & 2) {
		    delete = call(back, node);
		    if (delete) {
			break;
		    }
		}
	    }

	    news >>= 2;
	} while (news);
    }

    return delete;
}


int
_libx1f4l2_fpxx_bqfset(void *node, unsigned rate, unsigned size, void *back,
		       int (*call) (void *, void *))
{
    int delete;
    integral_q news;
    void **text;

    news = *(integral_q *) node;

    text = (void **) ((char *) node + size * integral_q_bits);

    rate--;

    if (rate) {
	do {
	    if (news & 2) {
		delete = _libx1f4l2_fpxx_bqfset(*text, rate, size, back, call);
		if (delete) {
		    break;
		} else {
		    node = (char *) node + size;

		    delete = call(back, node);
		    if (delete) {
			break;
		    } else {
			node = (char *) node + size;
		    }
		}
	    } else {
		node = (char *) node + (size << 1);
	    }

	    text++;

	    {
		delete = _libx1f4l2_fpxx_bqfset(*text, rate, size, back, call);
		if (delete) {
		    break;
		}
	    }

	    text++;

	    news >>= 2;

	    do {
		delete = call(back, node);
		if (delete) {
		    break;
		}

		if (news & 2) {
		    delete = _libx1f4l2_fpxx_bqfset
			(*text, rate, size, back, call);
		    if (delete) {
			break;
		    } else {
			node = (char *) node + size;

			delete = call(back, node);
			if (delete) {
			    break;
			} else {
			    node = (char *) node + size;
			}
		    }
		} else {
		    node = (char *) node + (size << 1);
		}

		text++;

		{
		    delete = _libx1f4l2_fpxx_bqfset
			(*text, rate, size, back, call);
		    if (delete) {
			break;
		    }
		}

		text++;

		news >>= 2;
	    } while (news);
	} while (0);
    } else {
	do {
	    if (news & 2) {
		delete = mind(*text, size, back, call);
		if (delete) {
		    break;
		} else {
		    node = (char *) node + size;

		    delete = call(back, node);
		    if (delete) {
			break;
		    } else {
			node = (char *) node + size;
		    }
		}
	    } else {
		node = (char *) node + (size << 1);
	    }

	    text++;

	    {
		delete = mind(*text, size, back, call);
		if (delete) {
		    break;
		}
	    }

	    text++;

	    news >>= 2;

	    do {
		delete = call(back, node);
		if (delete) {
		    break;
		}

		if (news & 2) {
		    delete = mind(*text, size, back, call);
		    if (delete) {
			break;
		    } else {
			node = (char *) node + size;

			delete = call(back, node);
			if (delete) {
			    break;
			} else {
			    node = (char *) node + size;
			}
		    }
		} else {
		    node = (char *) node + (size << 1);
		}

		text++;

		{
		    delete = mind(*text, size, back, call);
		    if (delete) {
			break;
		    }
		}

		text++;

		news >>= 2;
	    } while (news);
	} while (0);
    }

    return delete;
}
