/*
 * bqfx.w.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-names.h>
#include <bqfx-types.h>

int
_libx1f4l2_flxx_bqfset(void *node, unsigned size, void *back,
		       int (*call) (void *, void *))
{
    int delete;
    integral_q news;

    news = *(integral_q *) node;
    if (news & 2) {
	node = (char *) node + size;
	delete = call(back, node);
	if (delete) {
	} else {
	    news >>= 2;
	    while (news) {
		node = (char *) node + size;
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    node = (char *) node + size;
		    if (news & 2) {
			delete = call(back, node);
			if (delete) {
			    break;
			}
		    }
		}

		news >>= 2;
	    }
	}
    } else {
	node = (char *) node + size;
	news >>= 2;
	do {
	    node = (char *) node + size;
	    delete = call(back, node);
	    if (delete) {
		break;
	    } else {
		node = (char *) node + size;
		if (news & 2) {
		    delete = call(back, node);
		    if (delete) {
			break;
		    }
		}
	    }

	    news >>= 2;
	} while (news);
    }

    return delete;
}
