/*
 * bqfx.u.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bcount.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define __HALF_TRANSFER__		1

#define __UNROLL_TRANSFER__		0

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_blue_bqfset(void *bqfset, void **lead, void *node, unsigned *mile,
		       void **lock, void **lane, unsigned *rate)
{
    int (*move) (void *, void *, unsigned);
    integral_q next;
    unsigned copy, deck, ever, pick, size;
    void *club, *file, *tier;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    club = *lead;

    file = *lock;

    tier = *lane;

    pick = *mile;

    copy = *rate;

    if (1) {
	void *fast, *side;

	*(integral_q *) file = Lx55555555;

	fast = rule(file, size, copy);

	deck = (integral_q_bits - copy - 2) >> 1;

#if __UNROLL_TRANSFER__
# error
#else
	ever = deck >> 1;
	for (; ever; ever--) {
	    side = road(fast, size);
	    move(fast, side, 1);
	    fast = road(side, size);
	    move(side, fast, 1);
	}
	if (deck & 1) {
	    side = road(fast, size);
	    move(fast, side, 1);
	    fast = side;
	}
#endif				/* __UNROLL_TRANSFER__ */
	{
	    move(fast, rule(node, size, pick + 1), 1);
	}

	{
	    move(rule(node, size, pick + 1), (char *) tier + (size << 1), 1);
	}

	*(integral_q *) tier = Lx55555555 ^ Q(4);
    }

    if (1) {
	club = file;

	file = tier;
    } else {
    }

    pick++;

    tier = MD(node, size)[pick + 1];

    next = *(integral_q *) tier & ~Lx55555555;
    if (next) {
#if __HALF_TRANSFER__
	if (1) {
	    integral_q text;
	    unsigned slip;
	    void *fast, *side;

	    fast = road(file, size);

	    deck = (integral_q_bits - 2 - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
	    ever = deck >> 1;
	    for (; ever; ever--) {
		side = road(fast, size);
		move(fast, side, 1);
		fast = road(side, size);
		move(side, fast, 1);
	    }
	    if (deck & 1) {
		move(fast, road(fast, size), 1);
	    }
# endif				/* __UNROLL_TRANSFER__ */

	    l2_q_bitcount(ever, next);

	    if (ever < 4) {
		ever = 1;

		*(integral_q *) file = Lx55555555;

		fast = rule(file, size, integral_q_bits - 2);
	    } else {
		ever &= ~1;

		*(integral_q *) file = Lx55555555
		    | ~Q(0) << (integral_q_bits - ever + 2);

		if (ever < 8) {
		    ever >>= 1;

		    fast = rule(file, size, integral_q_bits - ever);
		} else {
		    fast = rule(file, size, integral_q_bits - ever + 3);

		    side = sans(fast, size);

		    ever >>= 1;

		    deck = ever - 3;
		    for (; deck; deck--) {
			move(fast, side, 1);
			dana(side, size);
			skip(fast, size);
		    }
		}
	    }

	    move(fast, rule(node, size, pick + 1), 1);

	    skip(fast, size);

	    ever--;

	    side = tier;

	    text = *(integral_q *) tier;

	    while (ever & ~1) {
		if (text & Q(2)) {
		    skip(side, size);
		    move(fast, side, 1);
		    skip(fast, size);
		    skip(side, size);
		    move(fast, side, 1);
		    skip(fast, size);

		    ever -= 2;
		} else {
		    ever--;

		    dana(side, size);
		    move(fast, side, 1);
		    skip(fast, size);
		}

		text >>= 2;
	    }
	    if (ever) {
		if (text & Q(2)) {
		    skip(side, size);
		    move(fast, side, 1);
		    skip(side, size);
		    move(rule(node, size, pick + 1), side, 1);

		    ever = 0;
		} else {
		    dana(side, size);
		    move(fast, side, 1);
		}

		text >>= 2;
	    } else {
		ever = 1;
	    }
	    slip = 2;
	    if (ever) {
		if (text & Q(2)) {
		    skip(side, size);
		    move(rule(node, size, pick + 1), side, 1);

		    skip(side, size);

		    fast = road(tier, size);

		    text >>= 1;
		} else {
		    dana(side, size);
		    move(rule(node, size, pick + 1), side, 1);

		    skip(side, size);

		    fast = road(tier, size);

		    text >>= 2;

		    if (fast < side) {
			text >>= 1;
			if (text & Q(1)) {
			    move(fast, side, 1);
			    dana(fast, size);
			    slip += 2;
			} else {
			}

			skip(side, size);
		    }
		}
	    } else {
		skip(side, size);

		fast = road(tier, size);

		if (fast < side) {
		    text >>= 1;
		    if (text & Q(1)) {
			move(fast, side, 1);
			dana(fast, size);
			slip += 2;
		    } else {
		    }

		    skip(side, size);
		}
	    }
	    while (fast < side) {
		if (text & Q(4)) {
		    move(fast, side, 1);
		    dana(fast, size);
		    skip(side, size);
		    move(fast, side, 1);
		    dana(fast, size);
		    skip(side, size);
		    slip += 4;
		} else {
		    move(fast, side, 1);
		    dana(fast, size);
		    dana(side, size);
		    slip += 2;
		}

		text >>= 2;
	    }

	    *(integral_q *) tier = Lx55555555 | text >> 1 << (slip - 1) << 1;
	}
#else
# error
#endif				/* __HALF_TRANSFER__ */
    } else {
	*rate = 2;

	*mile = pick;

	*lane = tier;

	*lock = file;

	*lead = club;
    }

    return 0;
}
