/*
 * bqfx.t.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <xfs.h>
#include <xls.h>

#define __UNROLL_TRANSFER__		0

#define __HEAD_LEFT__			1

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define cell(___s, ___n, ___t) \
    ((char *) (___s) - (___n) * (___t))

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int east(void *, unsigned, unsigned,
		int (*) (void *, void *, unsigned));
static int edge(void *, unsigned, unsigned,
		int (*) (void *, void *, unsigned));

static int
east(void *node, unsigned size, unsigned call,
     int (*move) (void *, void *, unsigned))
{
    integral_q news, slip;

    news = *(integral_q *) node;

    slip = news & ~Lx55555555;

    {
	if (0) {
	} else {
	    unsigned deck, ever;

	    l2_q_xls(deck, slip);
	    if (1) {
		deck ^= integral_q_last;
		if (deck ^ (integral_q_bits - 1)) {
		    void *data, **text;

		    *(integral_q *) node = news & ~(Q(1) << deck);

		    text = ZD(node, size) + integral_q_last;
		    if (1) {
			*text = *(text - 2);
		    }

		    call--;
		    data = HD(node, size, call);
		    call--;
		    text = ZD(node, size) + call;

		    ever = (integral_q_bits - 3 - deck) >> 1;
		    for (; ever; ever--) {
			void *trip;

			trip = lola(data, size);
			move(data, trip, 1);
			data = trip;
			*text = *(text - 2);
			text -= 2;
		    }
		    {
			move(data, life(data, size), 1);
			*text = *(text - 1);
		    }
		} else {
		    void **text;

		    *(integral_q *) node = news & ~(Q(1) << deck);

		    text = ZD(node, size) + integral_q_last;
		    if (1) {
			*text = *(text - 1);
		    }
		}
	    }
	}
    }

    return 0;
}


static int
edge(void *node, unsigned size, unsigned call,
     int (*move) (void *, void *, unsigned))
{
    integral_q news, slip;

    news = *(integral_q *) node;

    slip  = news & ~Lx55555555;

    {
	if (1) {
	    call++;

	    if (call & 1) {
		*(integral_q *) node = news & ~(Q(1) << call);
	    } else {
		if (news & (Q(1) << (call - 1))) {
		    *(integral_q *) node = news & ~(Q(1) << (call - 1));
		    if (2) {
			void *data, **text;

			data = HD(node, size, call);
			move(data, life(data, size), 1);
			call--;
			text = ZD(node, size) + call;
			*text = *(text - 1);
		    }
		} else {
		    if (news & (Q(1) << (call + 1))) {
			void *data, **text;

			*(integral_q *) node = news & ~(Q(1) << (call + 1));
			data = HD(node, size, call);
			move(data, sans(data, size), 1);
			text = ZD(node, size) + call;
			*(text - 1) = *text;
		    } else {
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << call);
			if (back) {
			    l2_q_xfs(ever, back);
#if __HEAD_LEFT__
			    slip &= ((Q(1) << ever) - (Q(1) << call))
				>> (ever - call);
			    if (slip) {
				l2_q_xls(deck, slip);
				deck ^= integral_q_last;
				if (1) {
				    void *data, **text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    data = rule(node, size, call);
				    call--;
				    text = ZD(node, size) + call;
				    for (; ever; ever--) {
					void *trip;

					trip = lola(data, size);
					move(data, trip, 1);
					data = trip;
					*text = *(text - 2);
					text -= 2;
				    }
				    {
					move(data, life(data, size), 1);
					*text = *(text - 1);
				    }
				}
			    } else {
				if (2) {
				    void *data, **text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    text = ZD(node, size) + call;
				    call++;
				    data = rule(node, size, call);
				    for (; deck; deck--) {
					void *trip;

					*text = *(text + 2);
					text += 2;
					trip = road(data, size);
					move(data, trip, 1);
					data = trip;
				    }
				    {
					*text = *(text + 1);
					move(data, sans(data, size), 1);
				    }
				}
			    }
#else
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (deck ^ integral_q_bits) {
				deck ^= integral_q_last;
				if (call - deck < ever - call) {
				    void *data, **text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    data = rule(node, size, call);
				    call--;
				    text = ZD(node, size) + call;
				    for (; ever; ever--) {
					void *trip;

					trip = lola(data, size);
					move(data, trip, 1);
					data = trip;
					*text = *(text - 2);
					text -= 2;
				    }
				    {
					move(data, life(data, size), 1);
					*text = *(text - 1);
				    }
				} else {
				    void *data, **text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    text = ZD(node, size) + call;
				    call++;
				    data = rule(node, size, call);
				    for (; deck; deck--) {
					void *trip;

					*text = *(text + 2);
					text += 2;
					trip = road(data, size);
					move(data, trip, 1);
					data = trip;
				    }
				    {
					*text = *(text + 1);
					move(data, sans(data, size), 1);
				    }
				}
			    } else {
				if (2) {
				    void *data, **text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    text = ZD(node, size) + call;
				    call++;
				    data = rule(node, size, call);
				    for (; deck; deck--) {
					void *trip;

					*text = *(text + 2);
					text += 2;
					trip = road(data, size);
					move(data, trip, 1);
					data = trip;
				    }
				    {
					*text = *(text + 1);
					move(data, sans(data, size), 1);
				    }
				}
			    }
#endif				/* __HEAD_LEFT__ */
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    void *data, **text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    data = rule(node, size, call);
				    call--;
				    text = ZD(node, size) + call;
				    for (; ever; ever--) {
					void *trip;

					trip = lola(data, size);
					move(data, trip, 1);
					data = trip;
					*text = *(text - 2);
					text -= 2;
				    }
				    {
					move(data, life(data, size), 1);
					*text = *(text - 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return 0;
}


int
_libx1f4l2_rail_bqfset(void *bqfset, unsigned size, void *node, void *file,
		       unsigned call, unsigned copy, integral_q pipe,
		       integral_q last, integral_q next, void *club,
		       void *head, void *past, void *tier)
{
    int status;

    do {
	if (tier) {
	    if (club) {
	    } else {
		head = past;

		_libx1f4l2_four_bqfset
		    (bqfset, last, &club, pipe, &node, &call, &file, &past,
		     &tier, next, &copy);
		if (club) {
		} else {
		    status = 0;
		    if (1) {
			break;
		    }
		}
	    }
	} else {
	    if (1) {
		past = head;

		_libx1f4l2_nine_bqfset
		    (bqfset, last, &club, pipe, &node, &call, &head, &file,
		     &tier, next, &copy);
		if (tier) {
		} else {
		    status = 0;
		    if (1) {
			break;
		    }
		}
	    }
	}

	{
	    int (*move) (void *, void *, unsigned);
	    unsigned deck;
	    void *fast;

	    move = bqfset(bqfset)->link_f.move;

	    if (1) {
		if (copy) {
		} else {
		    copy = 2;

		    move(head, road(file, size), 1);
		}
	    }

	    {
		void *side;

		fast = club;

		*(integral_q *) club = Lxdddddddd ^ Q(1) << integral_q_last;

		if (0) {
		} else {
		    fast = rule(fast, size, 4);

		    side = life(fast, size);

		    move(side, fast, 1);
		    dana(fast, size);
		    skip(side, size);
		}

		deck = (integral_q_bits - 6) / 6;
		for (; deck; deck--) {
		    move(side, fast, 1);
		    dana(fast, size);
		    dana(side, size);
		    move(side, fast, 1);
		    dana(fast, size);
		    skip(side, size);
		    move(side, fast, 1);
		    dana(fast, size);
		    skip(side, size);
		}

		if (copy < half_integral_q_bits - 2) {
		    pipe = Q(1) << (copy + 1 - 2);
		} else {
		    pipe = 0;
		}

		if (0) {
		} else {
		    if (half_integral_q_bits % 3 ^ 2) {
			move(side, fast, 1);

			fast = file;

			fast = rule(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			dana(side, size);
			move(side, head, 1);
			skip(side, size);
			move(side, fast, 1);
			skip(side, size);
		    } else {
			move(side, fast, 1);
			dana(fast, size);
			dana(side, size);
			move(side, fast, 1);

			fast = file;

			skip(side, size);
			move(side, head, 1);
			skip(side, size);
		    }
		}

		deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
		for (; deck; deck--) {
		    if (pipe & Q(63)) {
			fast = rule(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
			dana(side, size);
			fast = rule(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
			skip(side, size);
			fast = rule(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
			skip(side, size);
		    } else {
			dana(fast, size);
			move(side, fast, 1);
			dana(side, size);
			dana(fast, size);
			move(side, fast, 1);
			skip(side, size);
			dana(fast, size);
			move(side, fast, 1);
			skip(side, size);

			pipe >>= 6;
		    }
		}

		{
		    fast = rule(fast, size, 2 + (pipe & 2));
		    pipe >>= 2;
		    move(side, fast, 1);
		    dana(side, size);
		    fast = rule(fast, size, 2 + (pipe & 2));
		    pipe >>= 2;
		    move(side, fast, 1);
		}

		fast = rule(tier, size, integral_q_bits);

		side = fast;

		deck = integral_q_bits / 6;
		for (; deck; deck--) {
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		    beta(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		}

		if (half_integral_q_bits < copy) {
		    pipe = Q(1) << (integral_q_bits - 2 + 1 - copy);
		} else {
		    pipe = 0;
		}

		if (0) {
		} else {
		    if (half_integral_q_bits % 3 ^ 2) {
			fast = rule(file, size, integral_q_bits);

			posh(side, size);
			move(side, past, 1);
			posh(side, size);
			fast = cell(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
			beta(side, size);
			fast = cell(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
		    } else {
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);

			fast = rule(file, size, integral_q_bits);

			posh(side, size);
			move(side, past, 1);
			beta(side, size);
			fast = cell(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
		    }
		}

		deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
		for (; deck; deck--) {
		    if (pipe & Q(63)) {
			posh(side, size);
			fast = cell(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
			posh(side, size);
			fast = cell(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
			beta(side, size);
			fast = cell(fast, size, 2 + (pipe & 2));
			pipe >>= 2;
			move(side, fast, 1);
		    } else {
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);
			beta(side, size);
			beta(fast, size);
			move(side, fast, 1);

			pipe >>= 6;
		    }
		}

		{
		    posh(side, size);
		    fast = cell(fast, size, 2 + (pipe & 2));
		    pipe >>= 2;
		    move(side, fast, 1);
		    posh(side, size);
		    fast = cell(fast, size, 2 + (pipe & 2));
		    pipe >>= 2;
		    move(side, fast, 1);
		}

		*(integral_q *) tier = Lxdddddddd;
	    }

	    if (copy < half_integral_q_bits) {
		fast = rule(file, size, half_integral_q_bits);
	    } else {
		fast = rule(file, size, half_integral_q_bits - 2);
	    }

	    if (call ^ integral_q_last) {
		int excess;

		move(head, fast, 1);

		status = edge(node, size, call, move);

		excess = bqfset(bqfset)->link_m.free
		    (bqfset(bqfset)->link_m.data, file);
		if (excess) {
		    status = FREE_ERROR;
		}
	    } else {
		int excess;

		move(past, fast, 1);

		status = east(node, size, call, move);

		excess = bqfset(bqfset)->link_m.free
		    (bqfset(bqfset)->link_m.data, file);
		if (excess) {
		    status = FREE_ERROR;
		}
	    }
	}
    } while (0);

    return status;
}
