/*
 * bqfx.s.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_fold_bqfset(void *bqfset, void *club, void *file, void *tier,
		       unsigned pick, unsigned copy, void *node)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned deck, size;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    if (pick) {
	void *fast, *side;

	*(integral_q *) node = integral_q_bits - 2;

	fast = club;

	side = node;

	side = (char *) node + size;

	move((char *) side + (half_integral_q_bits - 1) * size, side, 1);

	deck = half_integral_q_bits - 1;
	for (; deck; deck--) {
	    fast = (char *) fast + (size << 1);
	    move(side, fast, 1);
	    side = (char *) side + size;
	}

	fast = (char *) file + (size << 1);

	deck = (copy - 2) >> 1;
	for (; deck; deck--) {
	    side = (char *) side + size;
	    move(side, fast, 1);
	    fast = (char *) fast + (size << 1);
	}

	deck = (integral_q_bits - copy - 2) >> 1;
	for (; deck; deck--) {
	    side = (char *) side + size;
	    fast = (char *) fast + (size << 1);
	    move(side, fast, 1);
	}

	{
	    int excess;

	    bqfset(bqfset)->link_a.fpnews.link_v.rate = 0;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, club);
	    if (status) {
		status = FREE_ERROR;
	    }

	    excess = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (excess) {
		status = FREE_ERROR;
	    }
	}
    } else {
	void *fast, *side;

	*(integral_q *) node = integral_q_bits - 2;

	fast = (char *) file + (size << 1);

	side = (char *) node + size;

	move((char *) side + (half_integral_q_bits - 2) * size, side, 1);

	deck = (copy - 2) >> 1;
	for (; deck; deck--) {
	    move(side, fast, 1);
	    fast = (char *) fast + (size << 1);
	    side = (char *) side + size;
	}

	deck = (integral_q_bits - copy - 2) >> 1;
	for (; deck; deck--) {
	    fast = (char *) fast + (size << 1);
	    move(side, fast, 1);
	    side = (char *) side + size;
	}

	fast = tier;

	deck = half_integral_q_bits - 1;
	for (; deck; deck--) {
	    side = (char *) side + size;
	    fast = (char *) fast + (size << 1);
	    move(side, fast, 1);
	}

	{
	    int excess;

	    bqfset(bqfset)->link_a.fpnews.link_v.rate = 0;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;
	    }

	    excess = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, tier);
	    if (excess) {
		status = FREE_ERROR;
	    }
	}
    }

    return status;
}
