/*
 * bqfx.r.c
 * Copyright (C) 2009-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <xfs.h>
#include <xls.h>

#define __HEAD_LEFT__			1

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define cell(___s, ___n, ___t) \
    ((char *) (___s) - (___n) * (___t))

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#define true(e)				1

#define Q_21_				Q(21)

#define Q_42_				Q(42)

#define Q_63_				Q(63)

#undef Q
#define Q(e)				((integral_q) (e))

#define q_21_				(Q_21_ << (integral_q_bits - 6))

#define q_42_				(Q_42_ << (integral_q_bits - 6))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int east(void *, unsigned size, unsigned, unsigned *,
		int (*) (void *, void *, unsigned));
static int edge(void *, unsigned size, unsigned, unsigned *,
		int (*) (void *, void *, unsigned));

static int
east(void *node, unsigned size, unsigned call, unsigned *fare,
     int (*move) (void *, void *, unsigned))
{
    integral_q news, slip;

    news = *(integral_q *) node;

    slip = news & ~Lx55555555;

    if (1) {
	if (call ^ (integral_q_bits - 1)) {
	    call++;

	    if (call & 1) {
		void *text;

		*(integral_q *) node = news & ~(Q(1) << call);

		*fare = call - 2;

		text = rule(node, size, call);
		move(life(text, size), text, 1);
	    } else {
		if (news & (Q(1) << (call - 1))) {
		    void **data;

		    *(integral_q *) node = news & ~(Q(1) << (call - 1));
		    call--;
		    data = ZD(node, size) + call;
		    *data = *(data - 1);

		    *fare = call;
		} else {
		    if (news & (Q(1) << (call + 1))) {
			*fare = call - 3;

			*(integral_q *) node = news & ~(Q(1) << (call + 1));
			if (true(call ^ 2)) {
			    void **data, *text;

			    text = rule(node, size, call);
			    move(lola(text, size), text, 1);
			    move(text, sans(text, size), 1);
			    data = ZD(node, size) + call;
			    *(data - 1) = *data;
			} else {
			    void **data, *text;

			    /* is this ever reached? */
			    text = rule(node, size, call);
			    move(text, sans(text, size), 1);
			    data = ZD(node, size) + call;
			    *(data - 1) = *data;
			}
		    } else {
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << call);
			if (back) {
			    l2_q_xfs(ever, back);
#if __HEAD_LEFT__
			    slip &= ((Q(1) << ever) - (Q(1) << call))
				>> (ever - call);
			    if (slip) {
				l2_q_xls(deck, slip);
				deck ^= integral_q_last;
				if (1) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck - 3) >> 1;
				    call--;
				    *fare = call;
				    text = HD(node, size, call - 1);
				    data = ZD(node, size) + call;
				    for (; ever; ever--) {
					void *trip;

					*data = *(data - 2);
					data -= 2;
					trip = lola(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data - 2);
					data -= 2;
					move(text, life(text, size), 1);
					*data = *(data - 1);
				    }
				}
			    } else {
				if (true(call ^ 2)) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call -= 2;
				    *fare = call - 1;
				    text = HD(node, size, call);
				    data = ZD(node, size) + call + 1;
				    for (; deck; deck--) {
					void *trip;

					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data + 2);
					data += 2;
				    }
				    {
					void *trip;

					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				} else {
				    void **data, *text;

				    /* is this ever reached? */
				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call - 2;
				    text = HD(node, size, call + 1);
				    data = ZD(node, size) + call;
				    for (; deck; deck--) {
					void *trip;

					*data = *(data + 2);
					data += 2;
					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				}
			    }
#else
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (deck ^ integral_q_bits) {
				deck ^= integral_q_last;
				if (call - deck < ever - call) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck - 3) >> 1;
				    call--;
				    *fare = call;
				    text = HD(node, size, call - 1);
				    data = ZD(node, size) + call;
				    for (; ever; ever--) {
					void *trip;

					*data = *(data - 2);
					data -= 2;
					trip = lola(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data - 2);
					data -= 2;
					move(text, life(text, size), 1);
					*data = *(data - 1);
				    }
				} else {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call -= 2;
				    *fare = call - 1;
				    text = HD(node, size, call);
				    data = ZD(node, size) + call + 1;
				    for (; deck; deck--) {
					void *trip;

					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data + 2);
					data += 2;
				    }
				    {
					void *trip;

					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				}
			    } else {
				if (true(call ^ 2)) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call -= 2;
				    *fare = call - 1;
				    text = HD(node, size, call);
				    data = ZD(node, size) + call + 1;
				    for (; deck; deck--) {
					void *trip;

					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data + 2);
					data += 2;
				    }
				    {
					void *trip;

					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				} else {
				    void **data, *text;

				    /* is this ever reached? */
				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call - 2;
				    text = HD(node, size, call) + 1;
				    data = ZD(node, size) + call;
				    for (; deck; deck--) {
					void *trip;

					*data = *(data + 2);
					data += 2;
					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				}
			    }
#endif				/* __HEAD_LEFT__ */
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck - 3) >> 1;
				    call--;
				    *fare = call;
				    text = HD(node, size, call - 1);
				    data = ZD(node, size) + call;
				    for (; ever; ever--) {
					void *trip;

					*data = *(data - 2);
					data -= 2;
					trip = lola(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data - 2);
					data -= 2;
					move(text, life(text, size), 1);
					*data = *(data - 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	} else {
	    unsigned deck, ever;

	    l2_q_xls(deck, slip);
	    if (1) {
		deck ^= integral_q_last;
		if (deck ^ (integral_q_bits - 1)) {
		    void **data, *text;

		    *(integral_q *) node = news & ~(Q(1) << deck);

		    data = ZD(node, size) + integral_q_last;
		    if (1) {
			*data = *(data - 2);
		    }

		    *fare = call;

		    call--;

		    ever = (integral_q_bits - 3 - deck) >> 1;
		    text = HD(node, size, call);
		    data = ZD(node, size) + call - 1;
		    for (; ever; ever--) {
			void *trip;

			trip = lola(text, size);
			move(text, trip, 1);
			text = trip;
			*data = *(data - 2);
			data -= 2;
		    }
		    {
			move(text, life(text, size), 1);
			*data = *(data - 1);
		    }
		} else {
		    void **data;

		    *(integral_q *) node = news & ~(Q(1) << deck);

		    *fare = call;

		    data = ZD(node, size) + integral_q_last;
		    if (1) {
			*data = *(data - 1);
		    }
		}
	    }
	}
    }

    return 0;
}


static int
edge(void *node, unsigned size, unsigned call, unsigned *fare,
     int (*move) (void *, void *, unsigned))
{
    integral_q news, slip;

    news = *(integral_q *) node;

    slip = news & ~Lx55555555;

    if (1) {
	if (1) {
	    call++;

	    if (call & 1) {
		*(integral_q *) node = news & ~(Q(1) << call);

		*fare = call;
	    } else {
		if (news & (Q(1) << (call + 1))) {
		    *fare = call - 1;

		    *(integral_q *) node = news & ~(Q(1) << (call + 1));
		    if (2) {
			void **data, *text;

			text = HD(node, size, call);
			move(text, sans(text, size), 1);
			data = ZD(node, size) + call;
			*(data - 1) = *data;
		    }
		} else {
		    if (news & (Q(1) << (call - 1))) {
			void **data, *text;

			*(integral_q *) node = news & ~(Q(1) << (call - 1));
			text = HD(node, size, call);
			move(text, life(text, size), 1);
			call--;
			data = ZD(node, size) + call;
			*data = *(data - 1);

			*fare = call + 2;
		    } else {
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << call);
			if (back) {
			    l2_q_xfs(ever, back);
#if __HEAD_LEFT__
			    slip &= ((Q(1) << ever) - (Q(1) << call))
				>> (ever - call);
			    if (slip) {
				l2_q_xls(deck, slip);
				deck ^= integral_q_last;
				if (1) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    *fare = call + 1;
				    text = HD(node, size, call);
				    data = ZD(node, size) + call - 1;
				    for (; ever; ever--) {
					void *trip;

					trip = lola(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data - 2);
					data -= 2;
				    }
				    {
					move(text, life(text, size), 1);
					*data = *(data - 1);
				    }
				}
			    } else {
				if (2) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call;
				    text = HD(node, size, call + 1);
				    data = ZD(node, size) + call;
				    for (; deck; deck--) {
					void *trip;

					*data = *(data + 2);
					data += 2;
					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				}
			    }
#else
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (deck ^ integral_q_bits) {
				deck ^= integral_q_last;
				if (call - deck < ever - call) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    *fare = call + 1;
				    text = HD(node, size, call);
				    data = ZD(node, size) + call - 1;
				    for (; ever; ever--) {
					void *trip;

					trip = lola(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data - 2);
					data -= 2;
				    }
				    {
					move(text, life(text, size), 1);
					*data = *(data - 1);
				    }
				} else {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call;
				    text = HD(node, size, call + 1);
				    data = ZD(node, size) + call;
				    for (; deck; deck--) {
					void *trip;

					*data = *(data + 2);
					data += 2;
					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				}
			    } else {
				if (2) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call;
				    text = HD(node, size, call + 1);
				    data = ZD(node, size) + call;
				    for (; deck; deck--) {
					void *trip;

					*data = *(data + 2);
					data += 2;
					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				}
			    }
#endif				/* __HEAD_LEFT__ */
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    *fare = call + 1;
				    text = HD(node, size, call);
				    data = ZD(node, size) + call - 1;
				    for (; ever; ever--) {
					void *trip;

					trip = lola(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data - 2);
					data -= 2;
				    }
				    {
					move(text, life(text, size), 1);
					*data = *(data - 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return 0;
}


int
_libx1f4l2_pack_bqfset(void *bqfset, void *date, void *data, void **path,
		       void **lead, integral_q pipe, void **lift,
		       unsigned *mile, void **lock, void **lane, void **turn,
		       void *text, void *near, void *aime)
{
    int half, (*move) (void *, void *, unsigned), status;
    unsigned call, fill = 0, size;
    void *away, *club, *file, *node, *tier;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    club = *lead;

    file = *lock;

    tier = *lane;

    node = *lift;

    call = *mile;

    if (1) {
	if (call ^ integral_q_last) {
	    if (pipe & ((Q(1) << call) - 1) << 1) {
	    } else {
		if (1) {
		    if (bqfset(bqfset)->link_f.fare
			(aime, rule(file, size, half_integral_q_bits)) < 0) {
			fill = 1;
		    } else {
		    }
		}
	    }
	} else {
	    if (bqfset(bqfset)->link_f.fare
		(aime, rule(file, size, half_integral_q_bits)) < 0) {
	    } else {
		fill = 2;
	    }
	}
    }

    if (1) {
	integral_q pipe;
	unsigned deck;
	void **data, *fast, *side, **text;

	pipe = *(integral_q *) club & ~Lx55555555;

	if (pipe) {
	    integral_q news, slip = Q(2) << 4;

	    news = pipe;

	    if (news & Q_42_) {
		*(integral_q *) club = Lxdddddddd | Q(2);

		if (news & 2) {
		    fast = rule(club, size, 4);

		    side = life(fast, size);

		    move(side, fast, 1);
		    dana(fast, size);
		    skip(side, size);
		} else {
		    fast = road(club, size);

		    if (news & 8) {
			side = life(fast, size);

			move(side, fast, 3);
			fast = rule(fast, size, 4);
			side = rule(side, size, 3);
		    } else {
			side = life(fast, size);

			move(side, fast, 1);
			dana(fast, size);
			skip(side, size);
			move(side, fast, 2);
			dana(fast, size);
			dana(side, size);
		    }
		}
	    } else {
		fast = rule(club, size, 4);

		side = life(fast, size);

		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    news |= Q(1) << (integral_q_bits - 2);
	    news >>= 6;

	    for (; !(news & Q_63_); news >>= 6) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		slip <<= 4;
	    }

	    if (news & ~((Q(1) << 6) - 1)) {
		*(integral_q *) club = Lxdddddddd | slip;

		if (news & 2) {
		    move(side, fast, 3);
		    fast = rule(fast, size, 4);
		    side = rule(side, size, 3);
		    move(side, fast, 1);
		    dana(fast, size);
		    skip(side, size);
		} else {
		    if (news & 8) {
			move(side, fast, 1);
			dana(fast, size);
			skip(side, size);
			move(side, fast, 3);
			fast = rule(fast, size, 4);
			side = rule(side, size, 3);
		    } else {
			move(side, fast, 1);
			dana(fast, size);
			skip(side, size);
			move(side, fast, 1);
			dana(fast, size);
			skip(side, size);
			move(side, fast, 2);
			dana(fast, size);
			dana(side, size);
		    }
		}

		news >>= 6;
	    }

	    for (; !(news & Q_21_); news >>= 6) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    if (news & Q_42_) {
		*(integral_q *) club =
		    Lxdddddddd | Q(2) << (integral_q_bits * 2 / 3 & ~3);

		if (half_integral_q_bits % 3 ^ 2) {
		    move(side, fast, 2);
		    dana(side, size);
		    move(side, *path, 1);

		    fast = file;

		    dana(fast, size);
		    skip(side, size);
		    move(side, fast, 1);
		    skip(side, size);
		} else {
		    move(side, fast, 1);
		    if (news & 2) {
			skip(fast, size);
			skip(side, size);
			move(side, fast, 2);
		    } else {
			dana(fast, size);
			skip(side, size);
			move(side, fast, 2);
		    }

		    dana(side, size);

		    move(side, *path, 1);

		    fast = file;

		    skip(side, size);
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    move(side, fast, 1);
		    dana(side, size);
		    move(side, *path, 1);

		    fast = file;

		    dana(fast, size);
		    skip(side, size);
		    move(side, fast, 1);
		    skip(side, size);
		} else {
		    move(side, fast, 1);
		    dana(fast, size);
		    dana(side, size);
		    move(side, fast, 1);
		    skip(side, size);
		    move(side, *path, 1);

		    fast = file;

		    skip(side, size);
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		dana(fast, size);
		move(side, fast, 1);
		dana(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
	    }

	    dana(fast, size);

	    away = fast;

	    if (fill) {
		half = fill - 1;
	    } else {
		half = bqfset(bqfset)->link_f.fare(aime, fast) < 0;
	    }

	    news = pipe;

	    data = ZD(club, size);

	    text = data;

	    data--;

	    news |= Q(1) << (integral_q_bits - 2);

	    for (; !(news & Q_42_); news >>= 6) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (news & ~((Q(1) << 6) - 1)) {
		if (news & 2) {
		    data++;
		    *text = *data;
		    text++;
		    data++;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		} else {
		    if (news & 8) {
			data += 2;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data += 2;
			*text = *data;
			text++;
		    } else {
			data += 2;
			*text = *data;
			text++;
			data += 2;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
		    }
		}

		news >>= 6;
	    }

	    for (; !(news & Q_21_); news >>= 6) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (news & Q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    data++;
		    *text = *data;
		    text++;
		    data++;
		    *text = *data;

		    data = ZD(file, size) + 1;

		    text++;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		} else {
		    if (news & 2) {
			data++;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data += 2;
			*text = *data;
		    } else {
			data += 2;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data++;
			*text = *data;
		    }

		    data = ZD(file, size) + 1;

		    text++;
		    *text = *data;
		    text++;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    text++;
		    data += 2;
		    *text = *data;

		    data = ZD(file, size) + 1;

		    text++;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		} else {
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;

		    data = ZD(file, size) + 1;

		    text++;
		    *text = *data;
		    text++;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }
	} else {
	    *(integral_q *) club = Lxdddddddd;

	    fast = rule(club, size, 4);

	    side = life(fast, size);

	    {
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    deck = integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		move(side, fast, 1);
		dana(side, size);
		move(side, *path, 1);

		fast = file;

		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		skip(side, size);
	    } else {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		skip(side, size);
		move(side, *path, 1);

		fast = file;

		skip(side, size);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		dana(fast, size);
		move(side, fast, 1);
		dana(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
	    }

	    dana(fast, size);

	    away = fast;

	    if (fill) {
		half = fill - 1;
	    } else {
		half = bqfset(bqfset)->link_f.fare(aime, fast) < 0;
	    }

	    data = ZD(club, size);

	    text = data;

	    data--;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    } else {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }
	}
    }

    tier = *lane;

    if (1) {
	integral_q pipe;
	unsigned deck;
	void **data, *fast, *side, **text;

	pipe = *(integral_q *) tier & ~Lx55555555;

	if (pipe) {
	    integral_q news, slip = Q(2) << (integral_q_bits - 4);

	    news = pipe;

	    data = ZD(tier, size) + integral_q_bits;

	    text = data;

	    data++;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (news & q_21_) {
	    } else {
		if (news & Q(1) << (integral_q_bits - 1)) {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    } else {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
			data++;
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (news & q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		} else {
		    text--;
		    data -= 2;
		    *text = *data;
		    if (news & Q(1) << (integral_q_bits - 1)) {
			text--;
			data--;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    } else {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    }

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    text--;
		    data -= 2;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		} else {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    news = pipe;

	    fast = rule(tier, size, integral_q_bits);

	    side = fast;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
		slip >>= 4;
	    }

	    if (news & q_21_) {
	    } else {
		*(integral_q *) tier = Lxdddddddd | slip;

		if (news & Q(1) << (integral_q_bits - 1)) {
		    beta(side, size);
		    beta(fast, size);
		    move(side, fast, 2);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			side = cell(side, size, 3);
			fast = cell(fast, size, 4);
			move(side, fast, 3);
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);
		    } else {
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);
			side = cell(side, size, 3);
			fast = cell(fast, size, 4);
			move(side, fast, 3);
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    if (news & q_42_) {
		*(integral_q *) tier =
		    Lxdddddddd | Q(2) << (integral_q_bits / 3 & ~3);

		if (half_integral_q_bits % 3 ^ 2) {
		    posh(side, size);
		    posh(fast, size);
		    move(side, fast, 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, *turn, 1);
		    posh(side, size);
		    move(side, fast, 1);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    posh(side, size);
		    if (news & Q(1) << (integral_q_bits - 1)) {
			beta(fast, size);
			posh(side, size);
			move(side, fast, 2);
		    } else {
			fast = cell(fast, size, 3);
			posh(side, size);
			move(side, fast, 2);
		    }

		    posh(side, size);
		    move(side, *turn, 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, fast, 1);
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, *turn, 1);
		    posh(side, size);
		    move(side, fast, 1);
		    beta(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		    posh(side, size);
		    move(side, *turn, 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    beta(side, size);
		    move(side, fast, 1);
		}
	    }

	    if (half) {
		move(*turn, away, 1);
	    } else {
		move(*path, away, 1);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }
	} else {
	    data = ZD(tier, size) + integral_q_bits;

	    text = data;

	    data++;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    } else {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    fast = rule(tier, size, integral_q_bits);

	    side = fast;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		fast = rule(file, size, integral_q_bits - 2);

		posh(side, size);
		move(side, *turn, 1);
		posh(side, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    } else {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		move(side, *turn, 1);

		fast = rule(file, size, integral_q_bits - 2);

		beta(side, size);
		move(side, fast, 1);
	    }

	    if (half) {
		move(*turn, away, 1);
	    } else {
		move(*path, away, 1);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
	    }

	    *(integral_q *) tier = Lxdddddddd;
	}
    }

    if (1) {
	if (half) {
	    east(node, size, call, mile, move);

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		if (fill) {
		    *lift = near;

		    *lock = tier;

		    *path = *turn;

		    if (*(integral_q *) near & Q(2)) {
			*mile = 0;

			*lane = ZD(near, size)[1];

			*turn = HD(near, size, 1);
		    } else {
			*mile = 1;

			*lane = ZD(near, size)
			    [*(integral_q *) near & Q(8) ? 2 : 3];

			*turn = HD(near, size, 2);
		    }
		} else {
		    call = *mile;

		    if (call & 1) {
			if (*(integral_q *) node & Q(1) << call) {
			    *lead = ZD(node, size)[call - 1];
			    *path = HD(node, size, call);
			} else {
			    if (call ^ 1) {
				*lead = ZD(node, size)[call - 2];
				*path = HD(node, size, call - 1);
			    } else {
				*path = data;
				if (date) {
				    *lead = ZD(date, size)[integral_q_last];
				} else {
				    *lead = NULL;
				}
			    }
			}
		    } else {
			if (call) {
			    *lead = ZD(node, size)[call - 1];
			    *path = HD(node, size, call);
			} else {
			    *path = data;
			    if (date) {
				*lead = ZD(date, size)[integral_q_last];
			    } else {
				*lead = NULL;
			    }
			}
		    }

		    *lock = club;

		    if (call ^ integral_q_last) {
			if (status ^ (LAST_ERROR + call + 2)) {
			    *turn = HD(node, size, call + 1);
			} else {
			    if (call ^ (integral_q_bits - 3)) {
				*turn = HD(node, size, call + 3);
			    } else {
				*turn = text;
			    }
			}
		    } else {
			*turn = text;
		    }
		}
	    }
	} else {
	    edge(node, size, call, mile, move);

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		if (fill) {
		    *lift = date;

		    *lock = club;

		    *turn = *path;

		    *mile = integral_q_last;

		    if (*(integral_q *) date & Q(1) << integral_q_last) {
			*lead = ZD(date, size)[integral_q_bits - 2];

			*path = HD(date, size, integral_q_last);
		    } else {
			*lead = ZD(date, size)[integral_q_bits - 3];

			*path = HD(date, size, integral_q_bits - 2);
		    }
		} else {
		    call = *mile;

		    if (call & 1) {
			if (*(integral_q *) node & Q(1) << call) {
			    *path = HD(node, size, call);
			} else {
			    if (call ^ 1) {
				if (1) {
				    *path = HD(node, size, call - 1);
				} else {
				}
			    } else {
				*path = data;
			    }
			}
		    } else {
			if (call) {
			    *path = HD(node, size, call);
			} else {
			    *path = data;
			}
		    }

		    *lock = tier;

		    if (call ^ integral_q_last) {
			*turn = HD(node, size, call + 1);
			*lane = ZD(node, size)[call + 1];
		    } else {
			*turn = text;
			if (near) {
			    if (*(integral_q *) near & 2) {
				*lane = ZD(near, size)[0];
			    } else {
				*lane = ZD(near, size)[1];
			    }
			} else {
			    *lane = NULL;
			}
		    }
		}
	    }
	}
    }

    return status;
}
