/*
 * bqfx.q.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bcount.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define __HALF_TRANSFER__		1

#define __UNROLL_TRANSFER__		0

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define transfer			((integral_q_bits - 2 - 2) >> 1)

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_nine_bqfset(void *bqfset, integral_q last, void **lead,
		       integral_q pipe, void **lift, unsigned *mile,
		       void **land, void **lock, void **lane, integral_q next,
		       unsigned *rate)
{
    int (*move) (void *, void *, unsigned);
    unsigned call, copy, deck, ever, size;
    void *club, *file, *head, *node, *tier;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    club = *lead;

    file = *lock;

    tier = *lane;

    node = *lift;

    call = *mile;

    copy = *rate;

    head = *land;

    if (copy) {
	void *fast, *side;

	*(integral_q *) file = Lx55555555;

	fast = rule(file, size, copy);

	deck = (copy - 2) >> 1;

#if __UNROLL_TRANSFER__
# error
#else
	ever = deck >> 1;
	for (; ever; ever--) {
	    side = lola(fast, size);
	    move(fast, side, 1);
	    fast = lola(side, size);
	    move(side, fast, 1);
	}
	if (deck & 1) {
	    side = lola(fast, size);
	    move(fast, side, 1);
	    fast = side;
	}
#endif				/* __UNROLL_TRANSFER__ */
	{
	    move(fast, head, 1);
	}
    } else {
    }
    if (1) {
	{
	    move(head, rule(club, size, integral_q_bits - 2), 1);
	}

	*(integral_q *) club = Lx55555555 ^ Q(1) << (integral_q_bits - 2);
    }

    tier = file;

    file = club;

    if (1) {
	if (pipe & Q(1) << integral_q_last) {
	    call = integral_q_bits - 2;
	    club = ZD(node, size)[integral_q_bits - 3];
	    head = HD(node, size, integral_q_bits - 2);
	} else {
	    call = integral_q_bits - 3;
	    if (pipe & Q(1) << (integral_q_bits - 3)) {
		club = ZD(node, size)[integral_q_bits - 4];
		head = HD(node, size, integral_q_bits - 3);
	    } else {
		club = ZD(node, size)[integral_q_bits - 5];
		head = HD(node, size, integral_q_bits - 4);
	    }
	}
    }

    last = *(integral_q *) club & ~Lx55555555;
    if (last) {
#if __HALF_TRANSFER__
	if (1) {
	    integral_q text;
	    unsigned slip;
	    void *fast, *side;

	    fast = rule(file, size, integral_q_bits - 2);

	    l2_q_bitcount(deck, last);

	    deck *= 2730;
	    deck >>= 12;
	    if (deck) {
	    } else {
		deck = 1;
	    }

	    if (deck < 4) {
# if __UNROLL_TRANSFER__
#  error
# else
		slip = transfer >> 1;
		for (; slip; slip--) {
		    side = lola(fast, size);
		    move(fast, side, 1);
		    fast = lola(side, size);
		    move(side, fast, 1);
		}
		if (transfer & 1) {
		    move(fast, lola(fast, size), 1);
		}
# endif				/* __UNROLL_TRANSFER__ */
	    } else {
		unsigned fold;

		fold = deck - 3;

# if __UNROLL_TRANSFER__
#  error
# else
		ever = transfer - fold;
		slip = ever >> 1;
		for (; slip; slip--) {
		    side = lola(fast, size);
		    move(fast, side, 1);
		    fast = lola(side, size);
		    move(side, fast, 1);
		}
		if (ever & 1) {
		    side = lola(fast, size);
		    move(fast, side, 1);
		} else {
		    side = fast;
		    dana(fast, size);
		}
# endif				/* __UNROLL_TRANSFER__ */
		for (; fold; fold--) {
		    beta(side, size);
		    posh(fast, size);
		    move(fast, side, 1);
		}
	    }

	    fast = file;

	    if (deck == 1) {
		*(integral_q *) file = Lx55555555;

		fast = road(file, size);
	    } else {
		*(integral_q *) file = Lx55555555
		    | ((Q(1) << ((deck << 1) - 2)) - 1);

		fast = rule(file, size, deck);
	    }

	    move(fast, head, 1);

	    posh(fast, size);

	    deck--;

	    text = *(integral_q *) club;

	    side = rule(club, size, integral_q_bits);

	    while (deck & ~1) {
		if (text & Q(1) << integral_q_last) {
		    posh(side, size);
		    move(fast, side, 1);
		    posh(fast, size);
		    posh(side, size);
		    move(fast, side, 1);
		    posh(fast, size);

		    deck -= 2;
		} else {
		    deck--;

		    beta(side, size);
		    move(fast, side, 1);
		    posh(fast, size);
		}

		text <<= 2;
	    }
	    if (deck) {
		if (text & Q(1) << integral_q_last) {
		    posh(side, size);
		    move(fast, side, 1);
		    posh(side, size);
		    move(head, side, 1);

		    deck = 0;
		} else {
		    beta(side, size);
		    move(fast, side, 1);
		}

		text <<= 2;
	    } else {
		deck = 1;
	    }
	    slip = integral_q_bits - 2;
	    if (deck) {
		if (text & Q(1) << integral_q_last) {
		    posh(side, size);
		    move(head, side, 1);

		    posh(side, size);

		    fast = rule(club, size, integral_q_bits - 2);

		    text <<= 1;
		} else {
		    beta(side, size);
		    move(head, side, 1);

		    posh(side, size);

		    fast = rule(club, size, integral_q_bits - 2);

		    text <<= 2;

		    if (side < fast) {
			if (text & Q(1) << integral_q_last) {
			    move(fast, side, 1);
			    beta(fast, size);
			    slip -= 2;
			}

			posh(side, size);

			text <<= 1;
		    }
		}
	    } else {
		posh(side, size);

		fast = rule(club, size, integral_q_bits - 2);

		if (side < fast) {
		    if (text & Q(1) << integral_q_last) {
			move(fast, side, 1);
			beta(fast, size);
			slip -= 2;
		    }

		    posh(side, size);

		    text <<= 1;
		}
	    }
	    while (side < fast) {
		if (text & Q(1) << (integral_q_bits - 2)) {
		    move(fast, side, 1);
		    beta(fast, size);
		    posh(side, size);
		    move(fast, side, 1);
		    beta(fast, size);
		    posh(side, size);
		    slip -= 4;
		} else {
		    move(fast, side, 1);
		    beta(fast, size);
		    beta(side, size);
		    slip -= 2;
		}

		text <<= 2;
	    }

	    *(integral_q *) club =
		Lx55555555 | text >> (integral_q_last - slip);
	}
#else
# error
#endif				/* __HALF_TRANSFER__ */
    } else {
	*rate = integral_q_bits - 2;

	*mile = call;

	*lane = tier;

	*lock = file;

	*land = head;

	*lead = club;
    }

    return 0;
}
