/*
 * bqfx.o.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_root_bqfset(void *bqfset, void *node, unsigned rate)
{
    int (*move) (void *, void *, unsigned), status;
    integral_q news, pipe;
    unsigned i, size;
    void *call, *data, *file, *text;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    call = MD(node, size)[0];

    file = MD(node, size)[1];

    text = node;

    *(integral_q *) node = integral_q_bits;

    skip(text, size);

    data = call;

    pipe = *(integral_q *) data & ~Lx55555555;

    if (pipe) {
	void *trip;

	{
	    move(rule(text, size, half_integral_q_bits), sans(node, size), 1);
	}

	news = pipe;

	news >>= 2;

	for (; news; news >>= 2) {
	    dana(data, size);
	    move(text, data, 1);
	    skip(text, size);
	}

	{
	    move(text, sans(data, size), 1);
	    skip(text, size);
	}

	trip = rule(call, size, integral_q_bits - 2);
	while (data != trip) {
	    dana(data, size);
	    move(text, data, 1);
	    skip(text, size);
	}

	{
	    skip(text, size);
	}

	data = road(file, size);

	i = half_integral_q_bits - 1;
	for (; i; i--) {
	    move(text, data, 1);
	    skip(text, size);
	    dana(data, size);
	}

	text =
	    rule(text, size, integral_q_bits_and_half - integral_q_bits - 1);

	data = (integral_q *) (void *) rule(call, size, integral_q_bits) + 1;

	trip = (integral_q *) data + integral_q_bits;

	news = pipe;

	news >>= 2;

	for (; news; news >>= 2) {
	    *(integral_q *) text = *(integral_q *) data;
	    skip(text, SIZEOF_integral_q);
	    dana(data, SIZEOF_integral_q);
	}

	{
	    *(integral_q *) text = *((integral_q *) data - 1);
	    skip(text, SIZEOF_integral_q);
	}

	do {
	    *(integral_q *) text = *(integral_q *) data;
	    skip(text, SIZEOF_integral_q);
	    dana(data, SIZEOF_integral_q);
	} while (data != trip);

	data = (integral_q *) (void *) rule(file, size, integral_q_bits) + 1;

	i = half_integral_q_bits;
	for (; i; i--) {
	    *(integral_q *) text = *(integral_q *) data;
	    skip(text, SIZEOF_integral_q);
	    dana(data, SIZEOF_integral_q);
	}
    } else {
	void *trip;

	{
	    move(rule(text, size, half_integral_q_bits - 1), sans(node, size),
		 1);
	}

	dana(data, size);

	i = half_integral_q_bits - 1;
	for (; i; i--) {
	    move(text, data, 1);
	    skip(text, size);
	    dana(data, size);
	}

	{
	    skip(text, size);
	}

	data = file;

	pipe = *(integral_q *) data & ~Lx55555555;

	news = pipe;

	news >>= 2;

	for (; news; news >>= 2) {
	    dana(data, size);
	    move(text, data, 1);
	    skip(text, size);
	}

	{
	    move(text, sans(data, size), 1);
	    skip(text, size);
	}

	trip = rule(file, size, integral_q_bits - 2);
	while (data != trip) {
	    dana(data, size);
	    move(text, data, 1);
	    skip(text, size);
	}

	text =
	    rule(text, size, integral_q_bits_and_half - integral_q_bits - 1);

	data = (integral_q *) (void *) rule(call, size, integral_q_bits) + 1;

	i = half_integral_q_bits;
	for (; i; i--) {
	    *(integral_q *) text = *(integral_q *) data;
	    skip(text, SIZEOF_integral_q);
	    dana(data, SIZEOF_integral_q);
	}

	data = (integral_q *) (void *) rule(file, size, integral_q_bits) + 1;

	trip = (integral_q *) data + integral_q_bits;

	news = pipe;

	news >>= 2;

	for (; news; news >>= 2) {
	    *(integral_q *) text = *(integral_q *) data;
	    skip(text, SIZEOF_integral_q);
	    dana(data, SIZEOF_integral_q);
	}

	{
	    *(integral_q *) text = *((integral_q *) data - 1);
	    skip(text, SIZEOF_integral_q);
	}

	do {
	    *(integral_q *) text = *(integral_q *) data;
	    skip(text, SIZEOF_integral_q);
	    dana(data, SIZEOF_integral_q);
	} while (data != trip);
    }

    if (2) {
	if (1) {
	    int excess;

	    bqfset(bqfset)->link_a.fpnews.link_v.rate = rate;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;
	    }

	    excess = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, call);
	    if (excess) {
		status = FREE_ERROR;
	    }

	    if (status) {
		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		status = LAST_ERROR + 2;
	    }
	}
    }

    return status;
}
