/*
 * bqfx.k.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define __SIDE_FILL__			1

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_join_bqfset(void *bqfset, unsigned mind, void *node, void **lead,
		       void **path, unsigned *pace, void *file, void **turn,
		       void **lane, unsigned rate, void *aime)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned size;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    if (mind ^ 1) {
#if __SIDE_FILL__
	int half;
#endif				/* __SIDE_FILL__ */
	unsigned deck, pick;
	void *club, *fast, *side, *tier;

	pick = *pace;

	club = *lead;

	if (mind ^ pick) {
	    tier = *lane;

#if __SIDE_FILL__
	    if (pick) {
	    } else {
		fast = MD(node, size)[pick + 2];

		if (*(integral_q *) fast ^ Lx55555555) {
		} else {
		    club = file;
		    file = tier;

		    pick++;

		    tier = fast;
		}
	    }
#endif				/* __SIDE_FILL__ */
	} else {
	    tier = file;
	    file = club;

	    pick--;

#if __SIDE_FILL__
	    club = MD(node, size)[pick - 1];
	    if (*(integral_q *) club ^ Lx55555555) {
		club = NULL;
	    }
#endif				/* __SIDE_FILL__ */
	}

#if __SIDE_FILL__
	if (!club) {
#elif 0
	}
#else
	{
#endif				/* __SIDE_FILL__ */
	    void **data, **text;

	    fast = tier;

	    side = fast;

	    *(integral_q *) tier = ~Q(0);

	    fast = rule(fast, size, integral_q_bits - 2);

	    side = sans(fast, size);

	    deck = half_integral_q_bits - 1;
	    for (; deck; deck--) {
		move(side, fast, 1);
		beta(fast, size);
		posh(side, size);
	    }

	    if (0) {
	    } else{
		move(side, rule(node, size, pick + 1), 1);
	    }

	    posh(side, size);

	    fast = file;

	    fast = rule(fast, size, integral_q_bits - 2);

	    deck = half_integral_q_bits - 1;
	    for (; deck; deck--) {
		move(side, fast, 1);
		beta(fast, size);
		posh(side, size);
	    }

	    text = ZD(tier, size) + integral_q_bits - 2;

	    data = text - 1;

	    deck = half_integral_q_bits - 1;
	    for (; deck; deck--) {
		*text = *data;
		data -= 2;
		text--;
	    }

	    data = ZD(file, size) + integral_q_bits - 1;

	    deck = half_integral_q_bits;
	    for (; deck; deck--) {
		*text = *data;
		data -= 2;
		text--;
	    }

#if __SIDE_FILL__
	    half = 0;
	} else {
	    void **data, **text;

	    *(integral_q *) club = Lxdddddddd;

	    fast = rule(club, size, 4);

	    side = life(fast, size);

	    {
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    deck = integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		move(side, fast, 1);
		dana(side, size);
		move(side, rule(node, size, pick), 1);

		fast = file;

		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		skip(side, size);
	    } else {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		skip(side, size);
		move(side, rule(node, size, pick), 1);

		fast = file;

		skip(side, size);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		dana(fast, size);
		move(side, fast, 1);
		dana(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
	    }

	    dana(fast, size);

	    move(rule(node, size, pick), fast, 1);

	    half = 1;

	    data = ZD(club, size);

	    text = data;

	    data--;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    } else {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    data = ZD(tier, size) + integral_q_bits;

	    text = data;

	    data++;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    } else {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    fast = rule(tier, size, integral_q_bits);

	    side = fast;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		fast = rule(file, size, integral_q_bits - 2);

		posh(side, size);
		move(side, rule(node, size, pick + 1), 1);
		posh(side, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    } else {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		move(side, rule(node, size, pick + 1), 1);

		fast = rule(file, size, integral_q_bits - 2);

		beta(side, size);
		move(side, fast, 1);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
	    }

	    *(integral_q *) tier = Lxdddddddd;
#endif				/* __SIDE_FILL__ */
	}

	if (1) {
	    void **trap;

	    trap = MD(node, size) + pick;

	    memmove(trap, trap + 1, (mind - pick) * sizeof(void *));

	    side = rule(node, size, pick + 1);

	    move(side, sans(side, size), mind - pick);

	    mind--;

	    *(integral_q *) node = mind;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
#if __SIDE_FILL__
		if (half) {
		    if (bqfset(bqfset)->link_f.fare
			(aime, rule(node, size, pick)) < 0) {
			pick--;
		    }
		}
#endif				/* __SIDE_FILL__ */

		*pace = pick;

		if (pick) {
		    *path = rule(node, size, pick);
		    *lead = MD(node, size)[pick - 1];
		} else {
		    *path = NULL;
		    *lead = NULL;
		}
		if (pick ^ mind) {
		    *lane = MD(node, size)[pick + 1];
		    *turn = rule(node, size, pick + 1);
		} else {
		    *lane = NULL;
		    *turn = NULL;
		}
	    }
	}
    } else {
	unsigned i;
	void *call, *data, *text;

	call = MD(node, size)[0];

	file = MD(node, size)[1];

	text = node;

	*(integral_q *) node = integral_q_bits - 1;

	skip(text, size);

	{
	    move(rule(text, size, half_integral_q_bits - 1),
		 sans(node, size), 1);
	}

	data = road(call, size);

	i = half_integral_q_bits - 1;
	for (; i; i--) {
	    move(text, data, 1);
	    skip(text, size);
	    dana(data, size);
	}

	{
	    skip(text, size);
	}

	data = road(file, size);

	i = half_integral_q_bits - 1;
	for (; i; i--) {
	    move(text, data, 1);
	    skip(text, size);
	    dana(data, size);
	}

	text = rule(node, size, integral_q_bits_and_half);

	data = (integral_q *) (void *) rule(call, size, integral_q_bits) + 1;

	i = half_integral_q_bits;
	for (; i; i--) {
	    *(integral_q *) text = *(integral_q *) data;
	    skip(text, SIZEOF_integral_q);
	    dana(data, SIZEOF_integral_q);
	}

	data = (integral_q *) (void *) rule(file, size, integral_q_bits) + 1;

	i = half_integral_q_bits;
	for (; i; i--) {
	    *(integral_q *) text = *(integral_q *) data;
	    skip(text, SIZEOF_integral_q);
	    dana(data, SIZEOF_integral_q);
	}

	if (1) {
	    int excess;

	    bqfset(bqfset)->link_a.fpnews.link_v.rate = rate;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;
	    }

	    excess = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, call);
	    if (excess) {
		status = FREE_ERROR;
	    }

	    if (status) {
		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		status = LAST_ERROR + 2;
	    }
	}
    }

    return status;
}
