/*
 * bqfx.i.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <xfs.h>
#include <xls.h>

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_hale_bqfset(void *bqfset, void *node, unsigned copy,
		       void **fare, void *aime, void **edit)
{
    int status;

    do {
	unsigned i, rate, side, size;
	void *down, *sect, *slip;

	size = bqfset(bqfset)->link_a.fpnews.link_v.size;

	rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

	down = *fare;

	if (rate ^ 1) {
	    side = 1013;
	    slip = (char *) down + half_integral_q_bits * size;
	} else {
	    status = bqfset(bqfset)->link_f.pick(aime, down, &side);
	    if (status) {
		status = EVER_MATCH;
		if (1) {
		    break;
		}
	    } else {
		if (side ^ (half_integral_q_bits - 1)) {
		    if (side < half_integral_q_bits - 1) {
			slip = rule(down, size, half_integral_q_bits - 1);
		    } else {
			slip = rule(down, size, half_integral_q_bits - 0);
		    }
		} else {
		    slip = (void *) 0;
		}
	    }
	}

	status = bqfset(bqfset)->link_m.link
	    (bqfset(bqfset)->link_m.data, &sect,
	     integral_q_bits * (rate ^ 1 ? SIZEOF_integral_q + size : size));
	if (status) {
	    status = LINK_ERROR;
	    if (1) {
		break;
	    }
	} else {
	    int (*move) (void *, void *, unsigned);

	    move = bqfset(bqfset)->link_f.move;

	    if (1) {
		unsigned flow, mine;
		void *fast, **side;

		mine = *(integral_q *) node;

		mine++;

		*(integral_q *) node = mine;

		flow = mine - copy - 1;

		fast = rule(node, size, copy + 1);
		status = move(sans(fast, size), fast, flow);
		if (status) {
		    status = MOVE_ERROR;
		    if (1) {
			break;
		    }
		}
		side = MD(node, size) + mine;
		for (; flow; flow--) {
		    *side = *(side - 1);
		    side--;
		}
		{
		    *side = sect;
		}

		if (slip) {
		    move(fast, slip, 1);
		} else {
		    *edit = fast;
		}
	    }

	    if (rate ^ 1) {
		*((integral_q *) sect) = Lx55555555;

		*((integral_q *) down) = Lx55555555;

		for (i = 0; i < half_integral_q_bits - 1; i++) {
		    move((char *) sect + (2 + (i << 1)) * size,
			 (char *) down + (1 + half_integral_q_bits + i) * size,
			 1);
		    ZD(sect, size)[1 + (i << 1)] =
			ZD(down, size)[half_integral_q_bits - 1 + 1 + i];
		}

		ZD(sect, size)[integral_q_last] =
		    ZD(down, size)[integral_q_last];

		ZD(down, size)[integral_q_last] =
		    ZD(down, size)[half_integral_q_bits - 1];

		for (i = half_integral_q_bits - 2; ~i; i--) {
		    move((char *) down + (2 + (i << 1)) * size,
			 (char *) down + (i + 1) * size, 1);
		    ZD(down, size)[1 + (i << 1)] = ZD(down, size)[i];
		}

		if (1) {
		    int select;

		    select = bqfset(bqfset)->link_f.fare
			(aime, rule(node, size, copy + 1));
		    if (select < 0) {
		    } else {
			if (select) {
			    *fare = sect;
			} else {
			    status = EVER_MATCH;
			}
		    }
		}
	    } else {
		void *data, *text;

		*((integral_q *) sect) = Lx55555555 | 2;

		*((integral_q *) down) = Lx55555555;

		data = (char *) down + (integral_q_last) * size;

		text = (char *) sect + (integral_q_bits - 2) * size;

		if (side < half_integral_q_bits - 1) {
		    i = half_integral_q_bits - 1;
		    for (; i; i--) {
			move(text, data, 1);
			data = (char *) data - size;
			text = (char *) text - (size << 1);
		    }

		    move((char *) text + size, data, 1);

		    data = (char *) data - (size << 1);

		    text = (char *) down + (integral_q_bits - 2) * size;

		    i = half_integral_q_bits - 2 - side;
		    for (; i; i--) {
			move(text, data, 1);
			data = (char *) data - size;
			text = (char *) text - (size << 1);
		    }

		    *edit = text;

		    text = (char *) text - (size << 1);

		    i = side;
		    for (; i; i--) {
			move(text, data, 1);
			data = (char *) data - size;
			text = (char *) text - (size << 1);
		    }
		} else {
		    if (side ^ (half_integral_q_bits - 1)) {
			i = integral_q_last - side;
			for (; i; i--) {
			    move(text, data, 1);
			    data = (char *) data - size;
			    text = (char *) text - (size << 1);
			}

			if (side ^ half_integral_q_bits) {
			    *edit = text;

			    text = (char *) text - (size << 1);

			    i = side - half_integral_q_bits - 1;
			    for (; i; i--) {
				move(text, data, 1);
				data = (char *) data - size;
				text = (char *) text - (size << 1);
			    }

			    move((char *) text + size, data, 1);

			    data = (char *) data - size;
			} else {
			    *edit = (char *) text + size;
			}
		    } else {
			i = half_integral_q_bits - 1;
			for (; i; i--) {
			    move(text, data, 1);
			    data = (char *) data - size;
			    text = (char *) text - (size << 1);
			}

			move((char *) text + size, data, 1);
		    }

		    data = (char *) data - size;

		    text = (char *) down + (integral_q_bits - 2) * size;

		    i = half_integral_q_bits - 1;
		    for (; i; i--) {
			move(text, data, 1);
			data = (char *) data - size;
			text = (char *) text - (size << 1);
		    }
		}
	    }
	}
    } while (0);

    return status;
}
