/*
 * bqfx.g.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_long_bqfset(void *bqfset, void *aime, void **edit)
{
    int status;

    do {
	unsigned i, rate, side, size;
	void *node, *root, *sect, *slip;

	size = bqfset(bqfset)->link_a.fpnews.link_v.size;

	rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

	root = bqfset(bqfset)->link_a.fpnews.node;

	if (rate) {
	    side = 1013;
	} else {
	    status = bqfset(bqfset)->link_f.look(aime, root, &side);
	    if (status) {
		status = EVER_MATCH;
		if (1) {
		    break;
		}
	    } else {
		if (side ^ ((integral_q_bits_and_half >> 1) - 1)) {
		    if (side < (integral_q_bits_and_half >> 1) - 1) {
			slip =
			    rule(root, size,
				 (integral_q_bits_and_half >> 1) - 1);
		    } else {
			slip = rule(root, size, integral_q_bits_and_half >> 1);
		    }
		} else {
		    slip = (void *) 0;
		}
	    }
	}

	if (rate) {
	    status = bqfset(bqfset)->link_m.link
		(bqfset(bqfset)->link_m.data, &node,
		 integral_q_bits * (SIZEOF_integral_q + size));
	    if (status) {
		status = LINK_ERROR;
	    } else {
		status = bqfset(bqfset)->link_m.link
		    (bqfset(bqfset)->link_m.data, &sect,
		     integral_q_bits * (SIZEOF_integral_q + size));
		if (status) {
		    status = LINK_ERROR;

		    bqfset(bqfset)->link_m.free
			(bqfset(bqfset)->link_m.data, node);
		} else {
		    int (*move) (void *, void *, unsigned);
		    void **dash, *data, **near, *text;

		    move = bqfset(bqfset)->link_f.move;

		    *((integral_q *) sect) = Lxdddddddd;

		    *((integral_q *) node) = Lxdddddddd;

		    dash = MD(root, size) + 0;

		    data = (char *) root + size;

		    near = ZD(node, size) + 1;

		    text = (char *) node + (size << 1);

		    {
			move(text, data, 2);
			data = (char *) data + size;
			text = (char *) text + size;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
		    }
		    i = (integral_q_bits >> 2) - 1;
		    for (; i; i--) {
			data = (char *) data + size;
			text = (char *) text + size;
			move(text, data, 1);
			data = (char *) data + size;
			text = (char *) text + (size << 1);
			move(text, data, 2);
			data = (char *) data + size;
			text = (char *) text + size;
			dash++;
			near += 2;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
		    }

		    dash++;

		    data = (char *) data + (size << 1);

		    near = ZD(sect, size) + 1;

		    text = (char *) sect + (size << 1);

		    {
			move(text, data, 2);
			data = (char *) data + size;
			text = (char *) text + size;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
		    }
		    i = (integral_q_bits >> 2) - 1;
		    for (; i; i--) {
			data = (char *) data + size;
			text = (char *) text + size;
			move(text, data, 1);
			data = (char *) data + size;
			text = (char *) text + (size << 1);
			move(text, data, 2);
			data = (char *) data + size;
			text = (char *) text + size;
			dash++;
			near += 2;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
			dash++;
			near++;
			*near = *dash;
		    }

		    *((integral_q *) root) = 1;

		    move(sans(root, size),
			 rule(root, size, integral_q_bits_and_half >> 1), 1);

		    MD(root, size)[0] = node;
		    MD(root, size)[1] = sect;

		    bqfset(bqfset)->link_a.fpnews.link_v.rate++;
		}
	    }
	} else {
	    status = bqfset(bqfset)->link_m.link
		(bqfset(bqfset)->link_m.data, &node,
		 (integral_q_bits << 0) * size);
	    if (status) {
		status = LINK_ERROR;
	    } else {
		status = bqfset(bqfset)->link_m.link
		    (bqfset(bqfset)->link_m.data, &sect,
		     (integral_q_bits << 0) * size);
		if (status) {
		    status = LINK_ERROR;

		    bqfset(bqfset)->link_m.free
			(bqfset(bqfset)->link_m.data, node);
		} else {
		    int (*move) (void *, void *, unsigned);
		    void *data, *text;

		    move = bqfset(bqfset)->link_f.move;

		    *((integral_q *) sect) = Lxdddddddd | 2;

		    *((integral_q *) node) = Lxdddddddd;

		    if (side < (integral_q_bits_and_half >> 1)) {
			data = rule(root, size, integral_q_bits_and_half - 1);

			text = (char *) sect + (integral_q_bits - 1) * size;

			i = (integral_q_bits >> 2) - 1;
			for (; i; i--) {
			    posh(text, size);
			    posh(data, size);
			    move(text, data, 2);
			    beta(text, size);
			    posh(data, size);
			    move(text, data, 1);
			    posh(text, size);
			    posh(data, size);
			}
			{
			    beta(text, size);
			    beta(data, size);
			    move(text, data, 3);
			    posh(data, size);
			}

			if (side ^ ((integral_q_bits_and_half >> 1) - 1)) {
			    posh(data, size);

			    text = rule(node, size, integral_q_bits - 1);

			    i = ((integral_q_bits_and_half >> 1) - 2 - side)
				/ 3;
			    for (; i; i--) {
				posh(text, size);
				posh(data, size);
				move(text, data, 2);
				beta(text, size);
				posh(data, size);
				move(text, data, 1);
				posh(text, size);
				posh(data, size);
			    }
			    if (1 < side) {
				i = side % 3;
				if (i) {
				    if (i ^ 1) {
					posh(text, size);
					posh(data, size);
					move(text, data, 2);
					beta(text, size);
					*edit = text;
					posh(text, size);
					posh(data, size);
				    } else {
					*edit = text;
					posh(text, size);
					move(text, data, 1);
					beta(text, size);
					posh(data, size);
					move(text, data, 1);
					posh(text, size);
					posh(data, size);
				    }
				} else {
				    move(text, data, 1);
				    posh(text, size);
				    *edit = text;
				    beta(text, size);
				    posh(data, size);
				    move(text, data, 1);
				    posh(text, size);
				    posh(data, size);
				}
				i = (side - 2) / 3;
				for (; i; i--) {
				    posh(text, size);
				    posh(data, size);
				    move(text, data, 2);
				    beta(text, size);
				    posh(data, size);
				    move(text, data, 1);
				    posh(text, size);
				    posh(data, size);
				}
				{
				    posh(text, size);
				    posh(data, size);
				    move(text, data, 2);
				}
			    } else {
				if (side) {
				    *edit = text;
				    posh(text, size);
				    move(text, data, 1);
				} else {
				    move(text, data, 1);
				    posh(text, size);
				    *edit = text;
				}
			    }
			} else {
			    text = rule(node, size, integral_q_bits - 1);

			    i = (integral_q_bits >> 2) - 1;
			    for (; i; i--) {
				posh(text, size);
				posh(data, size);
				move(text, data, 2);
				beta(text, size);
				posh(data, size);
				move(text, data, 1);
				posh(text, size);
				posh(data, size);
			    }
			    {
				move(text, data, 1);
				posh(text, size);
				posh(data, size);
				move(text, data, 1);
			    }
			}
		    } else {
			side -= (integral_q_bits_and_half >> 1);

			data = (char *) root + size;

			text = (char *) node + (size << 1);

			{
			    move(text, data, 2);
			    skip(data, size);
			    skip(text, size);
			}
			i = (integral_q_bits >> 2) - 1;
			for (; i; i--) {
			    skip(data, size);
			    skip(text, size);
			    move(text, data, 1);
			    skip(data, size);
			    dana(text, size);
			    move(text, data, 2);
			    skip(data, size);
			    skip(text, size);
			}

			text = (char *) sect + size;

			dana(data, size);

			if (side < 3) {
			    if (side) {
				if (side ^ 1) {
				    move(text, data, 2);
				    skip(data, size);
				    dana(text, size);
				    *edit = text;
				} else {
				    move(text, data, 1);
				    skip(text, size);
				    *edit = text;
				    skip(data, size);
				    skip(text, size);
				    move(text, data, 1);
				}
			    } else {
				*edit = text;
				skip(text, size);
				move(text, data, 2);
				skip(data, size);
				skip(text, size);
			    }
			} else {
			    {
				move(text, data, 3);
				dana(data, size);
				dana(text, size);
			    }
			    i = side / 3 - 1;
			    for (; i; i--) {
				skip(data, size);
				skip(text, size);
				move(text, data, 1);
				skip(data, size);
				dana(text, size);
				move(text, data, 2);
				skip(data, size);
				skip(text, size);
			    }
			    i = side % 3;
			    if (i) {
				if (i ^ 1) {
				    skip(data, size);
				    skip(text, size);
				    move(text, data, 1);
				    skip(data, size);
				    dana(text, size);
				    move(text, data, 1);
				    skip(text, size);
				    *edit = text;
				} else {
				    skip(data, size);
				    skip(text, size);
				    move(text, data, 1);
				    dana(text, size);
				    *edit = text;
				    skip(data, size);
				    skip(text, size);
				    move(text, data, 1);
				}
			    } else {
				skip(text, size);
				*edit = text;
				skip(data, size);
				dana(text, size);
				move(text, data, 2);
				skip(data, size);
				skip(text, size);
			    }
			}
			i = ((integral_q_bits_and_half >> 1) - 1 - side) / 3;
			for (; i; i--) {
			    skip(data, size);
			    skip(text, size);
			    move(text, data, 1);
			    skip(data, size);
			    dana(text, size);
			    move(text, data, 2);
			    skip(data, size);
			    skip(text, size);
			}
		    }

		    MD(root, size)[0] = node;
		    MD(root, size)[1] = sect;

		    if (slip) {
			move((char *) root + size, slip, 1);
		    } else {
			*edit = (char *) root + size;
		    }

		    *((integral_q *) root) = 1;

		    bqfset(bqfset)->link_a.fpnews.link_v.rate++;
		}
	    }
	}
    } while (0);

    return status;
}
