/*
 * bqfx.8.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
x1f4_lead_bqfset(void *bqfset, void **lead)
{
    int status = 0;
    unsigned rate, size;
    void *node;

    node = bqfset(bqfset)->link_a.fpnews.node;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    if (rate) {
	integral_q news;

	node = MD(node, size)[0];
	rate--;
	while (rate) {
	    rate--;
	    news = *(integral_q *) node;
	    node = *(ZD(node, size) + (~news >> 1 & 1));
	}
	{
	    news = *(integral_q *) node;
	    *lead = (char *) node + size * (2 - (news >> 1 & 1));
	}
    } else {
	if (*(integral_q *) node) {
	    *lead = (char *) node + size;
	} else {
	    status = DECK_ERROR;
	}
    }

    return status;
}
