/*
 * bqfx.5.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-types.h>

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int line(void *, unsigned, void *, int (*) (void *, void *));
static int slip(void *, unsigned, unsigned, void *, int (*) (void *, void *));

static int
line(void *node, unsigned size, void *back, int (*call) (void *, void *))
{
    int delete;
    unsigned note;

    note = *(integral_q *) node;
    if (note) {
	do {
	    node = (char *) node + size;
	    note--;
	    delete = call(back, node);
	    if (delete) {
		break;
	    }
	} while (note);
    } else {
	delete = 0;
    }

    return delete;
}


static int
slip(void *node, unsigned rate, unsigned size, void *back,
     int (*call) (void *, void *))
{
    int delete;
    unsigned note;
    void **text;

    note = *(integral_q *) node + 1;

    text = (void **) ((char *) node + size * integral_q_bits_and_half);

    rate--;

    if (rate) {
	delete = _libx1f4l2_fpxx_bqfset(*text, rate, size, back, call);
	if (delete) {
	} else {
	    text++;

	    note--;

	    do {
		node = (char *) node + size;
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    delete = _libx1f4l2_fpxx_bqfset
			(*text, rate, size, back, call);
		    if (delete) {
			break;
		    }
		}

		note--;

		text++;
	    } while (note);
	}
    } else {
	delete = _libx1f4l2_flxx_bqfset(*text, size, back, call);
	if (delete) {
	} else {
	    text++;

	    note--;

	    do {
		node = (char *) node + size;
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    delete = _libx1f4l2_flxx_bqfset(*text, size, back, call);
		    if (delete) {
			break;
		    }
		}

		note--;

		text++;
	    } while (note);
	}
    }

    return delete;
}


int
x1f4_lime_bqfset(void *bqfset, void *back, int (*call) (void *, void *))
{
    int delete;
    unsigned rate;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
    if (rate) {
	delete = slip
	    (bqfset(bqfset)->link_a.fpnews.node, rate,
	     bqfset(bqfset)->link_a.fpnews.link_v.size, back, call);
    } else {
	delete = line
	    (bqfset(bqfset)->link_a.fpnews.node,
	     bqfset(bqfset)->link_a.fpnews.link_v.size, back, call);
    }

    return delete;
}
