/*
 * bqfx.3.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bcount.h>
#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <reverse.h>
#include <xfs.h>
#include <xls.h>

#define __HALF_TRANSFER__		1

#define __FINE_EXCESS__			1
#define __FINE_SECOND__			2
#define __FINE_SELECT__			3
#define __FINE_TARGET__			4

#define __FINE_METHOD__			__FINE_EXCESS__

#define ____FINE_METHOD__		__FINE_METHOD__

#define __LOSE_DOUBLE__			1

#define __LOSE_METHOD__			__LOSE_DOUBLE__

#define __UNROLL_TRANSFER__		0

#define FINE_ERROR			(LAST_ERROR + 8)

#define false(e)			0

#define here_two_test(___h) \
    ((___h) & 8192)

#undef here_two_test

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_l_count(___h, ___e, ___v) \
    ___n = (___e) & ~Lx55555555;					      \
    ___p = (___n | ___n >> (half_integral_q_bits + 1))			      \
	& ((Q(1) << half_integral_q_bits) - 1);				      \
    if ((___v)) {							      \
	___t = 1024;							      \
    } else {								      \
	___t = 1024 | 2048;						      \
    }
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_n_count(___h, ___e, ___v) \
    ___n = (___e) & ~Lx55555555;					      \
    ___p |= (___n | ___n << (half_integral_q_bits - 1))			      \
	& ~Q(0) << half_integral_q_bits;				      \
    if ((___v)) {							      \
	___t |= Q(1024) << half_integral_q_bits;			      \
    } else {								      \
	___t |= Q(1024 | 2048) << half_integral_q_bits;			      \
    }
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_l_reset(___h) \
    ___p = 0;								      \
    ___t = 0
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_n_reset(___h)
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_declarations \
    integral_q ___n, ___p, ___t
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_setup(___f, ___g) \
    l2_q_heap_1up(___p);						      \
									      \
    ___p &= Q(0xff) | Q(0xff) << half_integral_q_bits;			      \
									      \
    ___p |= ___t;							      \
    ___p |=								      \
	((___p								      \
	  - ((___t & (Q(1024) | Q(1024) << half_integral_q_bits)) >> 10))     \
	 & (Q(1024) | Q(1024) << half_integral_q_bits)) << 3;		      \
									      \
    (___f) = ___p & ((Q(1) << half_integral_q_bits) - 1);		      \
    (___g) = ___p >> half_integral_q_bits
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#define here_two_test(___h) \
    ((___h) & 8192)

#define text_rate(late, bqfset) \
    ((late) + 2 < bqfset((bqfset))->link_a.fpnews.link_v.rate)

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define cell(___s, ___n, ___t) \
    ((char *) (___s) - (___n) * (___t))

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#define trap(___n, ___s)		((___n) + ((___s) << 2))

#define true(e)				1

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int clip(void *, void *, unsigned, void *);
static int fine(void *, unsigned, void *, void *);
static int lose(void *, unsigned, void *, void *, void *, unsigned, void *,
		void *, unsigned, void *);
static int miss(void *, void *, unsigned, unsigned, unsigned, void *);
static int shut(void *, void *, unsigned, unsigned, void *);

static int
clip(void *bqfset, void *node, unsigned size, void *aime)
{
    int status;
    unsigned copy;

    status = bqfset(bqfset)->link_f.look(aime, node, &copy);
    if (status) {
	unsigned mind;
	void *call;

	mind = *(integral_q *) node;

	call = (char *) node + copy * size;

	status = bqfset(bqfset)->link_f.move
	    (call, (char *) call + size, mind - copy);
	if (status) {
	    status = MOVE_ERROR;
	} else {
	    *((integral_q *) node) = mind - 1;
	}
    } else {
	status = MISS_CLASS;
    }

    return status;
}


static int
fine(void *bqfset, unsigned size, void *node, void *aime)
{
    int status;

    do {
	integral_q news;
	unsigned copy;

	status = bqfset(bqfset)->link_f.pick(aime, node, &copy);
	if (status) {
	} else {
	    status = MISS_CLASS;
	    if (1) {
		break;
	    }
	}

	news = *(integral_q *) node;

	if (copy & 1) {
	    if (news & Q(1) << copy) {
		status = 0;

		*(integral_q *) node = news & ~(Q(1) << copy);

		if (1) {
		    break;
		}
	    } else {
		copy--;
	    }
	} else {
	    integral_q mode;

	    mode = Q(1) << (copy + 1);
	    if (news & mode) {
		void *fast;

		status = 0;

		*(integral_q *) node = news & ~mode;

		fast = rule(node, size, copy);

		bqfset(bqfset)->link_f.move(fast, (char *) fast + size, 1);

		if (1) {
		    break;
		}
	    }
	}
	{
	    integral_q slip;

	    slip = news & ~Lx55555555;
	    if (slip) {
		int (*move) (void *, void *, unsigned);
		integral_q mode;
		void *fast;

		move = bqfset(bqfset)->link_f.move;

		status = 0;

		fast = rule(node, size, copy);

		mode = Q(1) << (copy - 1);
		if (news & mode) {
		    *(integral_q *) node = news & ~mode;
		    move(fast, life(fast, size), 1);
		} else {
		    if (0) {
		    } else {
#if ____FINE_METHOD__ == __FINE_SELECT__
#elif __FINE_METHOD__ == __FINE_EXCESS__
			integral_q last, next;

			next = slip >> (copy + 1);
			last = slip << (integral_q_bits - copy);
			l2_q_reverse_1up(last);
			last >>= 1;
			slip = last | next;
			slip &= (slip - 1) << 1;
			if (last & slip) {
			    last = slip >> 4;
			    for (; last; last >>= 4) {
				void *side;

				side = (char *) fast - (size << 1);
				move(fast, side, 1);
				fast = (char *) side - (size << 1);
				move(side, fast, 1);

				copy -= 4;
			    }
			    if (slip & Lx44444444) {
				void *side;

				side = (char *) fast - (size << 1);
				move(fast, side, 1);
				fast = side;

				copy -= 2;
			    }
			    {
				move(fast, (char *) fast - size, 1);
			    }

			    *(integral_q *) node = news ^ (Q(1) << (copy - 1));
			} else {
			    next = slip >> 4;
			    for (; next; next >>= 4) {
				void *side;

				side = (char *) fast + (size << 1);
				move(fast, side, 1);
				fast = (char *) side + (size << 1);
				move(side, fast, 1);

				copy += 4;
			    }
			    if (slip & Lx44444444) {
				void *side;

				side = (char *) fast + (size << 1);
				move(fast, side, 1);
				fast = side;

				copy += 2;
			    }
			    {
				move(fast, (char *) fast + size, 1);
			    }

			    *(integral_q *) node = news ^ (Q(1) << (copy + 1));
			}
#elif __FINE_METHOD__ == __FINE_SECOND__
#elif __FINE_METHOD__ == __FINE_TARGET__
#endif				/* ____FINE_METHOD__ == __FINE_SELECT__ */
		    }
		}
	    } else {
		*(integral_q *) node = news & ~(Q(1) << copy);
		if (1) {
		    status = FINE_ERROR + copy;
		}
	    }
	}
    } while (0);

    return status;
}


static int
lose(void *bqfset, unsigned size, void *date, void *path, void *high,
     unsigned pass, void *turn, void *near, unsigned rate, void *aime)
{
    integral_q pipe;
    unsigned call;
    void *file, *node;
    int (*pick) (void *, void *, unsigned *), status;

    pick = bqfset(bqfset)->link_f.pick;

    node = ZD(high, size)[pass];

    pipe = *(integral_q *) node;

    while (1) {
	int delete;

	delete = pick(aime, node, &call);

	file = ZD(node, size)[call];

	if (rate) {
	    integral_q lane;

	    lane = *(integral_q *) file;

	    if (lane & ~Lx55555555) {
		if (call ^ (integral_q_bits - 1)) {
		    if (pipe & ((Q(1) << call) - 1) << 1) {
			date = NULL;
			near = NULL;
		    } else {
			near = NULL;
			if (date) {
			    date = ZD(date, size)[integral_q_last];
			} else {
			    if (text_rate(rate, bqfset)) {
				integral_q fold, late;

				late = Q(1) << pass;

				fold = *(integral_q *) high;
				if (fold & (late - 1) << 1) {
				    if (fold & late) {
					date = ZD(high, size)[pass - 1];
					path = HD(high, size, pass);
				    } else {
					date = ZD(high, size)[pass - 2];
					path = HD(high, size, pass - 1);
				    }

				    date = ZD(date, size)[integral_q_last];
				}
			    }
			}
		    }
		} else {
		    date = NULL;
		    if (near) {
			if (*(integral_q *) near & 2) {
			    near = ZD(near, size)[0];
			} else {
			    near = ZD(near, size)[1];
			}
		    } else {
			if (text_rate(rate, bqfset)) {
			    if (pass ^ (integral_q_bits - 1)) {
				turn = rule(high, size, pass + 1);
				if (pass & 1) {
				    if (*(integral_q *) high
					& (Q(1) << (pass + 2))) {
					near = ZD(high, size)[pass + 1];
				    } else {
					near = ZD(high, size)[pass + 2];
				    }
				} else {
				    near = ZD(high, size)[pass + 1];
				}

				if (*(integral_q *) near & 2) {
				    near = ZD(near, size)[0];
				} else {
				    near = ZD(near, size)[1];
				}
			    }
			}
		    }
		}

		high = node;

		pass = call;

		node = file;

		pipe = lane;

		rate = rate - 1;
	    } else {
		void *club, *head, *past, *tier;

		if (call & 1) {
		    if (pipe & (Q(1) << call)) {
			club = ZD(node, size)[call - 1];
			head = HD(node, size, call);
		    } else {
			if (call ^ 1) {
			    club = ZD(node, size)[call - 2];
			    head = HD(node, size, call - 1);
			} else {
			    head = path;
			    if (date) {
				club = ZD(date, size)[integral_q_last];
			    } else {
				club = NULL;
				if (text_rate(rate, bqfset)) {
				    integral_q fold;

				    fold = *(integral_q *) high;
				    if (fold & ((Q(1) << pass) - 1) << 1) {
					if (fold & (Q(1) << pass)) {
					    date = ZD(high, size)[pass - 1];
					    path = HD(high, size, pass);
					} else {
					    date = ZD(high, size)[pass - 2];
					    path = HD(high, size, pass - 1);
					}

					head = path;
					club = ZD(date, size)[integral_q_last];
				    }
				}
			    }
			}
		    }
		    if (call ^ (integral_q_bits - 1)) {
			past = HD(node, size, call + 1);
			if (pipe & (Q(1) << (call + 2))) {
			    tier = ZD(node, size)[call + 1];
			} else {
			    tier = ZD(node, size)[call + 2];
			}
		    } else {
			past = turn;
			if (near) {
			    if (*(integral_q *) near & 2) {
				tier = ZD(near, size)[0];
			    } else {
				tier = ZD(near, size)[1];
			    }
			} else {
			    tier = NULL;
			    if (text_rate(rate, bqfset)) {
				if (pass ^ (integral_q_bits - 1)) {
				    turn = HD(high, size, pass + 1);
				    if (pass & 1) {
					if (*(integral_q *) high
					    & (Q(1) << (pass + 2))) {
					    near = ZD(high, size)[pass + 1];
					} else {
					    near = ZD(high, size)[pass + 2];
					}
				    } else {
					near = ZD(high, size)[pass + 1];
				    }

				    past = turn;
				    if (*(integral_q *) near & 2) {
					tier = ZD(near, size)[0];
				    } else {
					tier = ZD(near, size)[1];
				    }
				}
			    }
			}
		    }
		} else {
		    past = HD(node, size, call + 1);
		    tier = ZD(node, size)[call + 1];
		    if (call) {
			club = ZD(node, size)[call - 1];
			head = HD(node, size, call);
		    } else {
			head = path;
			if (date) {
			    club = ZD(date, size)[integral_q_last];
			} else {
			    club = NULL;
			    if (text_rate(rate, bqfset)) {
				integral_q fold;

				fold = *(integral_q *) high;
				if (fold & ((Q(1) << pass) - 1) << 1) {
				    if (fold & (Q(1) << pass)) {
					date = ZD(high, size)[pass - 1];
					path = HD(high, size, pass);
				    } else {
					date = ZD(high, size)[pass - 2];
					path = HD(high, size, pass - 1);
				    }

				    head = path;
				    club = ZD(date, size)[integral_q_last];
				}
			    }
			}
			{
			}
			{
			}
		    }
		}

		status = _libx1f4l2_lift_bqfset
		    (bqfset, date, path, &head, &club, pipe, &node, &call,
		     &file, &tier, &past, turn, near, aime);
		if (status == FREE_ERROR) {
		    break;
		} else {
		}

		date = club;

		path = head;

		high = node;

		pass = call;

		node = file;

		pipe = *(integral_q *) file;

		turn = past;

		near = tier;

		rate = rate - 1;
	    }
	} else {
	    status = fine(bqfset, size, file, aime);
	    if (status) {
		if (status ^ MISS_CLASS) {
		} else {
		    if (delete) {
			status = FINE_ERROR + (integral_q_bits << 2);
		    } else {
			void *head;

			head = path;
			if (date) {
			} else {
			    if (text_rate(0, bqfset)) {
				integral_q fold;

				fold = *(integral_q *) high;
				if (fold & ((Q(1) << pass) - 1) << 1) {
				    if (fold & (Q(1) << pass)) {
					path = rule(high, size, pass);
				    } else {
					path = rule(high, size, pass - 1);
				    }

				    head = path;
				}
			    }
			}

			if (head) {
			    if (bqfset(bqfset)->link_f.fare(aime, head)) {
			    } else {
				status = FINE_ERROR + (integral_q_bits << 2);
			    }
			}
		    }
		}
		if (status < FINE_ERROR) {
		} else {
		    int (*move) (void *, void *, unsigned);
		    integral_q last, next;
		    unsigned copy, deck, ever;
		    void *club, *head, *past, *tier;

		    move = bqfset(bqfset)->link_f.move;

		    if (call & 1) {
			if (pipe & (Q(1) << call)) {
			    club = ZD(node, size)[call - 1];
			    head = HD(node, size, call);
			    date = NULL;
			} else {
			    if (call ^ 1) {
				club = ZD(node, size)[call - 2];
				head = HD(node, size, call - 1);
				date = NULL;
			    } else {
				head = path;
				if (date) {
				    club = ZD(date, size)[integral_q_last];
				} else {
				    club = NULL;
				    if (text_rate(0, bqfset)) {
					integral_q fold;

					fold = *(integral_q *) high;
					if (fold & ((Q(1) << pass) - 1) << 1) {
					    if (fold & (Q(1) << pass)) {
						date =
						    ZD(high, size)[pass - 1];
						path = HD(high, size, pass);
					    } else {
						date =
						    ZD(high, size)[pass - 2];
						path =
						    HD(high, size, pass - 1);
					    }

					    head = path;
					    club = ZD(date, size)
						[integral_q_last];
					}
				    }
				}
			    }
			}
			if (call ^ (integral_q_bits - 1)) {
			    past = HD(node, size, call + 1);
			    near = NULL;
			    if (pipe & (Q(1) << (call + 2))) {
				tier = ZD(node, size)[call + 1];
			    } else {
				tier = ZD(node, size)[call + 2];
			    }
			} else {
			    past = turn;
			    if (near) {
				if (*(integral_q *) near & 2) {
				    tier = ZD(near, size)[0];
				} else {
				    tier = ZD(near, size)[1];
				}
			    } else {
				tier = NULL;
				if (text_rate(0, bqfset)) {
				    if (pass ^ (integral_q_bits - 1)) {
					turn = HD(high, size, pass + 1);
					if (pass & 1) {
					    if (*(integral_q *) high
						& (Q(1) << (pass + 2))) {
						near =
						    ZD(high, size)[pass + 1];
					    } else {
						near =
						    ZD(high, size)[pass + 2];
					    }
					} else {
					    near = ZD(high, size)[pass + 1];
					}

					past = turn;
					if (*(integral_q *) near & 2) {
					    tier = ZD(near, size)[0];
					} else {
					    tier = ZD(near, size)[1];
					}
				    }
				}
			    }
			}
		    } else {
			past = HD(node, size, call + 1);
			near = NULL;
			if (call) {
			    club = ZD(node, size)[call - 1];
			    tier = ZD(node, size)[call + 1];
			    head = HD(node, size, call);
			    date = NULL;
			} else {
			    head = path;
			    if (date) {
				club = ZD(date, size)[integral_q_last];
			    } else {
				club = NULL;
				if (text_rate(0, bqfset)) {
				    integral_q fold;

				    fold = *(integral_q *) high;
				    if (fold & ((Q(1) << pass) - 1) << 1) {
					if (fold & (Q(1) << pass)) {
					    date = ZD(high, size)[pass - 1];
					    path = HD(high, size, pass);
					} else {
					    date = ZD(high, size)[pass - 2];
					    path = HD(high, size, pass - 1);
					}

					head = path;
					club = ZD(date, size)[integral_q_last];
				    }
				}
			    }
			    {
				tier = ZD(node, size)[call + 1];
			    }
			}
		    }

		    copy = status - FINE_ERROR;

		    if (copy ^ (integral_q_bits << 2)) {
		    } else {
			if (0) {
			} else {
			    integral_q news, slip;

			    news = *(integral_q *) file;

			    slip = news & ~Lx55555555;

			    if (slip) {
				status = 0;

				slip &= (slip - 1) << 1;

				*(integral_q *) file = news ^ slip;

				if (slip ^ 2) {
				    void *fast;

				    fast = road(file, size);

				    move(head, fast, 1);

				    slip >>= 2;

				    news = slip >> 4;
				    for (; news; news >>= 4) {
					void *side;

					side = road(fast, size);
					move(fast, side, 1);
					fast = road(side, size);
					move(side, fast, 1);
				    }
				    if (slip & (Lx44444444 << 1)) {
					void *side;

					side = road(fast, size);
					move(fast, side, 1);
					fast = side;
				    }
				    {
					move(fast, sans(fast, size), 1);
				    }
				} else {
				    move(head, sans(file, size), 1);
				}

				break;
			    } else {
				copy = 0;
			    }
			}
		    }

		    status = 0;

		    {
			here_two_declarations;

			if (club) {
			    last = *(integral_q *) club;
			    here_two_l_count(deck, last, date);
			} else {
			    here_two_l_reset(deck);

			    /*
			     * rubbish warnings...
			     */
			    last = 0;
			}

			if (tier) {
			    next = *(integral_q *) tier;
			    here_two_n_count(ever, next, near);
			} else {
			    here_two_n_reset(ever);

			    /*
			     * rubbish warnings...
			     */
			    next = 0;
			}

			here_two_setup(deck, ever);
		    }

		    if (here_two_test(deck | ever)) {
			if (deck < ever) {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q text;
				unsigned slip;
				void *fast, *side;

				if (copy) {
				} else {
				    copy = 2;

				    move(head, road(file, size), 1);
				}

				fast = rule(file, size, copy);

				deck = (integral_q_bits - copy - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				if (deck & 1) {
				    side = road(fast, size);
				    move(fast, side, 1);
				    fast = side;
				}
				deck >>= 1;
				for (; deck; deck--) {
				    side = road(fast, size);
				    move(fast, side, 1);
				    fast = road(side, size);
				    move(side, fast, 1);
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				ever &= 254;

				if (ever < 4) {
				    ever = 1;

				    *(integral_q *) fast = Lx55555555;

				    fast =
					rule(fast, size, integral_q_bits - 2);
				} else {
				    *(integral_q *) fast = Lx55555555
					| ~Q(0)
					<< (integral_q_bits - ever + 2);

				    if (ever < 8) {
					ever >>= 1;

					fast =
					    rule(fast, size,
						 integral_q_bits - ever);
				    } else {
					fast =
					    rule(fast, size,
						 integral_q_bits - ever + 3);

					side = sans(fast, size);

					ever >>= 1;

					deck = ever - 3;
					for (; deck; deck--) {
					    move(fast, side, 1);
					    dana(side, size);
					    skip(fast, size);
					}
				    }
				}

				move(fast, past, 1);

				skip(fast, size);

				ever--;

				side = tier;

				text = *(integral_q *) tier;

				while (ever & ~1) {
				    if (text & Q(2)) {
					skip(side, size);
					move(fast, side, 2);
					dana(fast, size);
					skip(side, size);

					ever -= 2;
				    } else {
					ever--;

					dana(side, size);
					move(fast, side, 1);
					skip(fast, size);
				    }

				    text >>= 2;
				}
				if (ever) {
				    if (text & Q(2)) {
					skip(side, size);
					move(fast, side, 1);
					skip(side, size);
					move(past, side, 1);

					ever = 0;
				    } else {
					dana(side, size);
					move(fast, side, 1);
				    }

				    text >>= 2;
				} else {
				    ever = 1;
				}
				slip = 2;
				if (ever) {
				    if (text & Q(2)) {
					skip(side, size);
					move(past, side, 1);

					skip(side, size);

					fast = road(tier, size);

					text >>= 1;
				    } else {
					dana(side, size);
					move(past, side, 1);

					skip(side, size);

					fast = road(tier, size);

					text >>= 2;

					if (fast < side) {
					    text >>= 1;
					    if (text & Q(1)) {
						move(fast, side, 1);
						dana(fast, size);
						slip += 2;
					    } else {
					    }

					    skip(side, size);
					}
				    }
				} else {
				    skip(side, size);

				    fast = road(tier, size);

				    if (fast < side) {
					text >>= 1;
					if (text & Q(1)) {
					    move(fast, side, 1);
					    dana(fast, size);
					    slip += 2;
					} else {
					}

					skip(side, size);
				    }
				}
				while (fast < side) {
				    if (text & Q(4)) {
					move(fast, side, 1);
					dana(fast, size);
					skip(side, size);
					move(fast, side, 1);
					dana(fast, size);
					skip(side, size);
					slip += 4;
				    } else {
					move(fast, side, 1);
					dana(fast, size);
					dana(side, size);
					slip += 2;
				    }

				    text >>= 2;
				}

				*(integral_q *) tier =
				    Lx55555555 | text >> 1 << (slip - 1) << 1;
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			} else {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q text;
				unsigned slip;
				void *fast, *side;

				if (copy) {
				} else {
				    copy = 2;

				    move(head, road(file, size), 1);
				}

				fast = rule(file, size, copy);

				ever = (copy - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				if (ever & 1) {
				    side = lola(fast, size);
				    move(fast, side, 1);
				    fast = side;
				}
				ever >>= 1;
				for (; ever; ever--) {
				    side = lola(fast, size);
				    move(fast, side, 1);
				    fast = lola(side, size);
				    move(side, fast, 1);
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				deck &= 254;

				if (deck < 4) {
				    deck = 1;

				    *(integral_q *) fast = Lx55555555;

				    dana(fast, size);
				} else {
				    *(integral_q *) fast = Lx55555555
					| ((Q(1) << (deck - 2)) - 1);

				    if (deck < 8) {
					deck >>= 1;

					fast = rule(fast, size, deck);
				    } else {
					fast = rule(fast, size, deck - 3);

					side = life(fast, size);

					deck >>= 1;

					ever = deck - 3;
					for (; ever; ever--) {
					    move(fast, side, 1);
					    beta(side, size);
					    posh(fast, size);
					}
				    }
				}

				move(fast, head, 1);

				posh(fast, size);

				deck--;

				text = *(integral_q *) club;

				side = rule(club, size, integral_q_bits);

				while (deck & ~1) {
				    if (text & Q(1) << integral_q_last) {
					beta(side, size);
					posh(fast, size);
					move(fast, side, 2);
					posh(fast, size);

					deck -= 2;
				    } else {
					deck--;

					beta(side, size);
					move(fast, side, 1);
					posh(fast, size);
				    }

				    text <<= 2;
				}
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					posh(side, size);
					move(fast, side, 1);
					posh(side, size);
					move(head, side, 1);

					deck = 0;
				    } else {
					beta(side, size);
					move(fast, side, 1);
				    }

				    text <<= 2;
				} else {
				    deck = 1;
				}
				slip = integral_q_bits - 2;
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					posh(side, size);
					move(head, side, 1);

					posh(side, size);

					fast =
					    rule(club, size,
						 integral_q_bits - 2);

					text <<= 1;
				    } else {
					beta(side, size);
					move(head, side, 1);

					posh(side, size);

					fast =
					    rule(club, size,
						 integral_q_bits - 2);

					text <<= 2;

					if (side < fast) {
					    if (text
						& Q(1) << integral_q_last) {
						move(fast, side, 1);
						beta(fast, size);
						slip -= 2;
					    }

					    posh(side, size);

					    text <<= 1;
					}
				    }
				} else {
				    posh(side, size);

				    fast =
					rule(club, size, integral_q_bits - 2);

				    if (side < fast) {
					if (text & Q(1) << integral_q_last) {
					    move(fast, side, 1);
					    beta(fast, size);
					    slip -= 2;
					}

					posh(side, size);

					text <<= 1;
				    }
				}
				while (side < fast) {
				    if (text & Q(1) << (integral_q_bits - 2)) {
					move(fast, side, 1);
					beta(fast, size);
					posh(side, size);
					move(fast, side, 1);
					beta(fast, size);
					posh(side, size);
					slip -= 4;
				    } else {
					move(fast, side, 1);
					beta(fast, size);
					beta(side, size);
					slip -= 2;
				    }

				    text <<= 2;
				}

				*(integral_q *) club = Lx55555555
				    | text >> (integral_q_last - slip);
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			}
		    } else {
			status = _libx1f4l2_rail_bqfset
			    (bqfset, size, node, file, call, copy, pipe, last,
			     next, club, head, past, tier);
		    }
		}
	    }

	    break;
	}
    }

    return status;
}


static int
miss(void *bqfset, void *node, unsigned size, unsigned pick, unsigned rate,
     void *aime)
{
    int status;

    if (1) {
	unsigned mind;
	void *club, *head, *past, *tier;

	mind = *(integral_q *) node;

	if (pick) {
	    club = MD(node, size)[pick - 1];
	    head = rule(node, size, pick);
	    if (pick ^ mind) {
		past = rule(node, size, pick + 1);
		tier = MD(node, size)[pick + 1];
	    } else {
		past = NULL;
		tier = NULL;
	    }
	} else {
	    club = NULL;
	    head = NULL;
	    past = rule(node, size, pick + 1);
	    tier = MD(node, size)[pick + 1];
	}

	do {
	    void *file;

	    file = MD(node, size)[pick];

	    if (*(integral_q *) file & ~Lx55555555) {
	    } else {
		status = _libx1f4l2_sand_bqfset
		    (bqfset, mind, node, &club, &head, &pick, file, &past,
		     &tier, rate, aime);
		if (status) {
		    if (status < LAST_ERROR) {
			break;
		    } else {
			if (status ^ (LAST_ERROR + integral_q_bits)) {
			    status = shut
				(bqfset, bqfset(bqfset)->link_a.fpnews.node,
				 size, rate, aime);

			    break;
			} else {
			    file = MD(node, size)[pick];
			}
		    }
		}
	    }

	    status = lose
		(bqfset, size, club, head, node, trap(pick, size), past, tier,
		 rate - 1, aime);
	} while (0);
    }

    return status;
}


static int
shut(void *bqfset, void *node, unsigned size, unsigned rate, void *aime)
{
    int delete, status;
    unsigned pick;

    delete = bqfset(bqfset)->link_f.look(aime, node, &pick);

    if (rate ^ 1) {
	status = miss(bqfset, node, size, pick, rate - 1, aime);
    } else {
	do {
	    void *file;

	    file = MD(node, size)[pick];

	    status = fine(bqfset, size, file, aime);
	    if (status) {
		if (status ^ MISS_CLASS) {
		} else {
		    if (delete) {
			status = FINE_ERROR + (integral_q_bits << 2);
		    }
		}
		if (status < FINE_ERROR) {
		} else {
		    int (*move) (void *, void *, unsigned);
		    integral_q last, next;
		    unsigned copy, deck, ever, mind;
		    void *club, *tier;

		    mind = *(integral_q *) node;

		    move = bqfset(bqfset)->link_f.move;

		    copy = status - FINE_ERROR;

		    if (copy ^ (integral_q_bits << 2)) {
		    } else {
			if (0) {
			} else {
			    integral_q news, slip;

			    news = *(integral_q *) file;

			    slip = news & ~Lx55555555;

			    if (slip) {
				status = 0;

				slip &= (slip - 1) << 1;

				*(integral_q *) file = news ^ slip;

				if (slip ^ 2) {
				    void *fast;

				    fast = road(file, size);

				    move(rule(node, size, pick), fast, 1);

				    slip >>= 2;

				    news = slip >> 4;
				    for (; news; news >>= 4) {
					void *side;

					side = road(fast, size);
					move(fast, side, 1);
					fast = road(side, size);
					move(side, fast, 1);
				    }
				    if (slip & (Lx44444444 << 1)) {
					void *side;

					side = road(fast, size);
					move(fast, side, 1);
					fast = side;
				    }
				    {
					move(fast, sans(fast, size), 1);
				    }
				} else {
				    move(rule(node, size, pick),
					 sans(file, size), 1);
				}

				break;
			    } else {
				copy = 0;
			    }
			}
		    }

		    status = 0;

		    if (pick) {
			club = MD(node, size)[pick - 1];
			last = *(integral_q *) club;
			l2_q_bitcount(deck, last);
		    } else {
			deck = 0;

			/*
			 * rubbish warnings...
			 */
			last = 0;
			club = NULL;
		    }

		    if (pick ^ mind) {
			tier = MD(node, size)[pick + 1];
			next = *(integral_q *) tier;
			l2_q_bitcount(ever, next);
		    } else {
			ever = 0;

			/*
			 * rubbish warnings...
			 */
			next = 0;
			tier = NULL;
		    }

		    if (half_integral_q_bits < deck
			|| half_integral_q_bits < ever) {
			if (deck < ever) {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q text;
				unsigned slip;
				void *fast, *side;

				if (copy) {
				} else {
				    copy = 2;

				    move(rule(node, size, pick),
					 road(file, size), 1);
				}

				fast = rule(file, size, copy);

				deck = (integral_q_bits - copy - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				if (deck & 1) {
				    side = road(fast, size);
				    move(fast, side, 1);
				    fast = side;
				}
				deck >>= 1;
				for (; deck; deck--) {
				    side = road(fast, size);
				    move(fast, side, 1);
				    fast = road(side, size);
				    move(side, fast, 1);
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				ever -= half_integral_q_bits;

				if (ever < 4) {
				    ever = 1;

				    *(integral_q *) fast = Lx55555555;

				    fast =
					rule(fast, size, integral_q_bits - 2);
				} else {
				    ever &= ~1;

				    *(integral_q *) fast = Lx55555555
					| ~Q(0)
					<< (integral_q_bits - ever + 2);

				    if (ever < 8) {
					ever >>= 1;

					fast =
					    rule(fast, size,
						 integral_q_bits - ever);
				    } else {
					fast =
					    rule(fast, size,
						 integral_q_bits - ever + 3);

					side = sans(fast, size);

					ever >>= 1;

					deck = ever - 3;
					for (; deck; deck--) {
					    move(fast, side, 1);
					    dana(side, size);
					    skip(fast, size);
					}
				    }
				}

				move(fast, rule(node, size, pick + 1), 1);

				skip(fast, size);

				ever--;

				side = tier;

				text = *(integral_q *) tier;

				while (ever & ~1) {
				    if (text & Q(2)) {
					skip(side, size);
					move(fast, side, 2);
					dana(fast, size);
					skip(side, size);

					ever -= 2;
				    } else {
					ever--;

					dana(side, size);
					move(fast, side, 1);
					skip(fast, size);
				    }

				    text >>= 2;
				}
				if (ever) {
				    if (text & Q(2)) {
					skip(side, size);
					move(fast, side, 1);
					skip(side, size);
					move(rule(node, size, pick + 1), side,
					     1);

					ever = 0;
				    } else {
					dana(side, size);
					move(fast, side, 1);
				    }

				    text >>= 2;
				} else {
				    ever = 1;
				}
				slip = 2;
				if (ever) {
				    if (text & Q(2)) {
					skip(side, size);
					move(rule(node, size, pick + 1), side,
					     1);

					skip(side, size);

					fast = road(tier, size);

					text >>= 1;
				    } else {
					dana(side, size);
					move(rule(node, size, pick + 1), side,
					     1);

					skip(side, size);

					fast = road(tier, size);

					text >>= 2;

					if (fast < side) {
					    text >>= 1;
					    if (text & Q(1)) {
						move(fast, side, 1);
						dana(fast, size);
						slip += 2;
					    } else {
					    }

					    skip(side, size);
					}
				    }
				} else {
				    skip(side, size);

				    fast = road(tier, size);

				    if (fast < side) {
					text >>= 1;
					if (text & Q(1)) {
					    move(fast, side, 1);
					    dana(fast, size);
					    slip += 2;
					} else {
					}

					skip(side, size);
				    }
				}
				while (fast < side) {
				    if (text & Q(4)) {
					move(fast, side, 1);
					dana(fast, size);
					skip(side, size);
					move(fast, side, 1);
					dana(fast, size);
					skip(side, size);
					slip += 4;
				    } else {
					move(fast, side, 1);
					dana(fast, size);
					dana(side, size);
					slip += 2;
				    }

				    text >>= 2;
				}

				*(integral_q *) tier =
				    Lx55555555 | text >> 1 << (slip - 1) << 1;
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			} else {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q text;
				unsigned slip;
				void *fast, *side;

				if (copy) {
				} else {
				    copy = 2;

				    move(rule(node, size, pick),
					 road(file, size), 1);
				}

				fast = rule(file, size, copy);

				ever = (copy - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				if (ever & 1) {
				    side = lola(fast, size);
				    move(fast, side, 1);
				    fast = side;
				}
				ever >>= 1;
				for (; ever; ever--) {
				    side = lola(fast, size);
				    move(fast, side, 1);
				    fast = lola(side, size);
				    move(side, fast, 1);
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				deck -= half_integral_q_bits;

				if (deck < 4) {
				    deck = 1;

				    *(integral_q *) fast = Lx55555555;

				    dana(fast, size);
				} else {
				    deck &= ~1;

				    *(integral_q *) fast = Lx55555555
					| ((Q(1) << (deck - 2)) - 1);

				    if (deck < 8) {
					deck >>= 1;

					fast = rule(fast, size, deck);
				    } else {
					fast = rule(fast, size, deck - 3);

					side = life(fast, size);

					deck >>= 1;

					ever = deck - 3;
					for (; ever; ever--) {
					    move(fast, side, 1);
					    beta(side, size);
					    posh(fast, size);
					}
				    }
				}

				move(fast, rule(node, size, pick), 1);

				posh(fast, size);

				deck--;

				text = *(integral_q *) club;

				side = rule(club, size, integral_q_bits);

				while (deck & ~1) {
				    if (text & Q(1) << integral_q_last) {
					beta(side, size);
					posh(fast, size);
					move(fast, side, 2);
					posh(fast, size);

					deck -= 2;
				    } else {
					deck--;

					beta(side, size);
					move(fast, side, 1);
					posh(fast, size);
				    }

				    text <<= 2;
				}
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					posh(side, size);
					move(fast, side, 1);
					posh(side, size);
					move(rule(node, size, pick), side, 1);

					deck = 0;
				    } else {
					beta(side, size);
					move(fast, side, 1);
				    }

				    text <<= 2;
				} else {
				    deck = 1;
				}
				slip = integral_q_bits - 2;
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					posh(side, size);
					move(rule(node, size, pick), side, 1);

					posh(side, size);

					fast =
					    rule(club, size,
						 integral_q_bits - 2);

					text <<= 1;
				    } else {
					beta(side, size);
					move(rule(node, size, pick), side, 1);

					posh(side, size);

					fast =
					    rule(club, size,
						 integral_q_bits - 2);

					text <<= 2;

					if (side < fast) {
					    if (text
						& Q(1) << integral_q_last) {
						move(fast, side, 1);
						beta(fast, size);
						slip -= 2;
					    }

					    posh(side, size);

					    text <<= 1;
					}
				    }
				} else {
				    posh(side, size);

				    fast =
					rule(club, size, integral_q_bits - 2);

				    if (side < fast) {
					if (text & Q(1) << integral_q_last) {
					    move(fast, side, 1);
					    beta(fast, size);
					    slip -= 2;
					}

					posh(side, size);

					text <<= 1;
				    }
				}
				while (side < fast) {
				    if (text & Q(1) << (integral_q_bits - 2)) {
					move(fast, side, 1);
					beta(fast, size);
					posh(side, size);
					move(fast, side, 1);
					beta(fast, size);
					posh(side, size);
					slip -= 4;
				    } else {
					move(fast, side, 1);
					beta(fast, size);
					beta(side, size);
					slip -= 2;
				    }

				    text <<= 2;
				}

				*(integral_q *) club = Lx55555555
				    | text >> (integral_q_last - slip);
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			}
		    } else {
			do {
			    void *fast;

			    if (mind ^ 1) {
			    } else {
				if (copy) {
				} else {
				    copy = 2;

				    move(rule(node, size, pick),
					 road(file, size), 1);
				}

				status = _libx1f4l2_fold_bqfset
				    (bqfset, club, file, tier, pick, copy,
				     node);
				if (1) {
				    break;
				}
			    }

			    if (pick) {
				if (pick ^ mind) {
				} else {
				    _libx1f4l2_gray_bqfset
					(bqfset, &club, node, &pick, &file,
					 &tier, &copy);
				    if (tier) {
				    } else {
					break;
				    }
				}
			    } else {
				if (1) {
				    _libx1f4l2_blue_bqfset
					(bqfset, &club, node, &pick, &file,
					 &tier, &copy);
				    if (club) {
				    } else {
					break;
				    }
				}
			    }

			    if (copy ^ half_integral_q_bits) {
				fast = file;

				if (copy) {
				} else {
				    copy = 2;

				    move(rule(node, size, pick),
					 road(file, size), 1);
				}

				fast = rule(fast, size, copy);

				if (copy < half_integral_q_bits) {
				    deck = (half_integral_q_bits - copy) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				    for (; deck; deck--) {
					move(fast, (char *) fast + (size << 1),
					     1);
					dana(fast, size);
				    }
# endif				/* __UNROLL_TRANSFER__ */
				} else {
				    deck = (copy - half_integral_q_bits) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				    for (; deck; deck--) {
					move(fast, (char *) fast - (size << 1),
					     1);
					beta(fast, size);
				    }
# endif				/* __UNROLL_TRANSFER__ */
				}
			    }

			    {
				void *side;

				fast = club;

				*(integral_q *) club =
				    Lxdddddddd ^ Q(1) << integral_q_last;

				if (0) {
				} else {
				    fast = rule(fast, size, 4);

				    side = life(fast, size);

				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				deck = (integral_q_bits - 6) / 6;
				for (; deck; deck--) {
				    move(side, fast, 1);
				    dana(fast, size);
				    dana(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					move(side, fast, 1);

					fast = file;

					dana(fast, size);
					dana(side, size);
					move(side, rule(node, size, pick), 1);
					skip(side, size);
					move(side, fast, 1);
					skip(side, size);
				    } else {
					move(side, fast, 1);
					dana(fast, size);
					dana(side, size);
					move(side, fast, 1);

					fast = file;

					skip(side, size);
					move(side, rule(node, size, pick), 1);
					skip(side, size);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				}

				{
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				}

				fast = rule(tier, size, integral_q_bits);

				side = fast;

				deck = integral_q_bits / 6;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					fast =
					    rule(file, size,
						 integral_q_bits - 2);

					posh(side, size);
					move(side, rule(node, size, pick + 1),
					     1);
					posh(side, size);
					move(side, fast, 1);
					beta(side, size);
					beta(fast, size);
					move(side, fast, 1);
				    } else {
					posh(side, size);
					beta(fast, size);
					move(side, fast, 1);

					fast =
					    rule(file, size,
						 integral_q_bits - 2);

					posh(side, size);
					move(side, rule(node, size, pick + 1),
					     1);
					beta(side, size);
					move(side, fast, 1);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				{
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				*(integral_q *) tier = Lxdddddddd;
			    }

			    if (1) {
				void *side, **trap;

				trap = MD(node, size) + pick;

				memmove(trap, trap + 1,
					(mind - pick) * sizeof(void *));

				side = rule(node, size, pick);

				move(side, cell(fast, size, 4), 1);

				skip(side, size);

				move(side, sans(side, size), mind - pick);

				*(integral_q *) node = mind - 1;

				status = bqfset(bqfset)->link_m.free
				    (bqfset(bqfset)->link_m.data, file);
				if (status) {
				    status = FREE_ERROR;
				}
			    }
			} while (0);
		    }
		}
	    }
	} while (0);
    }

    return status;
}


int
x1f4_cast_bqfset(void *bqfset, void *aime)
{
    int status;
    unsigned rate, size;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

    if (rate) {
	status = shut
	    (bqfset, bqfset(bqfset)->link_a.fpnews.node, size, rate, aime);
    } else {
	status = clip(bqfset, bqfset(bqfset)->link_a.fpnews.node, size, aime);
    }

    return status;
}
