/*
 * bqfx.2.c
 * Copyright (C) 2009-2011, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-config.h>

#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <reverse.h>
#include <xfs.h>
#include <xls.h>

#define __LOCK_TARGET__			3

#define __LOCK_METHOD__			__LOCK_TARGET__

#define ____LOCK_METHOD__		__LOCK_METHOD__

#define __HEAD_LEFT__			1

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#undef Q
#define Q(e)				((integral_q) (e))

#define true(e)				1

#define false(e)			0

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int lock(void *, void *, unsigned, unsigned, void *, void **);
static int mind(void *, void *, unsigned, void *, void **);

static int
lock(void *bqfset, void *node, unsigned size, unsigned rate, void *aime,
		 void **edit)
{
    int (*pick) (void *, void *, unsigned *), status;

    pick = bqfset(bqfset)->link_f.pick;

    while (1) {
	unsigned copy;

	status = pick(aime, node, &copy);
	if (status) {
	    status = EVER_MATCH;

	    if (copy & 1) {
		if (*(integral_q *) node & Q(1) << copy) {
		} else {
		    copy--;
		}
	    }

	    *edit = rule(node, size, copy);

	    break;
	}

	if (rate) {
	    void *down;

	    down = ZD(node, size)[copy];

	    if (~*(integral_q *) down) {
	    } else {
		status = _libx1f4l2_fare_bqfset
		    (bqfset, node, copy, &down, rate, (void *) aime, edit);
		if (status) {
		    break;
		} else {
		    if (rate ^ 1) {
		    } else {
			break;
		    }
		}
	    }

	    rate--;

	    node = down;
	} else {
	    int (*move) (void *, void *, unsigned);

	    move = bqfset(bqfset)->link_f.move;

	    if (0) {
#if ____LOCK_METHOD__ == __LOCK_TARGET__
	    } else {
		integral_q news, slip;
		unsigned deck, ever;

		news = *(integral_q *) node;

		slip = ~news & (~Q(0) << copy << 1);
		if (slip) {
		    l2_q_xfs(ever, slip);
		    copy++;
# if __HEAD_LEFT__
		    slip = ((Q(1) << ever) - (Q(1) << copy)) >> (ever - copy)
			& ~news;
		    if (slip) {
			l2_q_xls(deck, slip);
			deck ^= integral_q_last;
			if (1) {
			    void *text;

			    *(integral_q *) node = news | Q(1) << deck;
			    copy--;
			    ever = copy - deck;
			    if (ever) {
				text = rule(node, size, deck);
				move(text, sans(text, size), ever);
			    }
			    {
				*edit = rule(node, size, copy);
			    }
			}
		    } else {
			if (1) {
			    void *text;

			    *(integral_q *) node = news | Q(1) << ever;
			    text = rule(node, size, copy);
			    {
				move(sans(text, size), text, ever - copy);
			    }
			    {
				*edit = text;
			    }
			}
		    }
# else
		    slip = ~news & ((Q(1) << copy) - 1);
		    if (slip) {
			l2_q_xls(deck, slip);
			deck ^= integral_q_last;
			if (copy - deck < ever - copy) {
			    void *text;

			    *(integral_q *) node = news | Q(1) << deck;
			    copy--;
			    ever = copy - deck;
			    if (ever) {
				text = rule(node, size, deck);
				move(text, sans(text, size), ever);
			    }
			    {
				*edit = rule(node, size, copy);
			    }
			} else {
			    void *text;

			    *(integral_q *) node = news | Q(1) << ever;
			    text = rule(node, size, copy);
			    {
				move(sans(text, size), text, ever - copy);
			    }
			    {
				*edit = text;
			    }
			}
		    } else {
			if (1) {
			    void *text;

			    *(integral_q *) node = news | Q(1) << ever;
			    text = rule(node, size, copy);
			    {
				move(sans(text, size), text, ever - copy);
			    }
			    {
				*edit = text;
			    }
			}
		    }
# endif				/* __HEAD_LEFT__ */
		} else {
		    l2_q_xls(deck, ~news);
		    if (1) {
			deck ^= integral_q_last;
			if (1) {
			    void *text;

			    *(integral_q *) node = news | Q(1) << deck;
			    text = rule(node, size, deck);
			    ever = copy - deck;
			    if (ever) {
				text = rule(node, size, deck);
				move(text, sans(text, size), ever);
			    }
			    {
				*edit = rule(node, size, copy);
			    }
			}
		    }
		}
#endif				/* ____LOCK_METHOD__ == __LOCK_TARGET__ */
	    }

	    break;
	}
    }

    return status;
}


static int
mind(void *bqfset, void *node, unsigned size, void *aime, void **edit)
{
    int status;
    unsigned copy;

    status = bqfset(bqfset)->link_f.look(aime, node, &copy);
    if (status) {
	*edit = rule(node, size, copy);

	status = EVER_MATCH;
    } else {
#if __MICRO_FSETS__
	do {
#endif				/* __MICRO_FSETS__ */
	    unsigned mind;
#if __MICRO_FSETS__
	    unsigned sans;
#endif				/* __MICRO_FSETS__ */
	    void *call;

	    copy++;

	    mind = *(integral_q *) node + 1;

#if __MICRO_FSETS__
	    sans = mind & mind << 1;
	    if (sans & (sans - 1)) {
	    } else {
		sans |= sans >> 1;
		if (mind ^ sans) {
		} else {
		    sans <<= 1;
		    if (sans == integral_q_bits_and_half) {
			sans *= (size + SIZEOF_integral_q);
		    } else {
			sans *= size;
		    }

		    status = bqfset(bqfset)->link_m.mode
			(bqfset(bqfset)->link_m.data, &node, sans);
		    if (status) {
			status = MODE_ERROR;
			if (1) {
			    break;
			}
		    } else {
			bqfset(bqfset)->link_a.fpnews.node = node;
		    }
		}
	    }
#endif				/* __MICRO_FSETS__ */

	    call = rule(node, size, copy);

	    status = bqfset(bqfset)->link_f.move
		(sans(call, size), call, mind - copy);
	    if (status) {
		status = MOVE_ERROR;
	    } else {
		*edit = call;

		*((integral_q *) node) = mind;
	    }
#if __MICRO_FSETS__
	} while (0);
#endif				/* __MICRO_FSETS__ */
    }

    return status;
}


int
x1f4_post_bqfset(void *bqfset, void *aime, void **edit)
{
    int status;

    do {
	unsigned rate, size;
	void *node;

	size = bqfset(bqfset)->link_a.fpnews.link_v.size;

	rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

	node = bqfset(bqfset)->link_a.fpnews.node;

	if (*(integral_q *) node ^ (integral_q_bits_and_half - 1)) {
	} else {
	    status = _libx1f4l2_long_bqfset(bqfset, aime, edit);
	    if (status) {
		break;
	    } else {
		if (rate) {
		    node = bqfset(bqfset)->link_a.fpnews.node;

		    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
		} else {
		    break;
		}
	    }
	}

	if (rate) {
	    unsigned copy;
	    void *down;

	    status = bqfset(bqfset)->link_f.look(aime, node, &copy);
	    if (status) {
		status = EVER_MATCH;

		*edit = rule(node, size, copy);

		if (1) {
		    break;
		}
	    }

	    down = MD(node, size)[copy];

	    if (~*(integral_q *) down) {
	    } else {
		status = _libx1f4l2_hale_bqfset
		    (bqfset, node, copy, &down, aime, edit);
		if (status) {
		    break;
		} else {
		    if (rate ^ 1) {
		    } else {
			break;
		    }
		}
	    }

	    rate--;

	    node = down;

	    status = lock(bqfset, node, size, rate, aime, edit);
	} else {
	    status = mind(bqfset, node, size, aime, edit);
	}
    } while (0);

    return status;
}
