/*
 * bqfx-inter.h
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#ifndef __LIBx1f4_bqfx_inter_H__
#define __LIBx1f4_bqfx_inter_H__

#include <bqfx-names.h>
#include <bqfx-types.h>

#if !defined _libx1f4l2_fast_bqfset
# define _libx1f4l2_fast_bqfset		x1f4_fast_bqfset
#endif				/* !_libx1f4l2_fast_bqfset */
#if !defined _libx1f4l2_flat_bqfset
# define _libx1f4l2_flat_bqfset		x1f4_flat_bqfset
#endif				/* !_libx1f4l2_flat_bqfset */

extern int _libx1f4l2_blue_bqfset
    (void *, void **, void *, unsigned *, void **, void **, unsigned *);
extern int _libx1f4l2_blue_bqpset
    (void *, integral_q **, void *, unsigned *, integral_q **, integral_q **,
     unsigned *);
extern int _libx1f4l2_ceil_bqfset(void *);
extern int _libx1f4l2_dawn_bqfset
    (void *, unsigned, void *, void *, void **, void *, unsigned);
extern int _libx1f4l2_else_bqfset
    (void *, void *, void *, void **, unsigned, void **, void *, void **,
     void *);
extern int _libx1f4l2_elif_bqfset
    (void *, void *, void **, void *, void **, unsigned, void **, void *,
     void *);
extern int _libx1f4l2_fair_bqfset
    (void *, unsigned, void *, void *, void *, void **, void *, unsigned);
extern int _libx1f4l2_fare_bqfset
    (void *, void *, unsigned, void **, unsigned, void *, void **);
extern int _libx1f4l2_fare_bqpset
    (void *, void *, void *, unsigned, void **, unsigned);
extern int _libx1f4l2_fast_bqfset(void *, unsigned, struct screen_type *);
extern int _libx1f4l2_five_bqfset
    (void *, integral_q, void **, unsigned, void **, void *, void **, void *);
extern int _libx1f4l2_flat_bqfset(void *);
extern int _libx1f4l2_flxx_bqfset
    (void *, unsigned, void *, int (*) (void *, void *));
extern int _libx1f4l2_fpxx_bqfset
    (void *, unsigned, unsigned, void *, int (*) (void *, void *));
extern int _libx1f4l2_fold_bqfset
    (void *, void *, void *, void *, unsigned, unsigned, void *);
extern int _libx1f4l2_fold_bqpset
    (void *, integral_q *, integral_q *, integral_q *, unsigned, unsigned,
     void *);
extern int _libx1f4l2_four_bqfset
    (void *, integral_q, void **, integral_q, void **, unsigned *, void **,
     void **, void **, integral_q, unsigned *);
extern int _libx1f4l2_four_bqpset
    (void *, integral_q, integral_q **, integral_q, void **, unsigned *,
     integral_q **, integral_q **, integral_q **, integral_q, unsigned *);
extern int _libx1f4l2_gray_bqfset
    (void *, void **, void *, unsigned *, void **, void **, unsigned *);
extern int _libx1f4l2_gray_bqpset
    (void *, integral_q **, void *, unsigned *, integral_q **, integral_q **,
     unsigned *);
extern int _libx1f4l2_hale_bqfset
    (void *, void *, unsigned, void **, void *, void **);
extern int _libx1f4l2_hale_bqpset
    (void *, void *, void *, unsigned, void **, unsigned);
extern int _libx1f4l2_here_bqfset
    (void *, unsigned, void *, void *, void **, void *, unsigned);
extern int _libx1f4l2_join_bqfset
    (void *, unsigned, void *, void **, void **, unsigned *, void *, void **,
     void **, unsigned, void *);
extern int _libx1f4l2_join_bqpset
    (void *, unsigned, void *, integral_q **, integral_q **, unsigned *,
     integral_q *, integral_q **, integral_q **, unsigned, integral_q);
extern int _libx1f4l2_lane_bqfset
    (void *, unsigned, void *, void **, void **, unsigned *, void *, void **,
     void **, unsigned, void *);
extern int _libx1f4l2_lane_bqpset
    (void *, unsigned, void *, integral_q **, integral_q **, unsigned *,
     integral_q *, integral_q **, integral_q **, unsigned, integral_q);
extern int _libx1f4l2_lift_bqfset
    (void *, void *, void *, void **, void **, integral_q, void **, unsigned *,
     void **, void **, void **, void *, void *, void *);
extern int _libx1f4l2_lift_bqpset
    (void *, void *, integral_q *, integral_q **, integral_q **, integral_q,
     void **, unsigned *, integral_q **, integral_q **, integral_q **,
     integral_q *, void *, integral_q);
extern int _libx1f4l2_long_bqfset(void *, void *, void **);
extern int _libx1f4l2_long_bqpset(void *, void *, unsigned);
extern int _libx1f4l2_moon_bqfset
    (void *, unsigned, void *, void *, void **, void *, unsigned);
extern int _libx1f4l2_nand_bqfset
    (void *, unsigned, void *, void *, void **, void *, unsigned);
extern int _libx1f4l2_nine_bqfset
    (void *, integral_q, void **, integral_q, void **, unsigned *, void **,
     void **, void **, integral_q, unsigned *);
extern int _libx1f4l2_nine_bqpset
    (void *, integral_q, integral_q **, integral_q, void **, unsigned *,
     integral_q **, integral_q **, integral_q **, integral_q, unsigned *);
extern int _libx1f4l2_pack_bqfset
    (void *, void *, void *, void **, void **, integral_q, void **, unsigned *,
     void **, void **, void **, void *, void *, void *);
extern int _libx1f4l2_pack_bqpset
    (void *, void *, integral_q *, integral_q **, integral_q **, integral_q,
     void **, unsigned *, integral_q **, integral_q **, integral_q **,
     integral_q *, void *, integral_q);
extern int _libx1f4l2_rail_bqfset
    (void *, unsigned, void *, void *, unsigned, unsigned, integral_q,
     integral_q, integral_q, void *, void *, void *, void *);
extern int _libx1f4l2_root_bqfset(void *, void *, unsigned);
extern int _libx1f4l2_root_bqpset(void *, void *, unsigned);
extern int _libx1f4l2_sand_bqfset
    (void *, unsigned, void *, void **, void **, unsigned *, void *, void **,
     void **, unsigned, void *);
extern int _libx1f4l2_sand_bqpset
    (void *, unsigned, void *, integral_q **, integral_q **, unsigned *,
     integral_q *, integral_q **, integral_q **, unsigned, integral_q);
extern int _libx1f4l2_wave_bqfset
    (void *, unsigned, void *, void *, void **, void *, void *, unsigned);
extern int _libx1f4l2_zero_bqfset
    (void *, void *, void **, void *, integral_q, void **, void **);

#endif				/* __LIBx1f4_bqfx_inter_H__ */
