/*
 * bqfx-defs.h
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_bqfx_defs_H__
#define __LIBx1f4_bqfx_defs_H__

#include <errors.h>

/*
 * attribute bit definitions
 */
#define SIZE_FRAME			(1u << 0x00)
#define TRANS_MASK			(1u << 0x01)

/*
 * error definitions
 */
#define DECK_ERROR			LIBx1f4L2_DECK_ERROR
#define FREE_ERROR			LIBx1f4L2_FREE_ERROR
#define LINK_ERROR			LIBx1f4L2_LINK_ERROR
#define MODE_ERROR			LIBx1f4L2_MODE_ERROR
#define MOVE_ERROR			LIBx1f4L2_MOVE_ERROR
#define TEXT_ERROR			LIBx1f4L2_TEXT_ERROR

/*
 * error definitions (continued)
 */
#define EVER_MATCH			LIBx1f4L2_EVER_MATCH
#define MISS_CLASS			LIBx1f4L2_MISS_CLASS

/*
 * internal error definitions
 */
#define LAST_ERROR			LIBx1f4L2_LAST_ERROR

#endif				/* __LIBx1f4_bqfx_defs_H__ */
