/*
 * bqfv.v.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <xfs.h>
#include <xls.h>

#define __HEAD_LEFT__			1

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#define true(e)				1

#define Q_21_				Q(21)

#define Q_42_				Q(42)

#define Q_63_				Q(63)

#undef Q
#define Q(e)				((integral_q) (e))

#define q_21_				(Q_21_ << (integral_q_bits - 6))

#define q_42_				(Q_42_ << (integral_q_bits - 6))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int edge(void *, unsigned size, unsigned,
		int (*) (void *, void *, unsigned));

static int
edge(void *node, unsigned size, unsigned call,
     int (*move) (void *, void *, unsigned))
{
    integral_q news, slip;

    news = *(integral_q *) node;

    slip = news & ~Lx55555555;

    if (1) {
	if (1) {
	    call++;

	    if (call & 1) {
		*(integral_q *) node = news & ~(Q(1) << call);
	    } else {
		if (0) {
		} else {
		    if (news & (Q(1) << (call - 1))) {
			void **data, *text;

			*(integral_q *) node = news & ~(Q(1) << (call - 1));
			text = HD(node, size, call);
			move(text, life(text, size), 1);
			call--;
			data = ZD(node, size) + call;
			*data = *(data - 1);
		    } else {
			unsigned deck, ever;

			if (0) {
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    text = HD(node, size, call);
				    data = ZD(node, size) + call - 1;
				    for (; ever; ever--) {
					void *trip;

					trip = lola(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data - 2);
					data -= 2;
				    }
				    {
					move(text, life(text, size), 1);
					*data = *(data - 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return 0;
}


int
_libx1f4l2_elif_bqfset(void *bqfset, void *data, void **path, void *club,
		       void **lift, unsigned call, void **lock, void *tier,
		       void *past)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned size;
    void *away, *file, *node;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    file = *lock;

    node = *lift;

    if (1) {
	integral_q pipe;
	unsigned deck;
	void **data, *fast, *side, **text;

	pipe = *(integral_q *) club & ~Lx55555555;

	if (pipe) {
	    integral_q news, slip = Q(2) << 4;

	    news = pipe;

	    if (news & Q_42_) {
		*(integral_q *) club = Lxdddddddd | Q(2);

		if (news & 2) {
		    fast = rule(club, size, 4);

		    side = life(fast, size);

		    move(side, fast, 1);
		    dana(fast, size);
		    skip(side, size);
		} else {
		    fast = road(club, size);

		    if (news & 8) {
			side = life(fast, size);

			move(side, fast, 3);
			fast = rule(fast, size, 4);
			side = rule(side, size, 3);
		    } else {
			side = life(fast, size);

			move(side, fast, 1);
			dana(fast, size);
			skip(side, size);
			move(side, fast, 2);
			dana(fast, size);
			dana(side, size);
		    }
		}
	    } else {
		fast = rule(club, size, 4);

		side = life(fast, size);

		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    news |= Q(1) << (integral_q_bits - 2);
	    news >>= 6;

	    for (; !(news & Q_63_); news >>= 6) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		slip <<= 4;
	    }

	    if (news & ~((Q(1) << 6) - 1)) {
		*(integral_q *) club = Lxdddddddd | slip;

		if (news & 2) {
		    move(side, fast, 3);
		    fast = rule(fast, size, 4);
		    side = rule(side, size, 3);
		    move(side, fast, 1);
		    dana(fast, size);
		    skip(side, size);
		} else {
		    if (news & 8) {
			move(side, fast, 1);
			dana(fast, size);
			skip(side, size);
			move(side, fast, 3);
			fast = rule(fast, size, 4);
			side = rule(side, size, 3);
		    } else {
			move(side, fast, 1);
			dana(fast, size);
			skip(side, size);
			move(side, fast, 1);
			dana(fast, size);
			skip(side, size);
			move(side, fast, 2);
			dana(fast, size);
			dana(side, size);
		    }
		}

		news >>= 6;
	    }

	    for (; !(news & Q_21_); news >>= 6) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    if (news & Q_42_) {
		*(integral_q *) club =
		    Lxdddddddd | Q(2) << (integral_q_bits * 2 / 3 & ~3);

		if (half_integral_q_bits % 3 ^ 2) {
		    move(side, fast, 2);
		    dana(side, size);
		    move(side, *path, 1);

		    fast = file;

		    dana(fast, size);
		    skip(side, size);
		    move(side, fast, 1);
		    skip(side, size);
		} else {
		    move(side, fast, 1);
		    if (news & 2) {
			skip(fast, size);
			skip(side, size);
			move(side, fast, 2);
		    } else {
			dana(fast, size);
			skip(side, size);
			move(side, fast, 2);
		    }

		    dana(side, size);

		    move(side, *path, 1);

		    fast = file;

		    skip(side, size);
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    move(side, fast, 1);
		    dana(side, size);
		    move(side, *path, 1);

		    fast = file;

		    dana(fast, size);
		    skip(side, size);
		    move(side, fast, 1);
		    skip(side, size);
		} else {
		    move(side, fast, 1);
		    dana(fast, size);
		    dana(side, size);
		    move(side, fast, 1);
		    skip(side, size);
		    move(side, *path, 1);

		    fast = file;

		    skip(side, size);
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		dana(fast, size);
		move(side, fast, 1);
		dana(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
	    }

	    dana(fast, size);

	    away = fast;

	    news = pipe;

	    data = ZD(club, size);

	    text = data;

	    data--;

	    news |= Q(1) << (integral_q_bits - 2);

	    for (; !(news & Q_42_); news >>= 6) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (news & ~((Q(1) << 6) - 1)) {
		if (news & 2) {
		    data++;
		    *text = *data;
		    text++;
		    data++;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		} else {
		    if (news & 8) {
			data += 2;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data += 2;
			*text = *data;
			text++;
		    } else {
			data += 2;
			*text = *data;
			text++;
			data += 2;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
		    }
		}

		news >>= 6;
	    }

	    for (; !(news & Q_21_); news >>= 6) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (news & Q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    data++;
		    *text = *data;
		    text++;
		    data++;
		    *text = *data;

		    data = ZD(file, size) + 1;

		    text++;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		} else {
		    if (news & 2) {
			data++;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data += 2;
			*text = *data;
		    } else {
			data += 2;
			*text = *data;
			text++;
			data++;
			*text = *data;
			text++;
			data++;
			*text = *data;
		    }

		    data = ZD(file, size) + 1;

		    text++;
		    *text = *data;
		    text++;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    text++;
		    data += 2;
		    *text = *data;

		    data = ZD(file, size) + 1;

		    text++;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		} else {
		    text++;
		    data += 2;
		    *text = *data;
		    text++;
		    data += 2;
		    *text = *data;

		    data = ZD(file, size) + 1;

		    text++;
		    *text = *data;
		    text++;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }
	} else {
	    *(integral_q *) club = Lxdddddddd;

	    fast = rule(club, size, 4);

	    side = life(fast, size);

	    {
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    deck = integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		move(side, fast, 1);
		dana(side, size);
		move(side, *path, 1);

		fast = file;

		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		skip(side, size);
	    } else {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		skip(side, size);
		move(side, *path, 1);

		fast = file;

		skip(side, size);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		dana(fast, size);
		move(side, fast, 1);
		dana(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
	    }

	    dana(fast, size);

	    away = fast;

	    data = ZD(club, size);

	    text = data;

	    data--;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    } else {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }
	}
    }

    if (1) {
	unsigned deck;
	void **data, *fast, *side, **text;

	if (0) {
	} else {
	    data = ZD(tier, size) + integral_q_bits;

	    text = data;

	    data++;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    } else {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    fast = rule(tier, size, integral_q_bits);

	    side = fast;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		fast = rule(file, size, integral_q_bits - 2);

		posh(side, size);
		move(side, past, 1);
		posh(side, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    } else {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		move(side, past, 1);

		fast = rule(file, size, integral_q_bits - 2);

		beta(side, size);
		move(side, fast, 1);
	    }

	    if (0) {
	    } else {
		move(*path, away, 1);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
	    }

	    *(integral_q *) tier = Lxdddddddd;
	}
    }

    if (1) {
	if (0) {
	} else {
	    edge(node, size, call, move);

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		if (0) {
		} else {
		    *path = HD(node, size, integral_q_bits - 2);

		    *lock = tier;
		}
	    }
	}
    }

    return status;
}
