/*
 * bqfv.u.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <xfs.h>
#include <xls.h>

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define cell(___s, ___n, ___t) \
    ((char *) (___s) - (___n) * (___t))

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#define true(e)				1

#define Q_21_				Q(21)

#define Q_42_				Q(42)

#define Q_63_				Q(63)

#undef Q
#define Q(e)				((integral_q) (e))

#define q_21_				(Q_21_ << (integral_q_bits - 6))

#define q_42_				(Q_42_ << (integral_q_bits - 6))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int east(void *, unsigned size, unsigned, unsigned *,
		int (*) (void *, void *, unsigned));

static int
east(void *node, unsigned size, unsigned call, unsigned *fare,
     int (*move) (void *, void *, unsigned))
{
    integral_q news, slip;

    news = *(integral_q *) node;

    slip = news & ~Lx55555555;

    if (1) {
	if (1) {
	    call++;

	    if (call & 1) {
		void *text;

		*(integral_q *) node = news & ~(Q(1) << call);

		*fare = call - 2;

		text = rule(node, size, call);
		move(life(text, size), text, 1);
	    } else {
		if (news & (Q(1) << (call - 1))) {
		    void **data;

		    *(integral_q *) node = news & ~(Q(1) << (call - 1));
		    call--;
		    data = ZD(node, size) + call;
		    *data = *(data - 1);

		    *fare = call;
		} else {
		    if (news & (Q(1) << (call + 1))) {
			*fare = call - 3;

			*(integral_q *) node = news & ~(Q(1) << (call + 1));
			if (true(call ^ 2)) {
			    void **data, *text;

			    text = rule(node, size, call);
			    move(lola(text, size), text, 1);
			    move(text, sans(text, size), 1);
			    data = ZD(node, size) + call;
			    *(data - 1) = *data;
			} else {
			    void **data, *text;

			    /* is this ever reached? */
			    text = rule(node, size, call);
			    move(text, sans(text, size), 1);
			    data = ZD(node, size) + call;
			    *(data - 1) = *data;
			}
		    } else {
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << call);
			if (1) {
			    l2_q_xfs(ever, back);
			    if (0) {
			    } else {
				if (true(call ^ 2)) {
				    void **data, *text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call -= 2;
				    *fare = call - 1;
				    text = HD(node, size, call);
				    data = ZD(node, size) + call + 1;
				    for (; deck; deck--) {
					void *trip;

					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data + 2);
					data += 2;
				    }
				    {
					void *trip;

					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				} else {
				    void **data, *text;

				    /* is this ever reached? */
				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    *fare = call - 2;
				    text = HD(node, size, call) + 1;
				    data = ZD(node, size) + call;
				    for (; deck; deck--) {
					void *trip;

					*data = *(data + 2);
					data += 2;
					trip = road(text, size);
					move(text, trip, 1);
					text = trip;
				    }
				    {
					*data = *(data + 1);
					move(text, sans(text, size), 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return 0;
}


int
_libx1f4l2_else_bqfset(void *bqfset, void *head, void *club, void **lift,
		       unsigned call, void **lock, void *tier, void **turn,
		       void *text)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned size;
    void *away, *file, *node;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    file = *lock;

    node = *lift;

    if (1) {
	unsigned deck;
	void **data, *fast, *side, **text;

	if (0) {
	} else {
	    *(integral_q *) club = Lxdddddddd;

	    fast = rule(club, size, 4);

	    side = life(fast, size);

	    {
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    deck = integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		move(side, fast, 1);
		dana(side, size);
		move(side, head, 1);

		fast = file;

		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		skip(side, size);
	    } else {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		skip(side, size);
		move(side, head, 1);

		fast = file;

		skip(side, size);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		dana(fast, size);
		move(side, fast, 1);
		dana(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
	    }

	    dana(fast, size);

	    away = fast;

	    data = ZD(club, size);

	    text = data;

	    data--;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    } else {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }
	}
    }

    if (1) {
	integral_q pipe;
	unsigned deck;
	void **data, *fast, *side, **text;

	pipe = *(integral_q *) tier & ~Lx55555555;

	if (pipe) {
	    integral_q news, slip = Q(2) << (integral_q_bits - 4);

	    news = pipe;

	    data = ZD(tier, size) + integral_q_bits;

	    text = data;

	    data++;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (news & q_21_) {
	    } else {
		if (news & Q(1) << (integral_q_bits - 1)) {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    } else {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
			data++;
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (news & q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		} else {
		    text--;
		    data -= 2;
		    *text = *data;
		    if (news & Q(1) << (integral_q_bits - 1)) {
			text--;
			data--;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    } else {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    }

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    text--;
		    data -= 2;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		} else {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    news = pipe;

	    fast = rule(tier, size, integral_q_bits);

	    side = fast;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
		slip >>= 4;
	    }

	    if (news & q_21_) {
	    } else {
		*(integral_q *) tier = Lxdddddddd | slip;

		if (news & Q(1) << (integral_q_bits - 1)) {
		    beta(side, size);
		    beta(fast, size);
		    move(side, fast, 2);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			side = cell(side, size, 3);
			fast = cell(fast, size, 4);
			move(side, fast, 3);
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);
		    } else {
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);
			side = cell(side, size, 3);
			fast = cell(fast, size, 4);
			move(side, fast, 3);
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    if (news & q_42_) {
		*(integral_q *) tier =
		    Lxdddddddd | Q(2) << (integral_q_bits / 3 & ~3);

		if (half_integral_q_bits % 3 ^ 2) {
		    posh(side, size);
		    posh(fast, size);
		    move(side, fast, 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, *turn, 1);
		    posh(side, size);
		    move(side, fast, 1);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    posh(side, size);
		    if (news & Q(1) << (integral_q_bits - 1)) {
			beta(fast, size);
			posh(side, size);
			move(side, fast, 2);
		    } else {
			fast = cell(fast, size, 3);
			posh(side, size);
			move(side, fast, 2);
		    }

		    posh(side, size);
		    move(side, *turn, 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, fast, 1);
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, *turn, 1);
		    posh(side, size);
		    move(side, fast, 1);
		    beta(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		    posh(side, size);
		    move(side, *turn, 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    beta(side, size);
		    move(side, fast, 1);
		}
	    }

	    if (1) {
		move(*turn, away, 1);
	    } else {
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }
	} else {
	    data = ZD(tier, size) + integral_q_bits;

	    text = data;

	    data++;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    } else {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    fast = rule(tier, size, integral_q_bits);

	    side = fast;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		fast = rule(file, size, integral_q_bits - 2);

		posh(side, size);
		move(side, *turn, 1);
		posh(side, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    } else {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		move(side, *turn, 1);

		fast = rule(file, size, integral_q_bits - 2);

		beta(side, size);
		move(side, fast, 1);
	    }

	    if (1) {
		move(*turn, away, 1);
	    } else {
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
	    }

	    *(integral_q *) tier = Lxdddddddd;
	}
    }

    if (1) {
	if (1) {
	    east(node, size, call, &call, move);

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		if (0) {
		} else {
		    *lock = club;

		    if (1) {
			if (status ^ (LAST_ERROR + call + 2)) {
			    *turn = HD(node, size, call + 1);
			} else {
			    if (call ^ (integral_q_bits - 3)) {
				*turn = HD(node, size, call + 3);
			    } else {
				*turn = text;
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}
