/*
 * bqfv.s.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define cell(___s, ___n, ___t) \
    ((char *) (___s) - (___n) * (___t))

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#define Q_21_				Q(21)

#define Q_42_				Q(42)

#define Q_63_				Q(63)

#undef Q
#define Q(e)				((integral_q) (e))

#define q_21_				(Q_21_ << (integral_q_bits - 6))

#define q_42_				(Q_42_ << (integral_q_bits - 6))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_fair_bqfset(void *bqfset, unsigned mind, void *node, void *club,
		       void *file, void **turn, void *tier, unsigned rate)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned size;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    if (1) {
	unsigned deck;
	void **data, *fast, *side, **text;

	if (0) {
	} else {
	    *(integral_q *) club = Lxdddddddd;

	    fast = rule(club, size, 4);

	    side = life(fast, size);

	    {
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    deck = integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		dana(fast, size);
		skip(side, size);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		move(side, fast, 1);
		dana(side, size);
		move(side, rule(node, size, 1), 1);

		fast = file;

		dana(fast, size);
		skip(side, size);
		move(side, fast, 1);
		skip(side, size);
	    } else {
		move(side, fast, 1);
		dana(fast, size);
		dana(side, size);
		move(side, fast, 1);
		skip(side, size);
		move(side, rule(node, size, 1), 1);

		fast = file;

		skip(side, size);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		dana(fast, size);
		move(side, fast, 1);
		dana(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
		dana(fast, size);
		move(side, fast, 1);
		skip(side, size);
	    }

	    dana(fast, size);

	    move(rule(node, size, 1), fast, 1);

	    data = ZD(club, size);

	    text = data;

	    data--;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    } else {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;

		data = ZD(file, size) + 1;

		text++;
		*text = *data;
		text++;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
		data += 2;
		*text = *data;
		text++;
	    }
	}
    }

    if (1) {
	integral_q pipe;
	unsigned deck;
	void **data, *fast, *side, **text;

	pipe = *(integral_q *) tier & ~Lx55555555;

	if (pipe) {
	    integral_q news, slip = Q(2) << (integral_q_bits - 4);

	    news = pipe;

	    data = ZD(tier, size) + integral_q_bits;

	    text = data;

	    data++;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (news & q_21_) {
	    } else {
		if (news & Q(1) << (integral_q_bits - 1)) {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    } else {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
			data++;
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (news & q_42_) {
		if (half_integral_q_bits % 3 ^ 2) {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data--;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		} else {
		    text--;
		    data -= 2;
		    *text = *data;
		    if (news & Q(1) << (integral_q_bits - 1)) {
			text--;
			data--;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    } else {
			text--;
			data -= 2;
			*text = *data;
			text--;
			data--;
			*text = *data;
		    }

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    text--;
		    data -= 2;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		} else {
		    text--;
		    data -= 2;
		    *text = *data;
		    text--;
		    data -= 2;
		    *text = *data;

		    data = ZD(file, size) + integral_q_bits - 1;

		    text--;
		    *text = *data;
		    text--;
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    news = pipe;

	    fast = rule(tier, size, integral_q_bits);

	    side = fast;

	    news |= Q(1);

	    for (; !(news & q_42_); news <<= 6) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
		slip >>= 4;
	    }

	    if (news & q_21_) {
	    } else {
		*(integral_q *) tier = Lxdddddddd | slip;

		if (news & Q(1) << (integral_q_bits - 1)) {
		    beta(side, size);
		    beta(fast, size);
		    move(side, fast, 2);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    if (news & Q(1) << (integral_q_bits - 3)) {
			side = cell(side, size, 3);
			fast = cell(fast, size, 4);
			move(side, fast, 3);
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);
		    } else {
			posh(side, size);
			beta(fast, size);
			move(side, fast, 1);
			side = cell(side, size, 3);
			fast = cell(fast, size, 4);
			move(side, fast, 3);
		    }
		}

		news <<= 6;
	    }

	    for (; !(news & q_21_); news <<= 6) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    if (news & q_42_) {
		*(integral_q *) tier =
		    Lxdddddddd | Q(2) << (integral_q_bits / 3 & ~3);

		if (half_integral_q_bits % 3 ^ 2) {
		    posh(side, size);
		    posh(fast, size);
		    move(side, fast, 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, rule(node, size, 2), 1);
		    posh(side, size);
		    move(side, fast, 1);
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    posh(side, size);
		    if (news & Q(1) << (integral_q_bits - 1)) {
			beta(fast, size);
			posh(side, size);
			move(side, fast, 2);
		    } else {
			fast = cell(fast, size, 3);
			posh(side, size);
			move(side, fast, 2);
		    }

		    posh(side, size);
		    move(side, rule(node, size, 2), 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, fast, 1);
		}
	    } else {
		if (half_integral_q_bits % 3 ^ 2) {
		    fast = rule(file, size, integral_q_bits - 2);

		    posh(side, size);
		    move(side, rule(node, size, 2), 1);
		    posh(side, size);
		    move(side, fast, 1);
		    beta(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		} else {
		    posh(side, size);
		    beta(fast, size);
		    move(side, fast, 1);
		    posh(side, size);
		    move(side, rule(node, size, 2), 1);

		    fast = rule(file, size, integral_q_bits - 2);

		    beta(side, size);
		    move(side, fast, 1);
		}
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }
	} else {
	    data = ZD(tier, size) + integral_q_bits;

	    text = data;

	    data++;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    } else {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;

		data = ZD(file, size) + integral_q_bits - 1;

		text--;
		*text = *data;
		text--;
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 1;
	    for (; deck; deck--) {
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
		data -= 2;
		*text = *data;
		text--;
	    }

	    fast = rule(tier, size, integral_q_bits);

	    side = fast;

	    deck = integral_q_bits / 6;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    if (half_integral_q_bits % 3 ^ 2) {
		fast = rule(file, size, integral_q_bits - 2);

		posh(side, size);
		move(side, rule(node, size, 2), 1);
		posh(side, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    } else {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		move(side, rule(node, size, 2), 1);

		fast = rule(file, size, integral_q_bits - 2);

		beta(side, size);
		move(side, fast, 1);
	    }

	    deck = integral_q_bits / 4 - integral_q_bits / 6 - 2;
	    for (; deck; deck--) {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
		beta(fast, size);
		move(side, fast, 1);
	    }

	    {
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		posh(side, size);
		beta(fast, size);
		move(side, fast, 1);
		beta(side, size);
	    }

	    *(integral_q *) tier = Lxdddddddd;
	}
    }

    if (2) {
	if (1) {
	    void *side, **trap;

	    trap = MD(node, size) + 1;

	    mind--;

	    memmove(trap, trap + 1, mind * sizeof(void *));

	    side = rule(node, size, 2);

	    move(side, sans(side, size), mind);

	    *(integral_q *) node = mind;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;

		/*
		 * TODO
		 *
		 * restore state
		 */
	    } else {
		if (1) {
		    *turn = rule(node, size, 1);
		}
	    }
	}
    }

    return status;
}
