/*
 * bqfv.h.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_moon_bqfset(void *bqfset, unsigned mind, void *node, void *club,
		       void **path, void *file, unsigned rate)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned hold = 0, size;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    file = MD(node, size)[mind];

    if (0) {
    } else {
	integral_q lack, last;
	unsigned deck;

	if (1) {
	    last = *(integral_q *) club & ~Lx55555555;
	    if (last) {
		if (last & (last - 1)) {
		    deck = 4;
		} else {
		    if (0) {
		    } else {
			if (mind ^ 1) {
			    deck = 4;
			} else {
			    deck = 1;
			}
		    }
		}

		lack = last;
	    } else {
		deck = 0;
		if (0) {
		} else {
		    if (mind ^ 1) {
			lack = *(integral_q *) MD(node, size)[mind - 2]
			    & ~Lx55555555;
			if (lack) {
			    if (mind - 2) {
				deck = 4;
			    } else {
				if (lack & (lack - 1)) {
				    deck = 4;
				}
			    }

			    hold = 2;
			    lack = Q(1) << integral_q_last;
			} else {
			    lack = last;
			}
		    } else {
			lack = last;
		    }
		}
	    }
	} else {
	}

	if (lack) {
	    if (deck & 4) {
		status = 0;

		if (0) {
		} else {
		    integral_q text;
		    unsigned call;
		    void *data, *fast, **side, *tier = NULL;

		    if (0) {
		    } else {
			/* _*path_ is _rule(node, size, mind)_ */
			move(sans(file, size), *path, 1);
		    }

		    if (hold) {
			unsigned ever;

			tier = club;

			club = MD(node, size)[mind - 2];

			last = *(integral_q *) club & ~Lx55555555;

			call = mind - 1;

			fast = rule(tier, size, integral_q_bits - 2);

			move(rule(node, size, mind), fast, 1);

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    void *this;

			    this = lola(fast, size);
			    move(fast, this, 1);
			    fast = this;
			}
			{
			    move(fast, rule(node, size, call), 1);
			}
		    } else {
			call = mind;
		    }

		    text = last;

		    if (text & Q(1) << integral_q_last) {
			move(rule(node, size, call),
			     rule(club, size, integral_q_last), 1);

			side = ZD(club, size) + integral_q_bits - 1;

			data = *side;
			*side = *(side - 1);

			*(integral_q *) club = Lx55555555
			    | (last ^ Q(1) << integral_q_last);
		    } else {
			fast = rule(club, size, integral_q_bits - 2);

			side = ZD(club, size) + integral_q_bits - 1;

			move(rule(node, size, call), fast, 1);

			data = *side;

			text <<= 2;

			for (; !(text & Q(1) << integral_q_last); text <<= 2) {
			    void *this;

			    this = lola(fast, size);
			    move(fast, this, 1);
			    fast = this;
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    move(fast, life(fast, size), 1);
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 1);
			}

			*(integral_q *) club = Lx55555555
			    | (last ^ Q(1) << (side - ZD(club, size)));
		    }

		    if (hold) {
			unsigned ever;
			void *sail;

			side = ZD(tier, size) + integral_q_bits - 1;

			sail = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = sail;
			}
		    }

		    *(integral_q *) file = Lx55555555 | 2;

		    if (0) {
		    } else {
			side = ZD(file, size);

			{
			    *side = data;
			}
		    }
		}
	    } else {
		if (mind ^ 1) {
		    void *tier;

		    if (1) {
			if (0) {
			} else {
			    tier = file;
			    file = club;
			    club = MD(node, size)[mind - 2];
			    *path = rule(node, size, mind - 1);
			}
		    } else {
		    }

		    status = _libx1f4l2_wave_bqfset
			(bqfset, mind, node, club, path, file, tier,
			 rate);
		    if (status) {
		    } else {
			status = LAST_ERROR + integral_q_bits;
		    }
		} else {
#if 0
		    status = 0;
		    if (1) {
			*sign = hold;
		    }
#else
		    status = _libx1f4l2_root_bqfset(bqfset, node, rate);
#endif				/* 0 */
		}
	    }
	} else {
	    status = _libx1f4l2_nand_bqfset
		(bqfset, mind, node, club, path, file, rate);
	    if (status) {
	    } else {
		status = LAST_ERROR + integral_q_bits;
	    }
	}
    }

    return status;
}
