/*
 * bqfv.g.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_dawn_bqfset(void *bqfset, unsigned mind, void *node, void *file,
		       void **turn, void *tier, unsigned rate)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned hold = 0, size;
    void *club = NULL;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    file = MD(node, size)[0];

    if (0) {
    } else {
	integral_q lack, next;
	unsigned ever;

	if (0) {
	} else {
	    next = *(integral_q *) tier & ~Lx55555555;
	    if (next) {
		if (mind ^ 1) {
		    ever = 4;
		} else {
		    if (next & (next - 1)) {
			ever = 4;
		    } else {
			ever = 1;
		    }
		}

		lack = next;
	    } else {
		ever = 0;
		if (mind ^ 1) {
		    lack = *(integral_q *) MD(node, size)[2] & ~Lx55555555;
		    if (lack) {
			if (mind ^ 2) {
			    ever = 4;
			} else {
			    if (lack & (lack - 1)) {
				ever = 4;
			    }
			}

			hold = 1;
			lack = Q(1) << integral_q_last;
		    } else {
			lack = next;
		    }
		} else {
		    lack = next;
		}
	    }
	}

	if (lack) {
	    if (ever & 4) {
		status = 0;

		if (1) {
		    integral_q text;
		    unsigned call;
		    void *data, *fast, **side;

		    if (0) {
		    } else {
			/* _*turn_ is _rule(node, size, pick + 1)_ */
			move(rule(file, size, integral_q_last), *turn, 1);
		    }

		    if (hold) {
			club = tier;

			tier = MD(node, size)[2];

			next = *(integral_q *) tier & ~Lx55555555;

			call = 2;

			fast = road(club, size);

			move(rule(node, size, 1), fast, 1);

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    void *this;

			    this = road(fast, size);
			    move(fast, this, 1);
			    fast = this;
			}
			{
			    move(fast, rule(node, size, call), 1);
			}
		    } else {
			call = 1;
		    }

		    fast = tier;

		    text = next;
		    text &= (text - 1) << 1;

		    *(integral_q *) fast = Lx55555555 | (next & ~text);

		    text >>= 2;
		    if (text) {
			dana(fast, size);

			side = ZD(tier, size) + 1;

			move(rule(node, size, call), fast, 1);

			data = *side;

			text >>= 2;

			for (; text; text >>= 2) {
			    void *this;

			    this = road(fast, size);
			    move(fast, this, 1);
			    fast = this;
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    move(fast, sans(fast, size), 1);
			}
			{
			    *side = *(side + 1);
			}
		    } else {
			move(rule(node, size, call), sans(fast, size), 1);

			data = *ZD(tier, size);
		    }

		    if (hold) {
			void *sail;

			side = ZD(club, size) + 1;

			sail = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *side = sail;
			}
		    }

		    *(integral_q *) file =
			Lx55555555 | Q(1) << integral_q_last;

		    if (0) {
		    } else {
			side = ZD(file, size) + integral_q_last;

			{
			    *(side - 1) = *side;
			}

			{
			    *side = data;
			}
		    }
		} else {
		}
	    } else {
		if (mind ^ 1) {
		    void *club;

		    if (0) {
		    } else {
			club = file;
			file = tier;
			tier = MD(node, size)[2];
			*turn = rule(node, size, 2);
		    }

		    status = _libx1f4l2_fair_bqfset
			(bqfset, mind, node, club, file, turn, tier, rate);
		    if (status) {
		    } else {
			status = LAST_ERROR + integral_q_bits;
		    }
		} else {
#if 0
		    status = 0;
		    if (1) {
			*sign = hold;
		    }
#else
		    status = _libx1f4l2_root_bqfset(bqfset, node, rate);
#endif				/* 0 */
		}
	    }
	} else {
	    status = _libx1f4l2_here_bqfset
		(bqfset, mind, node, file, turn, tier, rate);
	    if (status) {
	    } else {
		status = LAST_ERROR + integral_q_bits;
	    }
	}
    }

    return status;
}
