/*
 * bqfv.9.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bcount.h>
#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <reverse.h>
#include <xfs.h>
#include <xls.h>

#define __HALF_TRANSFER__		1

#define __FINE_EXCESS__			1
#define __FINE_SECOND__			2
#define __FINE_SELECT__			3
#define __FINE_TARGET__			4

#define __FINE_METHOD__			__FINE_EXCESS__

#define ____FINE_METHOD__		__FINE_METHOD__

#define __LOSE_DOUBLE__			1

#define __LOSE_METHOD__			__LOSE_DOUBLE__

#define __UNROLL_TRANSFER__		0

#define __HEAD_LEFT__			1

#define FINE_ERROR			(LAST_ERROR + 8)

#define false(e)			0

#define here_two_test(___h) \
    ((___h) & 8192)

#undef here_two_test

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_l_count(___h, ___e) \
    ___n = (___e) & ~Lx55555555;					      \
    ___p = (___n | ___n >> (half_integral_q_bits + 1))			      \
	& ((Q(1) << half_integral_q_bits) - 1);				      \
    if (1) {								      \
	___t = 1024;							      \
    }
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_n_reset(___h)
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_declarations \
    integral_q ___n, ___p, ___t
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_setup(___f, ___g) \
    l2_q_heap_1up(___p);						      \
									      \
    ___p &= Q(0xff) | Q(0xff) << half_integral_q_bits;			      \
									      \
    ___p |= ___t;							      \
    ___p |=								      \
	((___p								      \
	  - ((___t & (Q(1024) | Q(1024) << half_integral_q_bits)) >> 10))     \
	 & (Q(1024) | Q(1024) << half_integral_q_bits)) << 3;		      \
									      \
    (___f) = ___p & ((Q(1) << half_integral_q_bits) - 1)
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#define here_two_test(___h) \
    ((___h) & 8192)

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define cell(___s, ___n, ___t) \
    ((char *) (___s) - (___n) * (___t))

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#define trap(___n, ___s)		((___n) + ((___s) << 2))

#define true(e)				1

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int clip(void *, void *, unsigned);
static int edge(void *, unsigned, unsigned,
		int (*) (void *, void *, unsigned));
static int fine(void *, unsigned, void *);
static int lose(void *, unsigned, void *, void *, unsigned, unsigned);
static int miss(void *, void *, unsigned, unsigned);
static int shut(void *, void *, unsigned, unsigned);

static int
clip(void *bqfset, void *node, unsigned size)
{
    int status;
    unsigned mind;

    mind = *(integral_q *) node;
    if (mind) {
	mind--;
	*((integral_q *) node) = mind;
	status = 0;
    } else {
	status = DECK_ERROR;
    }

    return status;
}


static int
edge(void *node, unsigned size, unsigned call,
     int (*move) (void *, void *, unsigned))
{
    integral_q news, slip;

    news = *(integral_q *) node;

    slip  = news & ~Lx55555555;

    {
	if (1) {
	    call++;

	    if (call & 1) {
		*(integral_q *) node = news & ~(Q(1) << call);
	    } else {
		if (news & (Q(1) << (call - 1))) {
		    *(integral_q *) node = news & ~(Q(1) << (call - 1));
		    if (2) {
			void *data, **text;

			data = HD(node, size, call);
			move(data, life(data, size), 1);
			call--;
			text = ZD(node, size) + call;
			*text = *(text - 1);
		    }
		} else {
		    if (0) {
		    } else {
			unsigned deck, ever;

			if (0) {
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    void *data, **text;

				    *(integral_q *) node =
					news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    data = rule(node, size, call);
				    call--;
				    text = ZD(node, size) + call;
				    for (; ever; ever--) {
					void *trip;

					trip = lola(data, size);
					move(data, trip, 1);
					data = trip;
					*text = *(text - 2);
					text -= 2;
				    }
				    {
					move(data, life(data, size), 1);
					*text = *(text - 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return 0;
}


static int
fine(void *bqfset, unsigned size, void *node)
{
    int status;

    do {
	integral_q news;

	news = *(integral_q *) node;

	if (news & Q(1) << integral_q_last) {
	    status = 0;

	    *(integral_q *) node = news & ~(Q(1) << integral_q_last);

	    if (1) {
		break;
	    }
	} else {
	}
	{
	    integral_q slip;

	    slip = news & ~Lx55555555;
	    if (slip) {
		int (*move) (void *, void *, unsigned);
		void *fast;

		move = bqfset(bqfset)->link_f.move;

		status = 0;

		fast = rule(node, size, integral_q_bits - 2);

		if (news & Q(1) << (integral_q_bits - 3)) {
		    *(integral_q *) node =
			news & ~(Q(1) << (integral_q_bits - 3));
		    move(fast, life(fast, size), 1);
		} else {
		    if (0) {
		    } else {
#if ____FINE_METHOD__ == __FINE_SELECT__
#elif __FINE_METHOD__ == __FINE_EXCESS__
			integral_q last;
			unsigned copy = integral_q_bits - 2;

			last = slip << 2;
			if (1) {
			    size <<= 1;
			    for (; !(last & Q(15) << (integral_q_bits - 4));
				 last <<= 4) {
				void *side;

				side = (char *) fast - size;
				move(fast, side, 1);
				fast = (char *) side - size;
				move(side, fast, 1);

				copy -= 4;
			    }
			    if (!(last & Q(3) << (integral_q_bits - 2))) {
				void *side;

				side = (char *) fast - size;
				move(fast, side, 1);
				fast = side;

				copy -= 2;
			    }
			    size >>= 1;
			    {
				move(fast, (char *) fast - size, 1);
			    }

			    *(integral_q *) node = news ^ (Q(1) << (copy - 1));
			} else {
			}
#elif __FINE_METHOD__ == __FINE_SECOND__
#elif __FINE_METHOD__ == __FINE_TARGET__
#endif				/* ____FINE_METHOD__ == __FINE_SELECT__ */
		    }
		}
	    } else {
		*(integral_q *) node = news & ~(Q(1) << (integral_q_bits - 2));
		if (1) {
		    status = FINE_ERROR + integral_q_bits - 2;
		}
	    }
	}
    } while (0);

    return status;
}


static int
lose(void *bqfset, unsigned size, void *path, void *high, unsigned pass,
     unsigned rate)
{
    integral_q pipe;
    void *file, *node;
    int status;

    node = ZD(high, size)[pass];

    pipe = *(integral_q *) node;

    while (1) {
	file = ZD(node, size)[integral_q_last];

	if (rate) {
	    integral_q lane;

	    lane = *(integral_q *) file;

	    if (lane & ~Lx55555555) {
		high = node;

		node = file;

		pipe = lane;

		rate = rate - 1;
	    } else {
		void *club, *head;

		if (1) {
		    if (pipe & (Q(1) << integral_q_last)) {
			club = ZD(node, size)[integral_q_last - 1];
			head = HD(node, size, integral_q_last);
		    } else {
			if (1) {
			    club = ZD(node, size)[integral_q_last - 2];
			    head = HD(node, size, integral_q_last - 1);
			} else {
			}
		    }
		} else {
		}

		status = _libx1f4l2_zero_bqfset
		    (bqfset, path, &head, club, pipe, &node, &file);
		if (status == FREE_ERROR) {
		    break;
		} else {
		}

		path = head;

		high = node;

		node = file;

		pipe = *(integral_q *) file;

		rate = rate - 1;
	    }
	} else {
	    status = fine(bqfset, size, file);
	    if (status) {
		if (0) {
		} else {
		    int (*move) (void *, void *, unsigned);
		    integral_q last;
		    unsigned deck, ever;
		    void *club, *head, *past;

		    move = bqfset(bqfset)->link_f.move;

		    if (1) {
			if (pipe & (Q(1) << integral_q_last)) {
			    club = ZD(node, size)[integral_q_last - 1];
			    head = HD(node, size, integral_q_last);
			} else {
			    if (1) {
				club = ZD(node, size)[integral_q_last - 2];
				head = HD(node, size, integral_q_last - 1);
			    } else {
			    }
			}
			if (0) {
			} else {
			}
		    } else {
		    }

		    status = 0;

		    {
			here_two_declarations;

			if (1) {
			    last = *(integral_q *) club;
			    here_two_l_count(deck, last);
			} else {
			}

			if (0) {
			} else {
			    here_two_n_reset(ever);
			}

			here_two_setup(deck, ever);
		    }

		    if (here_two_test(deck)) {
			if (0) {
			} else {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q text;
				unsigned slip;
				void *fast, *side;

				fast = rule(file, size, integral_q_bits - 2);

				ever = (integral_q_bits - 4) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				if (ever & 1) {
				    side = lola(fast, size);
				    move(fast, side, 1);
				    fast = side;
				}
				ever >>= 1;
				for (; ever; ever--) {
				    side = lola(fast, size);
				    move(fast, side, 1);
				    fast = lola(side, size);
				    move(side, fast, 1);
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				deck &= 254;

				if (deck < 4) {
				    deck = 1;

				    *(integral_q *) fast = Lx55555555;

				    dana(fast, size);
				} else {
				    *(integral_q *) fast = Lx55555555
					| ((Q(1) << (deck - 2)) - 1);

				    if (deck < 8) {
					deck >>= 1;

					fast = rule(fast, size, deck);
				    } else {
					fast = rule(fast, size, deck - 3);

					side = life(fast, size);

					deck >>= 1;

					ever = deck - 3;
					for (; ever; ever--) {
					    move(fast, side, 1);
					    beta(side, size);
					    posh(fast, size);
					}
				    }
				}

				move(fast, head, 1);

				posh(fast, size);

				deck--;

				text = *(integral_q *) club;

				side = rule(club, size, integral_q_bits);

				while (deck & ~1) {
				    if (text & Q(1) << integral_q_last) {
					beta(side, size);
					posh(fast, size);
					move(fast, side, 2);
					posh(fast, size);

					deck -= 2;
				    } else {
					deck--;

					beta(side, size);
					move(fast, side, 1);
					posh(fast, size);
				    }

				    text <<= 2;
				}
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					posh(side, size);
					move(fast, side, 1);
					posh(side, size);
					move(head, side, 1);

					deck = 0;
				    } else {
					beta(side, size);
					move(fast, side, 1);
				    }

				    text <<= 2;
				} else {
				    deck = 1;
				}
				slip = integral_q_bits - 2;
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					posh(side, size);
					move(head, side, 1);

					posh(side, size);

					fast =
					    rule(club, size,
						 integral_q_bits - 2);

					text <<= 1;
				    } else {
					beta(side, size);
					move(head, side, 1);

					posh(side, size);

					fast =
					    rule(club, size,
						 integral_q_bits - 2);

					text <<= 2;

					if (side < fast) {
					    if (text
						& Q(1) << integral_q_last) {
						move(fast, side, 1);
						beta(fast, size);
						slip -= 2;
					    }

					    posh(side, size);

					    text <<= 1;
					}
				    }
				} else {
				    posh(side, size);

				    fast =
					rule(club, size, integral_q_bits - 2);

				    if (side < fast) {
					if (text & Q(1) << integral_q_last) {
					    move(fast, side, 1);
					    beta(fast, size);
					    slip -= 2;
					}

					posh(side, size);

					text <<= 1;
				    }
				}
				while (side < fast) {
				    if (text & Q(1) << (integral_q_bits - 2)) {
					move(fast, side, 1);
					beta(fast, size);
					posh(side, size);
					move(fast, side, 1);
					beta(fast, size);
					posh(side, size);
					slip -= 4;
				    } else {
					move(fast, side, 1);
					beta(fast, size);
					beta(side, size);
					slip -= 2;
				    }

				    text <<= 2;
				}

				*(integral_q *) club = Lx55555555
				    | text >> (integral_q_last - slip);
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			}
		    } else {
			do {
			    unsigned call = integral_q_last;
			    void *fast, *tier = NULL;

			    if (0) {
			    } else {
				if (1) {
				    unsigned copy = integral_q_bits - 2;

				    past = head;

				    _libx1f4l2_nine_bqfset
					(bqfset, last, &club, pipe, &node,
					 &call, &head, &file, &tier, 0, &copy);
				    if (tier) {
				    } else {
					break;
				    }
				}
			    }

			    {
				void *side;

				fast = club;

				*(integral_q *) club =
				    Lxdddddddd ^ Q(1) << integral_q_last;

				if (0) {
				} else {
				    fast = rule(fast, size, 4);

				    side = life(fast, size);

				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				deck = (integral_q_bits - 6) / 6;
				for (; deck; deck--) {
				    move(side, fast, 1);
				    dana(fast, size);
				    dana(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					move(side, fast, 1);

					fast = file;

					dana(fast, size);
					dana(side, size);
					move(side, head, 1);
					skip(side, size);
					move(side, fast, 1);
					skip(side, size);
				    } else {
					move(side, fast, 1);
					dana(fast, size);
					dana(side, size);
					move(side, fast, 1);

					fast = file;

					skip(side, size);
					move(side, head, 1);
					skip(side, size);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				}

				{
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				}

				fast = rule(tier, size, integral_q_bits);

				side = fast;

				deck = integral_q_bits / 6;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					fast =
					    rule(file, size,
						 integral_q_bits - 4);

					posh(side, size);
					move(side, past, 1);
					posh(side, size);
					move(side, fast, 1);
					beta(side, size);
					beta(fast, size);
					move(side, fast, 1);
				    } else {
					posh(side, size);
					beta(fast, size);
					move(side, fast, 1);

					fast =
					    rule(file, size,
						 integral_q_bits - 4);

					posh(side, size);
					move(side, past, 1);
					beta(side, size);
					move(side, fast, 1);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				{
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				*(integral_q *) tier = Lxdddddddd;
			    }

			    if (1) {
				int excess;

				move(head, cell(fast, size, 2), 1);

				status = edge(node, size, call, move);

				excess = bqfset(bqfset)->link_m.free
				    (bqfset(bqfset)->link_m.data, file);
				if (excess) {
				    status = FREE_ERROR;
				}
			    } else {
			    }
			} while (0);
		    }
		}
	    }

	    break;
	}
    }

    return status;
}


static int
miss(void *bqfset, void *node, unsigned size, unsigned rate)
{
    int status;

    if (1) {
	unsigned mind;
	void *head;

	mind = *(integral_q *) node;

	if (1) {
	    head = rule(node, size, mind);
	} else {
	}

	do {
	    void *file;

	    file = MD(node, size)[mind];

	    if (*(integral_q *) file & ~Lx55555555) {
	    } else {
		status = _libx1f4l2_moon_bqfset
		    (bqfset, mind, node, MD(node, size)[mind - 1], &head, file,
		     rate);
		if (status) {
		    if (status < LAST_ERROR) {
			break;
		    } else {
			if (status ^ (LAST_ERROR + integral_q_bits)) {
			    status = shut
				(bqfset, bqfset(bqfset)->link_a.fpnews.node,
				 size, rate);

			    break;
			} else {
			    mind--;

			    file = MD(node, size)[mind];
			}
		    }
		}
	    }

	    status = lose
		(bqfset, size, head, node, trap(mind, size), rate - 1);
	} while (0);
    }

    return status;
}


static int
shut(void *bqfset, void *node, unsigned size, unsigned rate)
{
    int status;

    if (rate ^ 1) {
	status = miss(bqfset, node, size, rate - 1);
    } else {
	unsigned pick;

	pick = *(integral_q *) node;

	do {
	    void *file;

	    file = MD(node, size)[pick];

	    status = fine(bqfset, size, file);
	    if (status) {
		if (0) {
		} else {
		    int (*move) (void *, void *, unsigned);
		    integral_q last;
		    unsigned deck, ever, mind;
		    void *club, *tier = NULL;

		    mind = *(integral_q *) node;

		    move = bqfset(bqfset)->link_f.move;

		    status = 0;

		    if (1) {
			club = MD(node, size)[pick - 1];
			last = *(integral_q *) club;
			l2_q_bitcount(deck, last);
		    } else {
		    }

		    if (half_integral_q_bits < deck) {
			if (0) {
			} else {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q text;
				unsigned slip;
				void *fast, *side;

				fast = rule(file, size, integral_q_bits - 2);

				ever = (integral_q_bits - 4) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				if (ever & 1) {
				    side = lola(fast, size);
				    move(fast, side, 1);
				    fast = side;
				}
				ever >>= 1;
				for (; ever; ever--) {
				    side = lola(fast, size);
				    move(fast, side, 1);
				    fast = lola(side, size);
				    move(side, fast, 1);
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				deck -= half_integral_q_bits;

				if (deck < 4) {
				    deck = 1;

				    *(integral_q *) fast = Lx55555555;

				    dana(fast, size);
				} else {
				    deck &= ~1;

				    *(integral_q *) fast = Lx55555555
					| ((Q(1) << (deck - 2)) - 1);

				    if (deck < 8) {
					deck >>= 1;

					fast = rule(fast, size, deck);
				    } else {
					fast = rule(fast, size, deck - 3);

					side = life(fast, size);

					deck >>= 1;

					ever = deck - 3;
					for (; ever; ever--) {
					    move(fast, side, 1);
					    beta(side, size);
					    posh(fast, size);
					}
				    }
				}

				move(fast, rule(node, size, pick), 1);

				posh(fast, size);

				deck--;

				text = *(integral_q *) club;

				side = rule(club, size, integral_q_bits);

				while (deck & ~1) {
				    if (text & Q(1) << integral_q_last) {
					beta(side, size);
					posh(fast, size);
					move(fast, side, 2);
					posh(fast, size);

					deck -= 2;
				    } else {
					deck--;

					beta(side, size);
					move(fast, side, 1);
					posh(fast, size);
				    }

				    text <<= 2;
				}
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					posh(side, size);
					move(fast, side, 1);
					posh(side, size);
					move(rule(node, size, pick), side, 1);

					deck = 0;
				    } else {
					beta(side, size);
					move(fast, side, 1);
				    }

				    text <<= 2;
				} else {
				    deck = 1;
				}
				slip = integral_q_bits - 2;
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					posh(side, size);
					move(rule(node, size, pick), side, 1);

					posh(side, size);

					fast =
					    rule(club, size,
						 integral_q_bits - 2);

					text <<= 1;
				    } else {
					beta(side, size);
					move(rule(node, size, pick), side, 1);

					posh(side, size);

					fast =
					    rule(club, size,
						 integral_q_bits - 2);

					text <<= 2;

					if (side < fast) {
					    if (text
						& Q(1) << integral_q_last) {
						move(fast, side, 1);
						beta(fast, size);
						slip -= 2;
					    }

					    posh(side, size);

					    text <<= 1;
					}
				    }
				} else {
				    posh(side, size);

				    fast =
					rule(club, size, integral_q_bits - 2);

				    if (side < fast) {
					if (text & Q(1) << integral_q_last) {
					    move(fast, side, 1);
					    beta(fast, size);
					    slip -= 2;
					}

					posh(side, size);

					text <<= 1;
				    }
				}
				while (side < fast) {
				    if (text & Q(1) << (integral_q_bits - 2)) {
					move(fast, side, 1);
					beta(fast, size);
					posh(side, size);
					move(fast, side, 1);
					beta(fast, size);
					posh(side, size);
					slip -= 4;
				    } else {
					move(fast, side, 1);
					beta(fast, size);
					beta(side, size);
					slip -= 2;
				    }

				    text <<= 2;
				}

				*(integral_q *) club = Lx55555555
				    | text >> (integral_q_last - slip);
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			}
		    } else {
			do {
			    void *fast;

			    if (mind ^ 1) {
			    } else {
				status = _libx1f4l2_fold_bqfset
				    (bqfset, club, file, tier, pick,
				     integral_q_bits - 2, node);
				if (1) {
				    break;
				}
			    }

			    if (1) {
				if (0) {
				} else {
				    unsigned copy = integral_q_bits - 2;

				    _libx1f4l2_gray_bqfset
					(bqfset, &club, node, &pick, &file,
					 &tier, &copy);
				    if (tier) {
				    } else {
					break;
				    }
				}
			    } else {
			    }

			    if (1) {
				fast = file;

				fast = rule(fast, size, integral_q_bits - 2);

				if (0) {
				} else {
				    deck = (half_integral_q_bits - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				    for (; deck; deck--) {
					move(fast, (char *) fast - (size << 1),
					     1);
					beta(fast, size);
				    }
# endif				/* __UNROLL_TRANSFER__ */
				}
			    }

			    {
				void *side;

				fast = club;

				*(integral_q *) club =
				    Lxdddddddd ^ Q(1) << integral_q_last;

				if (0) {
				} else {
				    fast = rule(fast, size, 4);

				    side = life(fast, size);

				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				deck = (integral_q_bits - 6) / 6;
				for (; deck; deck--) {
				    move(side, fast, 1);
				    dana(fast, size);
				    dana(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					move(side, fast, 1);

					fast = file;

					dana(fast, size);
					dana(side, size);
					move(side, rule(node, size, pick), 1);
					skip(side, size);
					move(side, fast, 1);
					skip(side, size);
				    } else {
					move(side, fast, 1);
					dana(fast, size);
					dana(side, size);
					move(side, fast, 1);

					fast = file;

					skip(side, size);
					move(side, rule(node, size, pick), 1);
					skip(side, size);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				}

				{
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				}

				fast = rule(tier, size, integral_q_bits);

				side = fast;

				deck = integral_q_bits / 6;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					fast =
					    rule(file, size,
						 integral_q_bits - 2);

					posh(side, size);
					move(side, rule(node, size, pick + 1),
					     1);
					posh(side, size);
					move(side, fast, 1);
					beta(side, size);
					beta(fast, size);
					move(side, fast, 1);
				    } else {
					posh(side, size);
					beta(fast, size);
					move(side, fast, 1);

					fast =
					    rule(file, size,
						 integral_q_bits - 2);

					posh(side, size);
					move(side, rule(node, size, pick + 1),
					     1);
					beta(side, size);
					move(side, fast, 1);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				{
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				*(integral_q *) tier = Lxdddddddd;
			    }

			    if (1) {
				void *side, **trap;

				trap = MD(node, size) + pick;

				memmove(trap, trap + 1,
					(mind - pick) * sizeof(void *));

				side = rule(node, size, pick);

				move(side, cell(fast, size, 4), 1);

				skip(side, size);

				move(side, sans(side, size), mind - pick);

				*(integral_q *) node = mind - 1;

				status = bqfset(bqfset)->link_m.free
				    (bqfset(bqfset)->link_m.data, file);
				if (status) {
				    status = FREE_ERROR;
				}
			    }
			} while (0);
		    }
		}
	    }
	} while (0);
    }

    return status;
}


int
x1f4_slip_bqfset(void *bqfset)
{
    int status;
    unsigned rate, size;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

    if (rate) {
	status = shut
	    (bqfset, bqfset(bqfset)->link_a.fpnews.node, size, rate);
    } else {
	status = clip(bqfset, bqfset(bqfset)->link_a.fpnews.node, size);
    }

    return status;
}
