/*
 * bqfv.8.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bcount.h>
#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <reverse.h>
#include <xfs.h>
#include <xls.h>

#define __HALF_TRANSFER__		1

#define __FINE_EXCESS__			1
#define __FINE_SECOND__			2
#define __FINE_SELECT__			3
#define __FINE_TARGET__			4

#define __FINE_METHOD__			__FINE_EXCESS__

#define ____FINE_METHOD__		__FINE_METHOD__

#define __LOSE_DOUBLE__			1

#define __LOSE_METHOD__			__LOSE_DOUBLE__

#define __UNROLL_TRANSFER__		0

#define FINE_ERROR			(LAST_ERROR + 8)

#define false(e)			0

#define here_two_test(___h) \
    ((___h) & 8192)

#undef here_two_test

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_n_count(___h, ___e) \
    ___n = (___e) & ~Lx55555555;					      \
    ___p |= (___n | ___n << (half_integral_q_bits - 1))			      \
	& ~Q(0) << half_integral_q_bits;				      \
    if (1) {								      \
	___t |= Q(1024) << half_integral_q_bits;			      \
    }
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_l_reset(___h) \
    ___p = 0;								      \
    ___t = 0
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_declarations \
    integral_q ___n, ___p, ___t
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_setup(___f, ___g) \
    l2_q_heap_1up(___p);						      \
									      \
    ___p &= Q(0xff) | Q(0xff) << half_integral_q_bits;			      \
									      \
    ___p |= ___t;							      \
    ___p |=								      \
	((___p								      \
	  - ((___t & (Q(1024) | Q(1024) << half_integral_q_bits)) >> 10))     \
	 & (Q(1024) | Q(1024) << half_integral_q_bits)) << 3;		      \
									      \
    (___g) = ___p >> half_integral_q_bits
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#define here_two_test(___h) \
    ((___h) & 8192)

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define cell(___s, ___n, ___t) \
    ((char *) (___s) - (___n) * (___t))

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#define trap(___n, ___s)		((___n) + ((___s) << 2))

#define true(e)				1

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int clip(void *, void *, unsigned);
static int edge(void *, unsigned, unsigned,
		int (*) (void *, void *, unsigned));
static int fine(void *, unsigned, void *);
static int lose(void *, unsigned, void *, unsigned, void *, unsigned);
static int miss(void *, void *, unsigned, unsigned);
static int shut(void *, void *, unsigned, unsigned);

static int
clip(void *bqfset, void *node, unsigned size)
{
    int status;
    unsigned mind;

    mind = *(integral_q *) node;
    if (mind) {
	mind--;
	if (mind) {
	    void *call;

	    call = (char *) node + size;

	    status = bqfset(bqfset)->link_f.move
		(call, (char *) call + size, mind);
	    if (status) {
		status = MOVE_ERROR;
	    } else {
		*((integral_q *) node) = mind;
	    }
	} else {
	    *((integral_q *) node) = 0;
	    if (1) {
		status = 0;
	    }
	}
    } else {
	status = DECK_ERROR;
    }

    return status;
}


static int
edge(void *node, unsigned size, unsigned call,
     int (*move) (void *, void *, unsigned))
{
    integral_q news, slip;

    news = *(integral_q *) node;

    slip  = news & ~Lx55555555;

    {
	if (1) {
	    call++;

	    if (call & 1) {
		*(integral_q *) node = news & ~(Q(1) << call);
	    } else {
		if (news & (Q(1) << (call - 1))) {
		    *(integral_q *) node = news & ~(Q(1) << (call - 1));
		    if (2) {
			void *data, **text;

			data = HD(node, size, call);
			move(data, life(data, size), 1);
			call--;
			text = ZD(node, size) + call;
			*text = *(text - 1);
		    }
		} else {
		    if (news & (Q(1) << (call + 1))) {
			void *data, **text;

			*(integral_q *) node = news & ~(Q(1) << (call + 1));
			data = HD(node, size, call);
			move(data, sans(data, size), 1);
			text = ZD(node, size) + call;
			*(text - 1) = *text;
		    } else {
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << call);
			if (1) {
			    l2_q_xfs(ever, back);
			    if (0) {
			    } else {
				if (2) {
				    void *data, **text;

				    *(integral_q *) node =
					news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    text = ZD(node, size) + call;
				    call++;
				    data = rule(node, size, call);
				    for (; deck; deck--) {
					void *trip;

					*text = *(text + 2);
					text += 2;
					trip = road(data, size);
					move(data, trip, 1);
					data = trip;
				    }
				    {
					*text = *(text + 1);
					move(data, sans(data, size), 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return 0;
}


static int
fine(void *bqfset, unsigned size, void *node)
{
    int status;

    do {
	integral_q news;

	news = *(integral_q *) node;

	if (news & Q(2)) {
	    status = 0;

	    *(integral_q *) node = news & ~Q(2);

	    if (1) {
		break;
	    }
	} else {
	    if (news & Q(8)) {
		void *fast;

		status = 0;

		*(integral_q *) node = news & ~Q(8);

		fast = rule(node, size, 2);

		bqfset(bqfset)->link_f.move(fast, (char *) fast + size, 1);

		if (1) {
		    break;
		}
	    }
	}
	{
	    integral_q slip;

	    slip = news & ~Lx55555555;
	    if (slip) {
		int (*move) (void *, void *, unsigned);
		void *fast;

		move = bqfset(bqfset)->link_f.move;

		status = 0;

		fast = rule(node, size, 2);

		if (news & Q(2)) {
		    *(integral_q *) node = news & ~Q(2);
		    move(fast, life(fast, size), 1);
		} else {
		    if (0) {
		    } else {
#if ____FINE_METHOD__ == __FINE_SELECT__
#elif __FINE_METHOD__ == __FINE_EXCESS__
			integral_q next;
			unsigned copy = 2;

			slip >>= copy + 1;
			slip &= (slip - 1) << 1;
			if (0) {
			} else {
			    next = slip >> 4;
			    size <<= 1;
			    for (; next; next >>= 4) {
				void *side;

				side = (char *) fast + size;
				move(fast, side, 1);
				fast = (char *) side + size;
				move(side, fast, 1);

				copy += 4;
			    }
			    if (slip & Lx44444444) {
				void *side;

				side = (char *) fast + size;
				move(fast, side, 1);
				fast = side;

				copy += 2;
			    }
			    size >>= 1;
			    {
				move(fast, (char *) fast + size, 1);
			    }

			    *(integral_q *) node = news ^ (Q(1) << (copy + 1));
			}
#elif __FINE_METHOD__ == __FINE_SECOND__
#elif __FINE_METHOD__ == __FINE_TARGET__
#endif				/* ____FINE_METHOD__ == __FINE_SELECT__ */
		    }
		}
	    } else {
		*(integral_q *) node = news & ~Q(8);
		if (1) {
		    status = FINE_ERROR + 2;
		}
	    }
	}
    } while (0);

    return status;
}


static int
lose(void *bqfset, unsigned size, void *high, unsigned pass, void *turn,
     unsigned rate)
{
    integral_q pipe;
    unsigned call;
    void *file, *node;
    int status;

    node = ZD(high, size)[pass];

    pipe = *(integral_q *) node;

    while (1) {
	call = ~pipe >> 1 & 1;

	file = ZD(node, size)[call];

	if (rate) {
	    integral_q lane;

	    lane = *(integral_q *) file;

	    if (lane & ~Lx55555555) {
		high = node;

		node = file;

		pipe = lane;

		rate = rate - 1;
	    } else {
		void *past, *tier;

		if (call) {
		    if (1) {
			past = HD(node, size, 2);
			if (pipe & Q(8)) {
			    tier = ZD(node, size)[2];
			} else {
			    tier = ZD(node, size)[3];
			}
		    } else {
		    }
		} else {
		    past = HD(node, size, 1);
		    tier = ZD(node, size)[1];
		}

		status = _libx1f4l2_five_bqfset
		    (bqfset, pipe, &node, call, &file, tier, &past, turn);
		if (status == FREE_ERROR) {
		    break;
		} else {
		}

		high = node;

		node = file;

		pipe = *(integral_q *) file;

		turn = past;

		rate = rate - 1;
	    }
	} else {
	    status = fine(bqfset, size, file);
	    if (status) {
		if (0) {
		} else {
		    int (*move) (void *, void *, unsigned);
		    integral_q next;
		    unsigned deck, ever;
		    void *past, *tier;

		    move = bqfset(bqfset)->link_f.move;

		    if (call) {
			if (1) {
			    past = HD(node, size, 2);
			    if (pipe & Q(8)) {
				tier = ZD(node, size)[2];
			    } else {
				tier = ZD(node, size)[3];
			    }
			}
		    } else {
			past = HD(node, size, 1);
			if (0) {
			} else {
			    {
				tier = ZD(node, size)[1];
			    }
			}
		    }

		    status = 0;

		    {
			here_two_declarations;

			if (0) {
			} else {
			    here_two_l_reset(deck);
			}

			if (1) {
			    next = *(integral_q *) tier;
			    here_two_n_count(ever, next);
			} else {
			}

			here_two_setup(deck, ever);
		    }

		    if (here_two_test(ever)) {
			if (1) {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q text;
				unsigned slip;
				void *fast, *side;

				fast = rule(file, size, 2);

				deck = (integral_q_bits - 4) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				if (deck & 1) {
				    side = road(fast, size);
				    move(fast, side, 1);
				    fast = side;
				}
				deck >>= 1;
				for (; deck; deck--) {
				    side = road(fast, size);
				    move(fast, side, 1);
				    fast = road(side, size);
				    move(side, fast, 1);
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				ever &= 254;

				if (ever < 4) {
				    ever = 1;

				    *(integral_q *) fast = Lx55555555;

				    fast =
					rule(fast, size, integral_q_bits - 2);
				} else {
				    *(integral_q *) fast = Lx55555555
					| ~Q(0)
					<< (integral_q_bits - ever + 2);

				    if (ever < 8) {
					ever >>= 1;

					fast =
					    rule(fast, size,
						 integral_q_bits - ever);
				    } else {
					fast =
					    rule(fast, size,
						 integral_q_bits - ever + 3);

					side = sans(fast, size);

					ever >>= 1;

					deck = ever - 3;
					for (; deck; deck--) {
					    move(fast, side, 1);
					    dana(side, size);
					    skip(fast, size);
					}
				    }
				}

				move(fast, past, 1);

				skip(fast, size);

				ever--;

				side = tier;

				text = *(integral_q *) tier;

				while (ever & ~1) {
				    if (text & Q(2)) {
					skip(side, size);
					move(fast, side, 2);
					dana(fast, size);
					skip(side, size);

					ever -= 2;
				    } else {
					ever--;

					dana(side, size);
					move(fast, side, 1);
					skip(fast, size);
				    }

				    text >>= 2;
				}
				if (ever) {
				    if (text & Q(2)) {
					skip(side, size);
					move(fast, side, 1);
					skip(side, size);
					move(past, side, 1);

					ever = 0;
				    } else {
					dana(side, size);
					move(fast, side, 1);
				    }

				    text >>= 2;
				} else {
				    ever = 1;
				}
				slip = 2;
				if (ever) {
				    if (text & Q(2)) {
					skip(side, size);
					move(past, side, 1);

					skip(side, size);

					fast = road(tier, size);

					text >>= 1;
				    } else {
					dana(side, size);
					move(past, side, 1);

					skip(side, size);

					fast = road(tier, size);

					text >>= 2;

					if (fast < side) {
					    text >>= 1;
					    if (text & Q(1)) {
						move(fast, side, 1);
						dana(fast, size);
						slip += 2;
					    } else {
					    }

					    skip(side, size);
					}
				    }
				} else {
				    skip(side, size);

				    fast = road(tier, size);

				    if (fast < side) {
					text >>= 1;
					if (text & Q(1)) {
					    move(fast, side, 1);
					    dana(fast, size);
					    slip += 2;
					} else {
					}

					skip(side, size);
				    }
				}
				while (fast < side) {
				    if (text & Q(4)) {
					move(fast, side, 1);
					dana(fast, size);
					skip(side, size);
					move(fast, side, 1);
					dana(fast, size);
					skip(side, size);
					slip += 4;
				    } else {
					move(fast, side, 1);
					dana(fast, size);
					dana(side, size);
					slip += 2;
				    }

				    text >>= 2;
				}

				*(integral_q *) tier =
				    Lx55555555 | text >> 1 << (slip - 1) << 1;
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			}
		    } else {
			do {
			    void *club = NULL, *fast, *head;

			    if (1) {
				if (0) {
				} else {
				    unsigned copy = 2;

				    head = past;

				    _libx1f4l2_four_bqfset
					(bqfset, 0, &club, pipe, &node, &call,
					 &file, &past, &tier, next, &copy);
				    if (club) {
				    } else {
					break;
				    }
				}
			    } else {
			    }

			    {
				void *side;

				fast = club;

				*(integral_q *) club =
				    Lxdddddddd ^ Q(1) << integral_q_last;

				if (0) {
				} else {
				    fast = rule(fast, size, 4);

				    side = life(fast, size);

				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				deck = (integral_q_bits - 6) / 6;
				for (; deck; deck--) {
				    move(side, fast, 1);
				    dana(fast, size);
				    dana(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					move(side, fast, 1);

					fast = rule(file, size, 4);

					dana(side, size);
					move(side, head, 1);
					skip(side, size);
					move(side, fast, 1);
					skip(side, size);
				    } else {
					move(side, fast, 1);
					dana(fast, size);
					dana(side, size);
					move(side, fast, 1);

					fast = road(file, size);

					skip(side, size);
					move(side, head, 1);
					skip(side, size);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				}

				{
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				}

				fast = rule(tier, size, integral_q_bits);

				side = fast;

				deck = integral_q_bits / 6;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					fast =
					    rule(file, size,
						 integral_q_bits - 2);

					posh(side, size);
					move(side, past, 1);
					posh(side, size);
					move(side, fast, 1);
					beta(side, size);
					beta(fast, size);
					move(side, fast, 1);
				    } else {
					posh(side, size);
					beta(fast, size);
					move(side, fast, 1);

					fast =
					    rule(file, size,
						 integral_q_bits - 2);

					posh(side, size);
					move(side, past, 1);
					beta(side, size);
					move(side, fast, 1);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				{
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				*(integral_q *) tier = Lxdddddddd;
			    }

			    if (1) {
				int excess;

				move(head, cell(fast, size, 2), 1);

				status = edge(node, size, call, move);

				excess = bqfset(bqfset)->link_m.free
				    (bqfset(bqfset)->link_m.data, file);
				if (excess) {
				    status = FREE_ERROR;
				}
			    } else {
			    }
			} while (0);
		    }
		}
	    }

	    break;
	}
    }

    return status;
}


static int
miss(void *bqfset, void *node, unsigned size, unsigned rate)
{
    int status;

    if (1) {
	unsigned mind;
	void *past;

	mind = *(integral_q *) node;

	if (0) {
	} else {
	    past = rule(node, size, 1);
	}

	do {
	    void *file;

	    file = MD(node, size)[0];

	    if (*(integral_q *) file & ~Lx55555555) {
	    } else {
		status = _libx1f4l2_dawn_bqfset
		    (bqfset, mind, node, file, &past, MD(node, size)[1], rate);
		if (status) {
		    if (status < LAST_ERROR) {
			break;
		    } else {
			if (status ^ (LAST_ERROR + integral_q_bits)) {
			    status = shut
				(bqfset, bqfset(bqfset)->link_a.fpnews.node,
				 size, rate);

			    break;
			} else {
			    mind--;

			    file = MD(node, size)[0];
			}
		    }
		}
	    }

	    status = lose
		(bqfset, size, node, trap(0, size), past, rate - 1);
	} while (0);
    }

    return status;
}


static int
shut(void *bqfset, void *node, unsigned size, unsigned rate)
{
    int status;

    if (rate ^ 1) {
	status = miss(bqfset, node, size, rate - 1);
    } else {
	do {
	    void *file;

	    file = MD(node, size)[0];

	    status = fine(bqfset, size, file);
	    if (status) {
		if (0) {
		} else {
		    int (*move) (void *, void *, unsigned);
		    integral_q next;
		    unsigned deck, ever, mind;
		    void *club = NULL, *tier;

		    mind = *(integral_q *) node;

		    move = bqfset(bqfset)->link_f.move;

		    status = 0;

		    if (1) {
			tier = MD(node, size)[1];
			next = *(integral_q *) tier;
			l2_q_bitcount(ever, next);
		    } else {
		    }

		    if (half_integral_q_bits < ever) {
			if (1) {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q text;
				unsigned slip;
				void *fast, *side;

				fast = rule(file, size, 2);

				deck = (integral_q_bits - 4) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				if (deck & 1) {
				    side = road(fast, size);
				    move(fast, side, 1);
				    fast = side;
				}
				deck >>= 1;
				for (; deck; deck--) {
				    side = road(fast, size);
				    move(fast, side, 1);
				    fast = road(side, size);
				    move(side, fast, 1);
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				ever -= half_integral_q_bits;

				if (ever < 4) {
				    ever = 1;

				    *(integral_q *) fast = Lx55555555;

				    fast =
					rule(fast, size, integral_q_bits - 2);
				} else {
				    ever &= ~1;

				    *(integral_q *) fast = Lx55555555
					| ~Q(0)
					<< (integral_q_bits - ever + 2);

				    if (ever < 8) {
					ever >>= 1;

					fast =
					    rule(fast, size,
						 integral_q_bits - ever);
				    } else {
					fast =
					    rule(fast, size,
						 integral_q_bits - ever + 3);

					side = sans(fast, size);

					ever >>= 1;

					deck = ever - 3;
					for (; deck; deck--) {
					    move(fast, side, 1);
					    dana(side, size);
					    skip(fast, size);
					}
				    }
				}

				move(fast, rule(node, size, 1), 1);

				skip(fast, size);

				ever--;

				side = tier;

				text = *(integral_q *) tier;

				while (ever & ~1) {
				    if (text & Q(2)) {
					skip(side, size);
					move(fast, side, 2);
					dana(fast, size);
					skip(side, size);

					ever -= 2;
				    } else {
					ever--;

					dana(side, size);
					move(fast, side, 1);
					skip(fast, size);
				    }

				    text >>= 2;
				}
				if (ever) {
				    if (text & Q(2)) {
					skip(side, size);
					move(fast, side, 1);
					skip(side, size);
					move(rule(node, size, 1), side, 1);

					ever = 0;
				    } else {
					dana(side, size);
					move(fast, side, 1);
				    }

				    text >>= 2;
				} else {
				    ever = 1;
				}
				slip = 2;
				if (ever) {
				    if (text & Q(2)) {
					skip(side, size);
					move(rule(node, size, 1), side, 1);

					skip(side, size);

					fast = road(tier, size);

					text >>= 1;
				    } else {
					dana(side, size);
					move(rule(node, size, 1), side, 1);

					skip(side, size);

					fast = road(tier, size);

					text >>= 2;

					if (fast < side) {
					    text >>= 1;
					    if (text & Q(1)) {
						move(fast, side, 1);
						dana(fast, size);
						slip += 2;
					    } else {
					    }

					    skip(side, size);
					}
				    }
				} else {
				    skip(side, size);

				    fast = road(tier, size);

				    if (fast < side) {
					text >>= 1;
					if (text & Q(1)) {
					    move(fast, side, 1);
					    dana(fast, size);
					    slip += 2;
					} else {
					}

					skip(side, size);
				    }
				}
				while (fast < side) {
				    if (text & Q(4)) {
					move(fast, side, 1);
					dana(fast, size);
					skip(side, size);
					move(fast, side, 1);
					dana(fast, size);
					skip(side, size);
					slip += 4;
				    } else {
					move(fast, side, 1);
					dana(fast, size);
					dana(side, size);
					slip += 2;
				    }

				    text >>= 2;
				}

				*(integral_q *) tier =
				    Lx55555555 | text >> 1 << (slip - 1) << 1;
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			} else {
			}
		    } else {
			do {
			    void *fast;

			    if (mind ^ 1) {
			    } else {
				status = _libx1f4l2_fold_bqfset
				    (bqfset, NULL, file, tier, 0, 2, node);
				if (1) {
				    break;
				}
			    }

			    if (0) {
			    } else {
				if (1) {
				    unsigned copy = 2, pick = 0;

				    _libx1f4l2_blue_bqfset
					(bqfset, &club, node, &pick, &file,
					 &tier, &copy);
				    if (club) {
				    } else {
					break;
				    }
				}
			    }

			    if (1) {
				fast = file;

				fast = rule(fast, size, 2);

				if (1) {
				    deck = (half_integral_q_bits - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				    for (; deck; deck--) {
					move(fast, (char *) fast + (size << 1),
					     1);
					dana(fast, size);
				    }
# endif				/* __UNROLL_TRANSFER__ */
				}
			    }

			    {
				void *side;

				fast = club;

				*(integral_q *) club =
				    Lxdddddddd ^ Q(1) << integral_q_last;

				if (0) {
				} else {
				    fast = rule(fast, size, 4);

				    side = life(fast, size);

				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				deck = (integral_q_bits - 6) / 6;
				for (; deck; deck--) {
				    move(side, fast, 1);
				    dana(fast, size);
				    dana(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				    move(side, fast, 1);
				    dana(fast, size);
				    skip(side, size);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					move(side, fast, 1);

					fast = file;

					dana(fast, size);
					dana(side, size);
					move(side, rule(node, size, 1), 1);
					skip(side, size);
					move(side, fast, 1);
					skip(side, size);
				    } else {
					move(side, fast, 1);
					dana(fast, size);
					dana(side, size);
					move(side, fast, 1);

					fast = file;

					skip(side, size);
					move(side, rule(node, size, 1), 1);
					skip(side, size);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				    skip(side, size);
				}

				{
				    dana(fast, size);
				    move(side, fast, 1);
				    dana(side, size);
				    dana(fast, size);
				    move(side, fast, 1);
				}

				fast = rule(tier, size, integral_q_bits);

				side = fast;

				deck = integral_q_bits / 6;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					fast =
					    rule(file, size,
						 integral_q_bits - 2);

					posh(side, size);
					move(side, rule(node, size, 2), 1);
					posh(side, size);
					move(side, fast, 1);
					beta(side, size);
					beta(fast, size);
					move(side, fast, 1);
				    } else {
					posh(side, size);
					beta(fast, size);
					move(side, fast, 1);

					fast =
					    rule(file, size,
						 integral_q_bits - 2);

					posh(side, size);
					move(side, rule(node, size, 2), 1);
					beta(side, size);
					move(side, fast, 1);
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    beta(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				{
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				    posh(side, size);
				    beta(fast, size);
				    move(side, fast, 1);
				}

				*(integral_q *) tier = Lxdddddddd;
			    }

			    if (1) {
				void *side, **trap;

				trap = MD(node, size) + 1;

				mind--;

				memmove(trap, trap + 1, mind * sizeof(void *));

				side = rule(node, size, 1);

				move(side, cell(fast, size, 4), 1);

				skip(side, size);

				move(side, sans(side, size), mind);

				*(integral_q *) node = mind;

				status = bqfset(bqfset)->link_m.free
				    (bqfset(bqfset)->link_m.data, file);
				if (status) {
				    status = FREE_ERROR;
				}
			    }
			} while (0);
		    }
		}
	    }
	} while (0);
    }

    return status;
}


int
x1f4_mind_bqfset(void *bqfset)
{
    int status;
    unsigned rate, size;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

    if (rate) {
	status = shut(bqfset, bqfset(bqfset)->link_a.fpnews.node, size, rate);
    } else {
	status = clip(bqfset, bqfset(bqfset)->link_a.fpnews.node, size);
    }

    return status;
}
