/*
 * bqfh.m.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-types.h>

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int line(void *, unsigned, unsigned, void *, int (*) (void *, void *));
static int near(void *, void *, unsigned, void *, void *,
		int (*) (void *, void *));
static int pass(void *, void *, unsigned, unsigned, void *, void *,
		int (*) (void *, void *));
static int slip(void *, void *, unsigned, unsigned, unsigned, void *, void *,
		int (*) (void *, void *));

static int
line(void *node, unsigned size, unsigned miss, void *back,
     int (*call) (void *, void *))
{
    int delete;

    if (miss) {
	do {
	    skip(node, size);
	    miss--;
	    delete = call(back, node);
	    if (delete) {
		break;
	    }
	} while (miss);
    } else {
	delete = 0;
    }

    return delete;
}


static int
near(void *bqfset, void *node, unsigned size, void *aime, void *back,
     int (*call) (void *, void *))
{
    int delete;
    integral_q news;
    unsigned copy;

    news = *(integral_q *) node;

    if (bqfset(bqfset)->link_f.pick(aime, node, &copy)) {
	unsigned slip;
	void *last;

	if (copy & 1) {
	    if (news & Q(1) << copy) {
	    } else {
		copy--;
	    }
	}

	last = rule(node, size, copy);

	copy--;

	news <<= integral_q_last - copy;

	slip = copy;
	while (slip) {
	    posh(last, size);

	    slip--;

	    if (news & Q(1) << integral_q_last) {
		if (bqfset(bqfset)->link_f.fare(aime, last)) {
		    if (1) {
			break;
		    }
		} else {
		    copy = slip;
		}

		news <<= 1;
	    }
	}

	news = *(integral_q *) node;
    }

    do {
	news &= ((Q(1) << copy) - 1) << 1;

	if (1) {
	    if (0) {
	    } else {
		skip(node, size);
		if (news & 2) {
		    delete = call(back, node);
		    if (delete) {
			break;
		    }
		}
	    }

	    news >>= 2;
	}

	delete = 0;

	while (news) {
	    skip(node, size);
	    delete = call(back, node);
	    if (delete) {
		break;
	    } else {
		skip(node, size);
		if (news & 2) {
		    delete = call(back, node);
		    if (delete) {
			break;
		    }
		}
	    }

	    news >>= 2;
	}
    } while (0);

    return delete;
}


static int
pass(void *bqfset, void *node, unsigned rate, unsigned size, void *aime,
     void *back, int (*call) (void *, void *))
{
    int delete;
    integral_q news;
    unsigned copy;
    void **text;

    news = *(integral_q *) node;

    if (bqfset(bqfset)->link_f.pick(aime, node, &copy)) {
	unsigned slip;
	void *last;

	if (copy & 1) {
	    if (news & Q(1) << copy) {
	    } else {
		copy--;
	    }
	}

	last = rule(node, size, copy);

	copy--;

	news <<= integral_q_last - copy;

	slip = copy;
	while (slip) {
	    posh(last, size);

	    slip--;

	    if (news & Q(1) << integral_q_last) {
		if (bqfset(bqfset)->link_f.fare(aime, last)) {
		    if (1) {
			break;
		    }
		} else {
		    copy = slip;
		}

		news <<= 1;
	    }
	}

	news = *(integral_q *) node;
    }

    text = (void **) ((char *) node + size * integral_q_bits);

    rate--;

    do {
	if (rate) {
	    unsigned nine;

	    nine = copy >> 1;

	    if (nine) {
		nine--;

		skip(node, size);
		if (news & 2) {
		    delete = _libx1f4l2_fpxx_bqfset
			(*text, rate, size, back, call);
		    if (delete) {
			break;
		    } else {
			delete = call(back, node);
			if (delete) {
			    break;
			}
		    }
		}

		text++;

		{
		    delete = _libx1f4l2_fpxx_bqfset
			(*text, rate, size, back, call);
		    if (delete) {
			break;
		    }
		}

		text++;

		news >>= 2;
	    }

	    for (; nine; nine--) {
		skip(node, size);
		delete = call(back, node);
		if (delete) {
		    break;
		}

		skip(node, size);
		if (news & 2) {
		    delete = _libx1f4l2_fpxx_bqfset
			(*text, rate, size, back, call);
		    if (delete) {
			break;
		    } else {
			delete = call(back, node);
			if (delete) {
			    break;
			}
		    }
		}

		text++;

		{
		    delete = _libx1f4l2_fpxx_bqfset
			(*text, rate, size, back, call);
		    if (delete) {
			break;
		    }
		}

		text++;

		news >>= 2;
	    }

	    if (copy & ~1) {
		skip(node, size);
		delete = call(back, node);
		if (delete) {
		    break;
		}
	    }

	    if (1) {
		if (copy & 1) {
		} else {
		    delete = pass(bqfset, *text, rate, size, aime, back, call);
		    if (1) {
			break;
		    }
		}

		skip(node, size);
		if (news & 2) {
		    delete = _libx1f4l2_fpxx_bqfset
			(*text, rate, size, back, call);
		    if (delete) {
			break;
		    } else {
			delete = call(back, node);
			if (delete) {
			    break;
			}
		    }
		}

		text++;

		{
		    delete = pass(bqfset, *text, rate, size, aime, back, call);
		}
	    }
	} else {
	    unsigned nine;

	    nine = copy >> 1;

	    if (nine) {
		nine--;

		skip(node, size);
		if (news & 2) {
		    delete = _libx1f4l2_flxx_bqfset(*text, size, back, call);
		    if (delete) {
			break;
		    } else {
			delete = call(back, node);
			if (delete) {
			    break;
			}
		    }
		}

		text++;

		{
		    delete = _libx1f4l2_flxx_bqfset(*text, size, back, call);
		    if (delete) {
			break;
		    }
		}

		text++;

		news >>= 2;
	    }

	    for (; nine; nine--) {
		skip(node, size);
		delete = call(back, node);
		if (delete) {
		    break;
		}

		skip(node, size);
		if (news & 2) {
		    delete = _libx1f4l2_flxx_bqfset(*text, size, back, call);
		    if (delete) {
			break;
		    } else {
			delete = call(back, node);
			if (delete) {
			    break;
			}
		    }
		}

		text++;

		{
		    delete = _libx1f4l2_flxx_bqfset(*text, size, back, call);
		    if (delete) {
			break;
		    }
		}

		text++;

		news >>= 2;
	    }

	    if (copy & ~1) {
		skip(node, size);
		delete = call(back, node);
		if (delete) {
		    break;
		}
	    }

	    if (1) {
		if (copy & 1) {
		} else {
		    delete = near(bqfset, *text, size, aime, back, call);
		    if (1) {
			break;
		    }
		}

		skip(node, size);
		if (news & 2) {
		    delete = _libx1f4l2_flxx_bqfset(*text, size, back, call);
		    if (delete) {
			break;
		    } else {
			delete = call(back, node);
			if (delete) {
			    break;
			}
		    }
		}

		text++;

		{
		    delete = near(bqfset, *text, size, aime, back, call);
		}
	    }
	}
    } while (0);

    return delete;
}


static int
slip(void *bqfset, void *node, unsigned rate, unsigned size, unsigned miss,
     void *aime, void *back, int (*call) (void *, void *))
{
    int delete;
    void **text;

    text = (void **) ((char *) node + size * integral_q_bits_and_half);

    rate--;

    if (rate) {
	delete = 0;
	while (miss) {
	    delete = _libx1f4l2_fpxx_bqfset(*text, rate, size, back, call);
	    if (delete) {
		break;
	    } else {
		skip(node, size);
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    text++;
		}
	    }

	    miss--;
	}

	if (delete) {
	} else {
	    delete = pass(bqfset, *text, rate, size, aime, back, call);
	}
    } else {
	delete = 0;
	while (miss) {
	    delete = _libx1f4l2_flxx_bqfset(*text, size, back, call);
	    if (delete) {
		break;
	    } else {
		skip(node, size);
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    text++;
		}
	    }

	    miss--;
	}

	if (delete) {
	} else {
	    delete = near(bqfset, *text, size, aime, back, call);
	}
    }

    return delete;
}


int
x1f4_llzd_bqfset(void *bqfset, void *aime, void *back,
		 int (*call) (void *, void *))
{
    int delete;
    unsigned copy, rate, size;
    void *node;

    node = bqfset(bqfset)->link_a.fpnews.node;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    if (bqfset(bqfset)->link_f.look(aime, node, &copy)) {
	unsigned slip;
	void *last;

	last = rule(node, size, copy);

	slip = copy;
	slip--;
	while (slip) {
	    posh(last, size);
	    if (bqfset(bqfset)->link_f.fare(aime, last)) {
		break;
	    } else {
		slip--;
	    }
	}

	copy = slip;
    }

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
    if (rate) {
	delete = slip(bqfset, node, rate, size, copy, aime, back, call);
    } else {
	delete = line(node, size, copy, back, call);
    }

    return delete;
}
