/*
 * bcount.h
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_bcount_H__
#define __LIBx1f4_bcount_H__

#include <config.h>

#if !defined BITS_LONG
# define BITS_LONG			unsigned long
#endif				/* !BITS_LONG */

#if !defined BITS_MODE
# define BITS_MODE			unsigned
#endif				/* !BITS_MODE */

#define l2_1_bitcount(l4f1_bitcount, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = (l4f1_c & 0x55555555) + ((l4f1_c >> 0x01) & 0x55555555);     \
	l4f1_c = (l4f1_c & 0x33333333) + ((l4f1_c >> 0x02) & 0x33333333);     \
	l4f1_c = (l4f1_c & 0x0f0f0f0f) + ((l4f1_c >> 0x04) & 0x0f0f0f0f);     \
	l4f1_c = (l4f1_c & 0x00ff00ff) + ((l4f1_c >> 0x08) & 0x00ff00ff);     \
	l4f1_c = (l4f1_c & 0x0000ffff) + ((l4f1_c >> 0x10) & 0x0000ffff);     \
									      \
	(l4f1_bitcount) = l4f1_c;					      \
    }

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# define l2_2_bitcount(l4f1_bitcount, l4f1_mode) \
    {									      \
	BITS_LONG l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = (l4f1_c & 0x5555555555555555ul)			      \
	    + ((l4f1_c >> 0x01) & 0x5555555555555555ul);		      \
	l4f1_c = (l4f1_c & 0x3333333333333333ul)			      \
	    + ((l4f1_c >> 0x02) & 0x3333333333333333ul);		      \
	l4f1_c = (l4f1_c & 0x0f0f0f0f0f0f0f0ful)			      \
	    + ((l4f1_c >> 0x04) & 0x0f0f0f0f0f0f0f0ful);		      \
	l4f1_c = (l4f1_c & 0x00ff00ff00ff00fful)			      \
	    + ((l4f1_c >> 0x08) & 0x00ff00ff00ff00fful);		      \
	l4f1_c = (l4f1_c & 0x0000ffff0000fffful)			      \
	    + ((l4f1_c >> 0x10) & 0x0000ffff0000fffful);		      \
	l4f1_c = (l4f1_c & 0x00000000fffffffful)			      \
	    + ((l4f1_c >> 0x20) & 0x00000000fffffffful);		      \
									      \
	(l4f1_bitcount) = l4f1_c;					      \
    }
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#define l2_1_heap_1up(l4f1_c) \
    {									      \
	l4f1_c = l4f1_c - ((l4f1_c >> 1) & 0x55555555);			      \
	l4f1_c = (l4f1_c & 0x33333333) + ((l4f1_c >> 2) & 0x33333333);	      \
	l4f1_c = (l4f1_c + (l4f1_c >> 4)) & 0x0f0f0f0f;			      \
	l4f1_c = l4f1_c + (l4f1_c >> 8);				      \
    }

#define l2_1_heap(l4f1_c) \
    {									      \
	l2_1_heap_1up(l4f1_c);						      \
	l4f1_c = l4f1_c + (l4f1_c >> 16);				      \
    }

#undef l2_1_bitcount

#define l2_1_bitcount(l4f1_bitcount, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l2_1_heap(l4f1_c);						      \
									      \
	(l4f1_bitcount) = l4f1_c & 255;					      \
    }

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# define l2_2_heap_1up(l4f1_c) \
    {									      \
	l4f1_c = l4f1_c - ((l4f1_c >> 1) & 0x5555555555555555ul);	      \
	l4f1_c = (l4f1_c & 0x3333333333333333ul)			      \
	    + ((l4f1_c >> 2) & 0x3333333333333333ul);			      \
	l4f1_c = (l4f1_c + (l4f1_c >> 4)) & 0x0f0f0f0f0f0f0f0ful;	      \
	l4f1_c = l4f1_c + (l4f1_c >> 8);				      \
	l4f1_c = l4f1_c + (l4f1_c >> 16);				      \
    }
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# define l2_2_heap(l4f1_c) \
    {									      \
	l2_2_heap_1up(l4f1_c);						      \
	l4f1_c = l4f1_c + (l4f1_c >> 32);				      \
    }
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# undef l2_2_bitcount
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# define l2_2_bitcount(l4f1_bitcount, l4f1_mode) \
    {									      \
	BITS_LONG l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l2_2_heap(l4f1_c);						      \
									      \
	(l4f1_bitcount) = l4f1_c & 255;					      \
    }
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_VOID_P == SIZEOF_UNSIGNED
# define l2_q_heap_1up(l4f1_c) \
    l2_1_heap_1up((l4f1_c))
#else
# define l2_q_heap_1up(l4f1_c) \
    l2_2_heap_1up((l4f1_c))
#endif				/* SIZEOF_VOID_P == SIZEOF_UNSIGNED */

#if SIZEOF_VOID_P == SIZEOF_UNSIGNED
# define l2_q_heap(l4f1_c) \
    l2_1_heap((l4f1_c))
#else
# define l2_q_heap(l4f1_c) \
    l2_2_heap((l4f1_c))
#endif				/* SIZEOF_VOID_P == SIZEOF_UNSIGNED */

#if SIZEOF_VOID_P == SIZEOF_UNSIGNED
# define l2_q_bitcount(l4f1_bitcount, l4f1_mode) \
    l2_1_bitcount((l4f1_bitcount), (l4f1_mode))
#else
# define l2_q_bitcount(l4f1_bitcount, l4f1_mode) \
    l2_2_bitcount((l4f1_bitcount), (l4f1_mode))
#endif				/* SIZEOF_VOID_P == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
# define l2_2_heap_1up(l4f1_c) \
    l2_1_heap_1up((l4f1_c))
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
# define l2_2_heap(l4f1_c) \
    l2_1_heap((l4f1_c))
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
# define l2_2_bitcount(l4f1_bitcount, l4f1_mode) \
    l2_1_bitcount((l4f1_bitcount), (l4f1_mode))
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#endif				/* __LIBx1f4_bcount_H__ */
