/*
 * af.p.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1n.h>
#include <af-inter.h>
#include <e4.h>
#include <nl.h>

static const struct x1f4_linetext_type linetext = {
/* *INDENT-OFF* */
    {	"",
	NULL,
	X1f4_E4_VOID,
	NULL,
	0,
	0,
	0
    },
    NULL
/* *INDENT-ON* */
};

int
_x1f4_push_effect(void *subtext, void **copy, void *last,
		  const struct x1f4_nodelink_type *nodelink_data)
{
    int status;

    do {
	void *half;

	half = (void *) &linetext;

	if (((const struct x1f4_linetext_type *) last)->function.flags
	    & X1f4_E4_NODE_LINK) {
	    status = _x1f4_a1_push_news(subtext, &half, last, nodelink_data);
	    if (status) {
		break;
	    }
	} else {
	    half = last;
	}

	status = _x1f4_slip_effect(subtext, copy);

	if (1) {
	    /*
	     * at the very least, _slip_effect attempted to destroy the object
	     */
	    *copy = half;
	}
    } while (0);

    return status;
}
