/*
 * af.m.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1n.h>
#include <e4.h>
#include <nt.h>

int
_x1f4_move_effect(void *subtext, void *effect,
		  const struct x1f4_nodelink_type *nodelink_miss,
		  const struct x1f4_nodelink_type *nodelink_push)
{
    int status;

    if (((const struct x1f4_linetext_type *) effect)->function.flags
	& X1f4_E4_NODE_LINK) {
	status = _x1f4_a1_move_news
	    (subtext, effect, nodelink_miss, nodelink_push);
    } else {
	status = 0;
    }

    return status;
}
