/*
 * af.l.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1n.h>
#include <e4.h>
#include <e4n.h>
#include <nt.h>

int
_x1f4_lead_effect(void *subtext, void **data)
{
    int status;
    unsigned flags;

    flags = ((const struct x1f4_linetext_type *) *data)->function.flags;

    if (flags & X1f4_E4_NODE_LINK) {
	status = _x1f4_a1_lead_news(subtext, data);
    } else {
	if (flags & X1f4_E4_NEWS_LINK) {
	    status = _x1f4_e4_lead_news(subtext, data);
	} else {
	    status = 0;
	}
    }

    return status;
}
