/*
 * af.0.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <af-inter.h>
#include <lxlead.h>
#include <nt.h>

int
_x1f4_type_effect(struct x1f4_nodetype_type *nodetype_data, int delete)
{
    nodetype_data->code = delete;
    nodetype_data->name = "(+-)";
    nodetype_data->size = 4;
    nodetype_data->flags = X1f4_LX_LINK_ACCESS;

    nodetype_data->call = x1f4_call_lxlead;
    nodetype_data->copy = _x1f4_copy_effect;
    nodetype_data->dump = _x1f4_dump_effect;
    nodetype_data->free = _x1f4_free_effect;
    nodetype_data->hash = _x1f4_hash_effect;
    nodetype_data->lead = _x1f4_lead_effect;
    nodetype_data->miss = x1f4_near_lxlead;
    nodetype_data->move = _x1f4_move_effect;
    nodetype_data->node = _x1f4_node_effect;
    nodetype_data->pick = NULL;
    nodetype_data->post = NULL;
    nodetype_data->pull = NULL;
    nodetype_data->push = _x1f4_push_effect;
    nodetype_data->slip = _x1f4_slip_effect;

    return 0;
}
