/*
 * a12nd.y.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-inter.h>
#include <e4.h>

static const struct x1f4_linetext_type linetext = {
/* *INDENT-OFF* */
    {
	"",
	NULL,
	X1f4_E4_VOID,
	NULL,
	0,
	0,
	0
    },
    NULL
/* *INDENT-ON* */
};

int
_x1f4_a1_flat_news(void *subtext, void **address)
{
    int status;

    /*
     * NOTES
     *
     * this isn't doing what other -flat- methods are doing, it should not be
     * called as any -flat- method is called.  it isn't restoring -*address-
     * to a proper value.
     */

    if (0) {
    } else {
	status = _x1f4_a1_side_news
	    (subtext,
	     (char *) *address - offsetof(struct a1_node_type, linetext));
	if (0) {
	} else {
	    /*
	     * at the very least, _side_news attempted to destroy the object
	     */
	    *address = (void *) &linetext;
	}
    }

    return status;
}
