/*
 * a12nd.w.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <dt.h>
#include <e4.h>
#include <lxcall.h>

extern const struct x1f4_datatype_type _x1f4_af_last_type;

static int land_call(void *, struct a1_shuffle_type *);
static int land_node(void *, int, struct a1_shuffle_type *);
static int land_text(void *, struct a1_shuffle_type *);

static int
land_call(void *link, struct a1_shuffle_type *shuffle_data)
{
    link = *(void **) link;

    return _libx1f4i0_lxcall_line_node
	(&shuffle_data->v, &shuffle_data->x, (void *) &_x1f4_af_last_type,
	 link);
}


static int
land_node(void *link, int type, struct a1_shuffle_type *shuffle_data)
{
    const char *name;
    int status;
    const struct x1f4_datatype_type *datatype_data;

    datatype_data = shuffle_data->u.datatype_data;
    name = datatype_data->name;
    while (name) {
	if (datatype_data->type == type) {
	    break;
	} else {
	    datatype_data++;
	    name = datatype_data->name;
	}
    }
    if (name) {
    } else {
	datatype_data = shuffle_data->u.sidetype_data;
	name = datatype_data->name;
	while (name) {
	    if (datatype_data->type == type) {
		break;
	    } else {
		datatype_data++;
		name = datatype_data->name;
	    }
	}
    }

    if (name) {
	if (datatype_data->lead) {
	    link = *(void **) link;

	    status = _libx1f4i0_lxcall_line_node
		(&shuffle_data->v, &shuffle_data->x, (void *) datatype_data,
		 link);
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


static int
land_text(void *link, struct a1_shuffle_type *shuffle_data)
{
    link = *(void **) link;

    return _libx1f4i0_lxcall_line_text
	(&shuffle_data->v, &shuffle_data->m, &shuffle_data->x, link);
}


int
_x1f4_a1_land_cast(void *link, int type, struct a1_shuffle_type *shuffle_data)
{
    int status;

    if (type < X1f4_E4_VOID) {
	if (type == X1f4_E4_TEXT) {
	    status = land_text(link, shuffle_data);
	} else {
	    status = 0;
	}
    } else {
	if (X1f4_E4_CALL < type) {
	    status = 0;
	    status = land_call(link, shuffle_data);
	} else {
	    status = land_node(link, type, shuffle_data);
	}
    }

    return status;
}
