/*
 * a12nd.u.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-inter.h>
#include <a1-types.h>
#include <exerrors.h>
#include <nl.h>
#include <tcvset.h>

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
_x1f4_a1_push_news(void *subtext, void **copy, void *last,
		   const struct x1f4_nodelink_type *nodelink_data)
{
    int status;
    struct a1_node_type *node_data;

    node_data = (void *)
	((char *) last - offsetof(struct a1_node_type, linetext));

    status = tccase(node_data->leadnode.line.text)->miss
	(&node_data->leadnode.line.pset, &node_data->leadnode.line.text,
	 nodelink_data, (void *) &node_data->trans);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	*copy = last;
    }

    return status;
}
