/*
 * a12nd.o.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-inter.h>
#include <a1-types.h>
#include <exerrors.h>
#include <lxlead.h>
#include <nl.h>
#include <tcvset.h>

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
_x1f4_a1_free_news(void *subtext, void *node,
		   struct x1f4_nodelink_type **nodelink,
		   const struct x1f4_nodelink_type *nodelink_data)
{
    int status;
    struct a1_node_type *node_data;
    unsigned call;

    node_data = (void *)
	((char *) node - offsetof(struct a1_node_type, linetext));

    call = node_data->leadnode.line.call;

    /*
     * FEATURES
     *
     * some code will work even without this test, but some will not.  among
     * the one that will not is _long_list/_near_list (some reasons recorded
     * there).
     *
     * (old note by now, might be meaningless)
     */
    if (call) {
	call--;
	if (call) {
	    /*
	     * _nodelink_data_ may actually be not present in the _pset_
	     * pointer set (as a result of a failed operation) and if that's
	     * the case processing should be allowed (i.e. a _miss_ call for a
	     * nonexistent _nodelink_data_ pointer should be successful (as it
	     * currently is))
	     */
	    status = tccase(node_data->leadnode.line.text)->miss
		(&node_data->leadnode.line.pset,
		 &node_data->leadnode.line.text, nodelink_data,
		 (void *) &node_data->trans);
	    if (status) {
		status = X1f4_EX_CRITICAL;
	    } else {
		node_data->leadnode.line.call = call;

		if (0) {
		} else {
		    status = x1f4_mind_lxlead
			(nodelink, &node_data->leadnode + 1);
		}
	    }
	} else {
	    status = _x1f4_a1_heap_news(subtext, nodelink, node_data);
	}
    } else {
	status = 0;
    }

    return status;
}
