/*
 * a12nd.m.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

#include <a1-defs.h>
#include <a1-types.h>
#include <e2list-inter.h>
#include <frame.h>

int
_x1f4_a1_call_auto(unsigned bits, const void *context)
{
    const struct a1_context_type *context_data;

    context_data = context;

    if (bits & CASTTYPE_LINK) {
	const struct frame_type *frame_data;

	frame_data = &context_data->were_f;
	if (frame_data->link == x1f4_link_e2list) {
	    if (frame_data->free != x1f4_free_e2list
		|| frame_data->mode != x1f4_mode_e2list
		|| frame_data->pick != x1f4_pick_e2list
		|| frame_data->slip != x1f4_slip_e2list) {
		fprintf(stderr, "Aime parser warning: it appears you have on"
			"ly partially copied the autolink record in the a1 p"
			"arsing context, the full record is now used.\n");
		fprintf(stderr, "Aime parser warning: this message will be r"
			"emoved in future releases.\n");
	    }
	}
    }

    return 0;
}
