/*
 * a12nd.l.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <tcvset.h>
#include <trans.h>

int
_x1f4_a1_fine_news(void *subtext, void *node)
{
    int excess, status;
    struct a1_node_type **fast, *node_data, *node_miss;

    node_data = node;

    status = _libx1f4i0_fini_tcvset
	(&node_data->leadnode.line.pset, &node_data->leadnode.line.text,
	 (void *) &node_data->trans);

    node_miss = node_data->node_data;
    fast = node_data->fast;

    if (fast) {
	*fast = node_miss;
    }

    if (node_miss) {
	node_miss->fast = fast;
    }

    excess = node_data->trans.free(node_data->trans.data, node_data);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}
