/*
 * a12nd.k.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#include <lxlead.h>
#include <nl.h>

int
_x1f4_a1_null_news(void *subtext, struct x1f4_nodelink_type **nodelink,
		   void *node)
{
    int excess, status = 0;

    excess = _x1f4_a1_miss_node(node);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    if (1) {
	struct a1_line_type *line_data;
	struct a1_node_type *node_data;
	struct x1f4_nodelink_type *nodelink_data, *nodelink_miss;

	if (nodelink) {
	    nodelink_data = *nodelink;
	} else {
	    nodelink_data = NULL;
	}

	node_data = node;

	nodelink_miss = &node_data->leadnode.link;

	line_data = node_data->line_data;
	while (line_data) {
	    struct a1_line_type *line_slip;

	    line_slip = line_data;

	    excess = _x1f4_a1_free_news
		(NULL, line_data->node, &nodelink_data, nodelink_miss);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }

	    line_data = line_data->line_data;

	    excess = node_data->trans.free(node_data->trans.data, line_slip);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}

	if (nodelink) {
	    *nodelink = nodelink_data;
	} else {
	    if (nodelink_data) {
		status = x1f4_fail_lxlead(nodelink_data);
	    }
	}
    }

    return status;
}
