/*
 * a12nd.h.c
 * Copyright (C) 2007-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <exerrors.h>
#include <lxcall.h>

int
_x1f4_a1_lead_blue(void **context, void **call, struct a1_link_type *link_data,
		   void *used)
{
    int status;
    struct a1_shuffle_type *shuffle_data;
    void *pick, **trip;

    pick = *call;

    trip = (void *) ((char *) used + (int) link_data->datatext.link);
    *trip = pick;

    shuffle_data = context[1];

    status = _libx1f4i0_lxcall_line_node
	(&shuffle_data->v, &shuffle_data->x, (void *) link_data->datatext.type,
	 pick);
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    }

    return status;
}
