/*
 * a12nd.g.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#include <c1i.h>
#include <e4.h>

int
_x1f4_a1_line_node(struct a1_shuffle_type *shuffle_data,
		   struct a1_node_type *node_data, unsigned slip, void **link)
{
    int status;

    status = shuffle_data->m.link
	(shuffle_data->m.data, link, slip + node_data->extension);
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	void **used;

	used = (void **) ((char *) *link + slip);
	used[X1f4_E4_USED_META] = shuffle_data;

	status = x1f4_pull_program(node_data->aime, used);
	if (status) {
	    shuffle_data->m.free(shuffle_data->m.data, *link);
	}
    }

    return status;
}
